/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi.impl;

import java.lang.reflect.Array;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.intellij.ide.util.PsiNavigationSupport;
import org.jetbrains.jet.internal.com.intellij.navigation.ItemPresentation;
import org.jetbrains.jet.internal.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.jet.internal.com.intellij.openapi.project.Project;
import org.jetbrains.jet.internal.com.intellij.openapi.util.Comparing;
import org.jetbrains.jet.internal.com.intellij.pom.Navigatable;
import org.jetbrains.jet.internal.com.intellij.psi.NavigatablePsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.jet.internal.com.intellij.psi.PsiFile;
import org.jetbrains.jet.internal.com.intellij.psi.PsiInvalidElementAccessException;
import org.jetbrains.jet.internal.com.intellij.psi.PsiManager;
import org.jetbrains.jet.internal.com.intellij.psi.PsiReference;
import org.jetbrains.jet.internal.com.intellij.psi.ResolveState;
import org.jetbrains.jet.internal.com.intellij.psi.impl.ElementBase;
import org.jetbrains.jet.internal.com.intellij.psi.impl.ResolveScopeManager;
import org.jetbrains.jet.internal.com.intellij.psi.impl.SharedPsiElementImplUtil;
import org.jetbrains.jet.internal.com.intellij.psi.scope.PsiScopeProcessor;
import org.jetbrains.jet.internal.com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.jet.internal.com.intellij.psi.search.SearchScope;
import org.jetbrains.jet.internal.com.intellij.util.IncorrectOperationException;
import org.jetbrains.jet.internal.com.intellij.util.ReflectionCache;

public abstract class PsiElementBase
extends ElementBase
implements NavigatablePsiElement {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.PsiElementBase");

    @Override
    public PsiElement getFirstChild() {
        PsiElement[] children = this.getChildren();
        if (children.length == 0) {
            return null;
        }
        return children[0];
    }

    @Override
    public PsiElement getLastChild() {
        PsiElement[] children = this.getChildren();
        if (children.length == 0) {
            return null;
        }
        return children[children.length - 1];
    }

    @Override
    public PsiElement getNextSibling() {
        return SharedPsiElementImplUtil.getNextSibling(this);
    }

    @Override
    public PsiElement getPrevSibling() {
        return SharedPsiElementImplUtil.getPrevSibling(this);
    }

    @Override
    public void acceptChildren(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiElementBase.acceptChildren must not be null");
        }
        for (PsiElement child = this.getFirstChild(); child != null; child = child.getNextSibling()) {
            child.accept(visitor);
        }
    }

    @Override
    public PsiReference getReference() {
        return null;
    }

    @Override
    @NotNull
    public PsiReference[] getReferences() {
        PsiReference[] psiReferenceArray = SharedPsiElementImplUtil.getReferences(this);
        if (psiReferenceArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiElementBase.getReferences must not return null");
        }
        return psiReferenceArray;
    }

    @Override
    public PsiReference findReferenceAt(int offset) {
        return SharedPsiElementImplUtil.findReferenceAt(this, offset);
    }

    @Override
    public PsiElement addRange(PsiElement first, PsiElement last) throws IncorrectOperationException {
        throw new IncorrectOperationException("Operation not supported in: " + this.getClass());
    }

    @Override
    public PsiElement addRangeBefore(@NotNull PsiElement first, @NotNull PsiElement last, PsiElement anchor) throws IncorrectOperationException {
        if (first == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiElementBase.addRangeBefore must not be null");
        }
        if (last == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/PsiElementBase.addRangeBefore must not be null");
        }
        throw new IncorrectOperationException("Operation not supported in: " + this.getClass());
    }

    @Override
    public PsiElement addRangeAfter(PsiElement first, PsiElement last, PsiElement anchor) throws IncorrectOperationException {
        throw new IncorrectOperationException("Operation not supported in: " + this.getClass());
    }

    @Override
    public void deleteChildRange(PsiElement first, PsiElement last) throws IncorrectOperationException {
        throw new IncorrectOperationException("Operation not supported in: " + this.getClass());
    }

    @Override
    public boolean textContains(char c) {
        return this.getText().indexOf(c) >= 0;
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiElementBase.processDeclarations must not be null");
        }
        if (state == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/PsiElementBase.processDeclarations must not be null");
        }
        if (place == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/psi/impl/PsiElementBase.processDeclarations must not be null");
        }
        return true;
    }

    @Override
    public PsiElement getContext() {
        return this.getParent();
    }

    @Override
    @NotNull
    public PsiElement getNavigationElement() {
        PsiElementBase psiElementBase = this;
        if (psiElementBase == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiElementBase.getNavigationElement must not return null");
        }
        return psiElementBase;
    }

    @Override
    public PsiElement getOriginalElement() {
        return this;
    }

    @Override
    @NotNull
    public GlobalSearchScope getResolveScope() {
        GlobalSearchScope globalSearchScope = ResolveScopeManager.getElementResolveScope(this);
        if (globalSearchScope == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiElementBase.getResolveScope must not return null");
        }
        return globalSearchScope;
    }

    @Override
    @NotNull
    public SearchScope getUseScope() {
        GlobalSearchScope globalSearchScope = ResolveScopeManager.getElementUseScope(this);
        if (globalSearchScope == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiElementBase.getUseScope must not return null");
        }
        return globalSearchScope;
    }

    @Override
    public void navigate(boolean requestFocus) {
        Navigatable descriptor = PsiNavigationSupport.getInstance().getDescriptor(this);
        if (descriptor != null) {
            descriptor.navigate(requestFocus);
        }
    }

    @Override
    public boolean canNavigate() {
        return PsiNavigationSupport.getInstance().canNavigate(this);
    }

    @Override
    public boolean canNavigateToSource() {
        return this.canNavigate();
    }

    @Override
    @NotNull
    public Project getProject() {
        PsiManager manager = this.getManager();
        if (manager == null) {
            throw new PsiInvalidElementAccessException(this);
        }
        Project project = manager.getProject();
        if (project == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiElementBase.getProject must not return null");
        }
        return project;
    }

    @Override
    public ItemPresentation getPresentation() {
        return null;
    }

    @Override
    public boolean isEquivalentTo(PsiElement another) {
        return this == another;
    }

    @Override
    public PsiFile getContainingFile() {
        PsiElement parent = this.getParent();
        if (parent == null) {
            throw new PsiInvalidElementAccessException(this);
        }
        return parent.getContainingFile();
    }

    @Override
    public boolean isPhysical() {
        PsiElement parent = this.getParent();
        return parent != null && parent.isPhysical();
    }

    @Override
    public boolean isWritable() {
        PsiElement parent = this.getParent();
        return parent != null && parent.isWritable();
    }

    @Override
    public boolean isValid() {
        PsiElement parent = this.getParent();
        return parent != null && parent.isValid();
    }

    @Override
    public boolean textMatches(@NotNull CharSequence text) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiElementBase.textMatches must not be null");
        }
        return Comparing.equal((CharSequence)this.getText(), text, true);
    }

    @Override
    public boolean textMatches(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiElementBase.textMatches must not be null");
        }
        return this.getText().equals(element.getText());
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiElementBase.accept must not be null");
        }
        visitor.visitElement(this);
    }

    @Override
    public String getName() {
        return null;
    }

    @NotNull
    protected <T> T notNullChild(T child) {
        if (child == null) {
            LOG.error(this.getText() + "\n parent=" + this.getParent().getText());
        }
        T t = child;
        if (t == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiElementBase.notNullChild must not return null");
        }
        return t;
    }

    @NotNull
    protected <T> T[] findChildrenByClass(Class<T> aClass) {
        ArrayList<PsiElement> result = new ArrayList<PsiElement>();
        for (PsiElement cur = this.getFirstChild(); cur != null; cur = cur.getNextSibling()) {
            if (!ReflectionCache.isInstance(cur, aClass)) continue;
            result.add(cur);
        }
        Object[] objectArray = result.toArray((Object[])Array.newInstance(aClass, result.size()));
        if (objectArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiElementBase.findChildrenByClass must not return null");
        }
        return objectArray;
    }

    @Nullable
    protected <T> T findChildByClass(Class<T> aClass) {
        for (PsiElement cur = this.getFirstChild(); cur != null; cur = cur.getNextSibling()) {
            if (!ReflectionCache.isInstance(cur, aClass)) continue;
            return (T)cur;
        }
        return null;
    }

    @NotNull
    protected <T> T findNotNullChildByClass(Class<T> aClass) {
        T t = this.notNullChild(this.findChildByClass(aClass));
        if (t == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiElementBase.findNotNullChildByClass must not return null");
        }
        return t;
    }
}

