/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.intellij.openapi.components.ServiceManager;
import org.jetbrains.jet.internal.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.jet.internal.com.intellij.openapi.progress.ProgressIndicatorProvider;
import org.jetbrains.jet.internal.com.intellij.openapi.roots.FileIndexFacade;
import org.jetbrains.jet.internal.com.intellij.openapi.util.Comparing;
import org.jetbrains.jet.internal.com.intellij.openapi.util.Iconable;
import org.jetbrains.jet.internal.com.intellij.openapi.util.Key;
import org.jetbrains.jet.internal.com.intellij.openapi.util.Pair;
import org.jetbrains.jet.internal.com.intellij.openapi.util.UserDataHolderEx;
import org.jetbrains.jet.internal.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.jet.internal.com.intellij.psi.JavaDirectoryService;
import org.jetbrains.jet.internal.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.jet.internal.com.intellij.psi.PsiAnonymousClass;
import org.jetbrains.jet.internal.com.intellij.psi.PsiArrayType;
import org.jetbrains.jet.internal.com.intellij.psi.PsiClass;
import org.jetbrains.jet.internal.com.intellij.psi.PsiClassType;
import org.jetbrains.jet.internal.com.intellij.psi.PsiCompiledElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiDirectory;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElementFactory;
import org.jetbrains.jet.internal.com.intellij.psi.PsiField;
import org.jetbrains.jet.internal.com.intellij.psi.PsiFile;
import org.jetbrains.jet.internal.com.intellij.psi.PsiFileFactory;
import org.jetbrains.jet.internal.com.intellij.psi.PsiJavaFile;
import org.jetbrains.jet.internal.com.intellij.psi.PsiManager;
import org.jetbrains.jet.internal.com.intellij.psi.PsiMember;
import org.jetbrains.jet.internal.com.intellij.psi.PsiMethod;
import org.jetbrains.jet.internal.com.intellij.psi.PsiModifierList;
import org.jetbrains.jet.internal.com.intellij.psi.PsiPackage;
import org.jetbrains.jet.internal.com.intellij.psi.PsiParameter;
import org.jetbrains.jet.internal.com.intellij.psi.PsiReferenceList;
import org.jetbrains.jet.internal.com.intellij.psi.PsiSubstitutor;
import org.jetbrains.jet.internal.com.intellij.psi.PsiTarget;
import org.jetbrains.jet.internal.com.intellij.psi.PsiType;
import org.jetbrains.jet.internal.com.intellij.psi.PsiTypeParameter;
import org.jetbrains.jet.internal.com.intellij.psi.PsiTypeParameterList;
import org.jetbrains.jet.internal.com.intellij.psi.ResolveState;
import org.jetbrains.jet.internal.com.intellij.psi.filters.ElementFilter;
import org.jetbrains.jet.internal.com.intellij.psi.filters.OrFilter;
import org.jetbrains.jet.internal.com.intellij.psi.impl.ElementBase;
import org.jetbrains.jet.internal.com.intellij.psi.impl.ElementPresentationUtil;
import org.jetbrains.jet.internal.com.intellij.psi.impl.PsiImplUtil;
import org.jetbrains.jet.internal.com.intellij.psi.impl.ResolveScopeManager;
import org.jetbrains.jet.internal.com.intellij.psi.impl.compiled.ClsElementImpl;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.PsiImmediateClassType;
import org.jetbrains.jet.internal.com.intellij.psi.infos.MethodCandidateInfo;
import org.jetbrains.jet.internal.com.intellij.psi.scope.ElementClassFilter;
import org.jetbrains.jet.internal.com.intellij.psi.scope.ElementClassHint;
import org.jetbrains.jet.internal.com.intellij.psi.scope.NameHint;
import org.jetbrains.jet.internal.com.intellij.psi.scope.PsiScopeProcessor;
import org.jetbrains.jet.internal.com.intellij.psi.scope.processor.FilterScopeProcessor;
import org.jetbrains.jet.internal.com.intellij.psi.scope.processor.MethodResolverProcessor;
import org.jetbrains.jet.internal.com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.jet.internal.com.intellij.psi.search.LocalSearchScope;
import org.jetbrains.jet.internal.com.intellij.psi.search.PackageScope;
import org.jetbrains.jet.internal.com.intellij.psi.search.SearchScope;
import org.jetbrains.jet.internal.com.intellij.psi.util.CachedValue;
import org.jetbrains.jet.internal.com.intellij.psi.util.CachedValueProvider;
import org.jetbrains.jet.internal.com.intellij.psi.util.CachedValuesManager;
import org.jetbrains.jet.internal.com.intellij.psi.util.MethodSignature;
import org.jetbrains.jet.internal.com.intellij.psi.util.MethodSignatureUtil;
import org.jetbrains.jet.internal.com.intellij.psi.util.PsiModificationTracker;
import org.jetbrains.jet.internal.com.intellij.psi.util.PsiUtil;
import org.jetbrains.jet.internal.com.intellij.psi.util.TypeConversionUtil;
import org.jetbrains.jet.internal.com.intellij.ui.IconDeferrer;
import org.jetbrains.jet.internal.com.intellij.ui.RowIcon;
import org.jetbrains.jet.internal.com.intellij.util.Function;
import org.jetbrains.jet.internal.com.intellij.util.IncorrectOperationException;
import org.jetbrains.jet.internal.com.intellij.util.NullableFunction;
import org.jetbrains.jet.internal.com.intellij.util.ReflectionCache;
import org.jetbrains.jet.internal.com.intellij.util.SmartList;
import org.jetbrains.jet.internal.com.intellij.util.containers.HashMap;
import org.jetbrains.jet.internal.gnu.trove.THashSet;

public class PsiClassImplUtil {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.PsiClassImplUtil");
    private static final Key<CachedValue<Map>> MAP_IN_CLASS_KEY = Key.create("MAP_KEY");
    private static final Function<ClassIconRequest, Icon> FULL_ICON_EVALUATOR = new NullableFunction<ClassIconRequest, Icon>(){

        @Override
        public Icon fun(ClassIconRequest r) {
            if (!r.psiClass.isValid() || r.psiClass.getProject().isDisposed()) {
                return null;
            }
            boolean isLocked = (r.flags & 2) != 0 && !r.psiClass.isWritable();
            Icon symbolIcon = r.symbolIcon != null ? r.symbolIcon : ElementPresentationUtil.getClassIconOfKind(r.psiClass, ElementPresentationUtil.getClassKind(r.psiClass));
            RowIcon baseIcon = ElementPresentationUtil.createLayeredIcon(symbolIcon, r.psiClass, isLocked);
            return ElementPresentationUtil.addVisibilityIcon(r.psiClass, r.flags, baseIcon);
        }
    };

    private PsiClassImplUtil() {
    }

    @NotNull
    public static PsiField[] getAllFields(PsiClass aClass) {
        List<PsiField> map = PsiClassImplUtil.getAllByMap(aClass, PsiField.class);
        PsiField[] psiFieldArray = map.toArray(new PsiField[map.size()]);
        if (psiFieldArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiClassImplUtil.getAllFields must not return null");
        }
        return psiFieldArray;
    }

    @NotNull
    public static PsiMethod[] getAllMethods(PsiClass aClass) {
        List<PsiMethod> methods = PsiClassImplUtil.getAllByMap(aClass, PsiMethod.class);
        PsiMethod[] psiMethodArray = methods.toArray(new PsiMethod[methods.size()]);
        if (psiMethodArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiClassImplUtil.getAllMethods must not return null");
        }
        return psiMethodArray;
    }

    @NotNull
    public static PsiClass[] getAllInnerClasses(PsiClass aClass) {
        List<PsiClass> classes = PsiClassImplUtil.getAllByMap(aClass, PsiClass.class);
        PsiClass[] psiClassArray = classes.toArray(new PsiClass[classes.size()]);
        if (psiClassArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiClassImplUtil.getAllInnerClasses must not return null");
        }
        return psiClassArray;
    }

    @Nullable
    public static PsiField findFieldByName(PsiClass aClass, String name, boolean checkBases) {
        List<PsiField> byMap = PsiClassImplUtil.findByMap(aClass, name, checkBases, PsiField.class);
        return byMap.isEmpty() ? null : byMap.get(0);
    }

    @NotNull
    public static PsiMethod[] findMethodsByName(PsiClass aClass, String name, boolean checkBases) {
        List<PsiMethod> methods = PsiClassImplUtil.findByMap(aClass, name, checkBases, PsiMethod.class);
        PsiMethod[] psiMethodArray = methods.toArray(new PsiMethod[methods.size()]);
        if (psiMethodArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiClassImplUtil.findMethodsByName must not return null");
        }
        return psiMethodArray;
    }

    @Nullable
    public static PsiMethod findMethodBySignature(PsiClass aClass, PsiMethod patternMethod, boolean checkBases) {
        List<PsiMethod> result = PsiClassImplUtil.findMethodsBySignature(aClass, patternMethod, checkBases, true);
        return result.isEmpty() ? null : result.get(0);
    }

    @NotNull
    public static PsiMethod[] findMethodsBySignature(PsiClass aClass, PsiMethod patternMethod, boolean checkBases) {
        List<PsiMethod> methods = PsiClassImplUtil.findMethodsBySignature(aClass, patternMethod, checkBases, false);
        PsiMethod[] psiMethodArray = methods.toArray(new PsiMethod[methods.size()]);
        if (psiMethodArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiClassImplUtil.findMethodsBySignature must not return null");
        }
        return psiMethodArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private static List<PsiMethod> findMethodsBySignature(PsiClass aClass, PsiMethod patternMethod, boolean checkBases, boolean stopOnFirst) {
        List<PsiMethod> list;
        PsiMethod[] methodsByName = aClass.findMethodsByName(patternMethod.getName(), checkBases);
        if (methodsByName.length == 0) {
            list = Collections.emptyList();
            if (list == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiClassImplUtil.findMethodsBySignature must not return null");
            return list;
        }
        SmartList<PsiMethod> methods = new SmartList<PsiMethod>();
        MethodSignature patternSignature = patternMethod.getSignature(PsiSubstitutor.EMPTY);
        for (PsiMethod method : methodsByName) {
            PsiClass superClass = method.getContainingClass();
            PsiSubstitutor substitutor = checkBases && !aClass.equals(superClass) ? TypeConversionUtil.getSuperClassSubstitutor(superClass, aClass, PsiSubstitutor.EMPTY) : PsiSubstitutor.EMPTY;
            MethodSignature signature = method.getSignature(substitutor);
            if (!signature.equals(patternSignature)) continue;
            methods.add(method);
            if (stopOnFirst) break;
        }
        if ((list = methods) != null) return list;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiClassImplUtil.findMethodsBySignature must not return null");
    }

    @Nullable
    public static PsiClass findInnerByName(PsiClass aClass, String name, boolean checkBases) {
        List<PsiClass> byMap = PsiClassImplUtil.findByMap(aClass, name, checkBases, PsiClass.class);
        return byMap.isEmpty() ? null : byMap.get(0);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private static <T extends PsiMember> List<T> findByMap(PsiClass aClass, String name, boolean checkBases, Class<T> type) {
        List list;
        if (name == null) {
            list = Collections.emptyList();
            if (list == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiClassImplUtil.findByMap must not return null");
            return list;
        }
        if (!checkBases) {
            PsiMember[] members = null;
            if (ReflectionCache.isAssignable(type, PsiMethod.class)) {
                members = aClass.getMethods();
            } else if (ReflectionCache.isAssignable(type, PsiClass.class)) {
                members = aClass.getInnerClasses();
            } else if (ReflectionCache.isAssignable(type, PsiField.class)) {
                members = aClass.getFields();
            }
            if (members == null) {
                list = Collections.emptyList();
                if (list == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiClassImplUtil.findByMap must not return null");
                return list;
            } else {
                ArrayList list2 = new ArrayList();
                for (PsiMember member : members) {
                    if (!name.equals(member.getName())) continue;
                    list2.add(member);
                }
                list = list2;
                if (list == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiClassImplUtil.findByMap must not return null");
                return list;
            }
        }
        Map<String, List<Pair<T, PsiSubstitutor>>> allMethodsMap = PsiClassImplUtil.getMap(aClass, type);
        List<Pair<T, PsiSubstitutor>> list3 = allMethodsMap.get(name);
        if (list3 == null) {
            list = Collections.emptyList();
            if (list == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiClassImplUtil.findByMap must not return null");
            return list;
        }
        ArrayList ret = new ArrayList();
        for (Pair<T, PsiSubstitutor> info : list3) {
            ret.add(info.getFirst());
        }
        list = ret;
        if (list != null) return list;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiClassImplUtil.findByMap must not return null");
    }

    public static <T extends PsiMember> List<Pair<T, PsiSubstitutor>> getAllWithSubstitutorsByMap(PsiClass aClass, Class<T> type) {
        Map<String, List<Pair<T, PsiSubstitutor>>> allMap = PsiClassImplUtil.getMap(aClass, type);
        return allMap.get("Intellij-IDEA-ALL");
    }

    @NotNull
    private static <T extends PsiMember> List<T> getAllByMap(PsiClass aClass, Class<T> type) {
        List<Pair<T, PsiSubstitutor>> pairs = PsiClassImplUtil.getAllWithSubstitutorsByMap(aClass, type);
        assert (pairs != null) : "pairs should be already computed. Wrong allMap: " + PsiClassImplUtil.getMap(aClass, type);
        ArrayList<PsiMember> ret = new ArrayList<PsiMember>(pairs.size());
        for (int i = 0; i < pairs.size(); ++i) {
            Pair<T, PsiSubstitutor> pair = pairs.get(i);
            PsiMember t = (PsiMember)pair.getFirst();
            LOG.assertTrue(t != null, aClass);
            ret.add(t);
        }
        ArrayList<PsiMember> arrayList = ret;
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiClassImplUtil.getAllByMap must not return null");
        }
        return arrayList;
    }

    private static Map<Class<? extends PsiMember>, Map<String, List<Pair<PsiMember, PsiSubstitutor>>>> buildAllMaps(PsiClass psiClass) {
        final ArrayList<Pair<PsiMember, PsiSubstitutor>> classes = new ArrayList<Pair<PsiMember, PsiSubstitutor>>();
        final ArrayList<Pair<PsiMember, PsiSubstitutor>> fields = new ArrayList<Pair<PsiMember, PsiSubstitutor>>();
        final ArrayList<Pair<PsiMember, PsiSubstitutor>> methods = new ArrayList<Pair<PsiMember, PsiSubstitutor>>();
        FilterScopeProcessor<MethodCandidateInfo> processor = new FilterScopeProcessor<MethodCandidateInfo>((ElementFilter)new OrFilter(ElementClassFilter.METHOD, ElementClassFilter.FIELD, ElementClassFilter.CLASS)){

            @Override
            protected void add(PsiElement element, PsiSubstitutor substitutor) {
                if (element instanceof PsiMethod) {
                    methods.add(new Pair<PsiMethod, PsiSubstitutor>((PsiMethod)element, substitutor));
                } else if (element instanceof PsiField) {
                    fields.add(new Pair<PsiField, PsiSubstitutor>((PsiField)element, substitutor));
                } else if (element instanceof PsiClass) {
                    classes.add(new Pair<PsiClass, PsiSubstitutor>((PsiClass)element, substitutor));
                }
            }
        };
        PsiClassImplUtil.processDeclarationsInClassNotCached(psiClass, processor, ResolveState.initial(), new THashSet<PsiClass>(), null, psiClass, false);
        HashMap<Class<? extends PsiMember>, Map<String, List<Pair<PsiMember, PsiSubstitutor>>>> result = new HashMap<Class<? extends PsiMember>, Map<String, List<Pair<PsiMember, PsiSubstitutor>>>>(3);
        result.put(PsiClass.class, PsiClassImplUtil.generateMapByList(classes));
        result.put(PsiMethod.class, PsiClassImplUtil.generateMapByList(methods));
        result.put(PsiField.class, PsiClassImplUtil.generateMapByList(fields));
        return result;
    }

    private static Map<String, List<Pair<PsiMember, PsiSubstitutor>>> generateMapByList(@NotNull List<Pair<PsiMember, PsiSubstitutor>> list) {
        if (list == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiClassImplUtil.generateMapByList must not be null");
        }
        HashMap<String, List<Pair<PsiMember, PsiSubstitutor>>> map = new HashMap<String, List<Pair<PsiMember, PsiSubstitutor>>>();
        map.put("Intellij-IDEA-ALL", list);
        for (Pair<PsiMember, PsiSubstitutor> info : list) {
            PsiMember element = info.getFirst();
            String currentName = element.getName();
            ArrayList<Pair<PsiMember, PsiSubstitutor>> listByName = (ArrayList<Pair<PsiMember, PsiSubstitutor>>)map.get(currentName);
            if (listByName == null) {
                listByName = new ArrayList<Pair<PsiMember, PsiSubstitutor>>(1);
                map.put(currentName, listByName);
            }
            listByName.add(info);
        }
        return map;
    }

    private static <T extends PsiMember> Map<String, List<Pair<T, PsiSubstitutor>>> getMap(PsiClass aClass, Class<T> memberClazz) {
        CachedValue<Map> value = aClass.getUserData(MAP_IN_CLASS_KEY);
        if (value == null) {
            ByNameCachedValueProvider provider = new ByNameCachedValueProvider(aClass);
            value = CachedValuesManager.getManager(aClass.getProject()).createCachedValue(provider, false);
            if (aClass.isPhysical()) {
                value = ((UserDataHolderEx)((Object)aClass)).putUserDataIfAbsent(MAP_IN_CLASS_KEY, value);
            }
        }
        return PsiClassImplUtil.getCachedMembers(value, memberClazz);
    }

    private static <T extends PsiMember> Map<String, List<Pair<T, PsiSubstitutor>>> getCachedMembers(CachedValue<Map> value, Class<T> memberClazz) {
        return (Map)value.getValue().get(memberClazz);
    }

    public static Icon getClassIcon(int flags, PsiClass aClass) {
        return PsiClassImplUtil.getClassIcon(flags, aClass, null);
    }

    public static Icon getClassIcon(int flags, PsiClass aClass, @Nullable Icon symbolIcon) {
        Icon base = Iconable.LastComputedIcon.get(aClass, flags);
        if (base == null) {
            if (symbolIcon == null) {
                symbolIcon = ElementPresentationUtil.getClassIconOfKind(aClass, ElementPresentationUtil.getBasicClassKind(aClass));
            }
            RowIcon baseIcon = ElementBase.createLayeredIcon(aClass, symbolIcon, 0);
            base = ElementPresentationUtil.addVisibilityIcon(aClass, flags, baseIcon);
        }
        return IconDeferrer.getInstance().defer(base, new ClassIconRequest(aClass, flags, symbolIcon), FULL_ICON_EVALUATOR);
    }

    public static SearchScope getClassUseScope(PsiClass aClass) {
        PsiDirectory dir;
        GlobalSearchScope maximalUseScope = ResolveScopeManager.getElementUseScope(aClass);
        if (aClass instanceof PsiAnonymousClass) {
            return new LocalSearchScope(aClass);
        }
        PsiFile file = aClass.getContainingFile();
        if (PsiImplUtil.isInServerPage(file)) {
            return maximalUseScope;
        }
        PsiClass containingClass = aClass.getContainingClass();
        if (aClass.hasModifierProperty("public") || aClass.hasModifierProperty("protected")) {
            return containingClass != null ? containingClass.getUseScope() : maximalUseScope;
        }
        if (aClass.hasModifierProperty("private") || aClass instanceof PsiTypeParameter) {
            PsiClass topClass = PsiUtil.getTopLevelClass(aClass);
            return new LocalSearchScope(topClass == null ? aClass.getContainingFile() : topClass);
        }
        PsiPackage aPackage = null;
        if (file instanceof PsiJavaFile) {
            aPackage = JavaPsiFacade.getInstance(aClass.getProject()).findPackage(((PsiJavaFile)file).getPackageName());
        }
        if (aPackage == null && (dir = file.getContainingDirectory()) != null) {
            aPackage = JavaDirectoryService.getInstance().getPackage(dir);
        }
        if (aPackage != null) {
            SearchScope scope = PackageScope.packageScope(aPackage, false);
            scope = ((SearchScope)scope).intersectWith(maximalUseScope);
            return scope;
        }
        return new LocalSearchScope(file);
    }

    public static boolean isMainMethod(PsiMethod method) {
        if (!PsiType.VOID.equals(method.getReturnType())) {
            return false;
        }
        String name = method.getName();
        if (!"main".equals(name) && !"premain".equals(name)) {
            return false;
        }
        PsiElementFactory factory = JavaPsiFacade.getInstance(method.getProject()).getElementFactory();
        MethodSignature signature = method.getSignature(PsiSubstitutor.EMPTY);
        try {
            MethodSignature main = PsiClassImplUtil.createSignatureFromText(factory, "void main(String[] args);");
            if (MethodSignatureUtil.areSignaturesEqual(signature, main)) {
                return true;
            }
            MethodSignature premain = PsiClassImplUtil.createSignatureFromText(factory, "void premain(String args, java.lang.instrument.Instrumentation i);");
            if (MethodSignatureUtil.areSignaturesEqual(signature, premain)) {
                return true;
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error(e);
        }
        return false;
    }

    private static MethodSignature createSignatureFromText(PsiElementFactory factory, String text) {
        return factory.createMethodFromText(text, null).getSignature(PsiSubstitutor.EMPTY);
    }

    public static boolean processDeclarationsInClass(PsiClass aClass, PsiScopeProcessor processor, ResolveState state, @Nullable Set<PsiClass> visited, PsiElement last, PsiElement place, boolean isRaw) {
        NameHint nameHint;
        if (last instanceof PsiTypeParameterList || last instanceof PsiModifierList) {
            return true;
        }
        if (visited != null && visited.contains(aClass)) {
            return true;
        }
        PsiSubstitutor substitutor = state.get(PsiSubstitutor.KEY);
        isRaw = isRaw || PsiUtil.isRawSubstitutor(aClass, substitutor);
        CachedValue<Map> cache = aClass.getUserData(MAP_IN_CLASS_KEY);
        if (cache != null && cache.hasUpToDateValue() && (nameHint = processor.getHint(NameHint.KEY)) != null) {
            return PsiClassImplUtil.processCachedMembersByName(aClass, processor, state, visited, last, place, isRaw, substitutor, cache, nameHint);
        }
        return PsiClassImplUtil.processDeclarationsInClassNotCached(aClass, processor, state, visited, last, place, isRaw);
    }

    private static boolean processCachedMembersByName(PsiClass aClass, PsiScopeProcessor processor, ResolveState state, @Nullable Set<PsiClass> visited, PsiElement last, PsiElement place, boolean isRaw, PsiSubstitutor substitutor, CachedValue<Map> cache, NameHint nameHint) {
        PsiSubstitutor finalSubstitutor;
        List<Pair<PsiTarget, PsiSubstitutor>> list;
        ElementClassHint classHint = processor.getHint(ElementClassHint.KEY);
        PsiElementFactory factory = JavaPsiFacade.getInstance(aClass.getProject()).getElementFactory();
        if (classHint == null || classHint.shouldProcess(ElementClassHint.DeclarationKind.FIELD)) {
            PsiField fieldByName = aClass.findFieldByName(nameHint.getName(state), false);
            if (fieldByName != null) {
                processor.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, aClass);
                if (!processor.execute(fieldByName, state)) {
                    return false;
                }
            } else {
                Map<String, List<Pair<PsiField, PsiSubstitutor>>> allFieldsMap = PsiClassImplUtil.getCachedMembers(cache, PsiField.class);
                list = allFieldsMap.get(nameHint.getName(state));
                if (list != null) {
                    for (Pair<PsiTarget, PsiSubstitutor> candidate : list) {
                        PsiField candidateField = candidate.getFirst();
                        finalSubstitutor = PsiClassImplUtil.obtainFinalSubstitutor(candidateField.getContainingClass(), candidate.getSecond(), aClass, substitutor, place, factory);
                        processor.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, candidateField.getContainingClass());
                        if (processor.execute(candidateField, state.put(PsiSubstitutor.KEY, finalSubstitutor))) continue;
                        return false;
                    }
                }
            }
        }
        if (classHint == null || classHint.shouldProcess(ElementClassHint.DeclarationKind.CLASS)) {
            if (last != null && last.getParent() == aClass) {
                if (last instanceof PsiClass && !processor.execute(last, state)) {
                    return false;
                }
                PsiTypeParameterList list2 = aClass.getTypeParameterList();
                if (list2 != null && !list2.processDeclarations(processor, state, last, place)) {
                    return false;
                }
            }
            if (!(last instanceof PsiReferenceList)) {
                PsiClass classByName = aClass.findInnerClassByName(nameHint.getName(state), false);
                if (classByName != null) {
                    processor.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, aClass);
                    if (!processor.execute(classByName, state)) {
                        return false;
                    }
                } else {
                    Map<String, List<Pair<PsiClass, PsiSubstitutor>>> allClassesMap = PsiClassImplUtil.getCachedMembers(cache, PsiClass.class);
                    list = allClassesMap.get(nameHint.getName(state));
                    if (list != null) {
                        for (Pair<PsiTarget, PsiSubstitutor> candidate : list) {
                            PsiClass inner = (PsiClass)candidate.getFirst();
                            PsiClass containingClass = inner.getContainingClass();
                            if (containingClass == null) continue;
                            PsiSubstitutor finalSubstitutor2 = PsiClassImplUtil.obtainFinalSubstitutor(containingClass, candidate.getSecond(), aClass, substitutor, place, factory);
                            processor.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, containingClass);
                            if (processor.execute(inner, state.put(PsiSubstitutor.KEY, finalSubstitutor2))) continue;
                            return false;
                        }
                    }
                }
            }
        }
        if (classHint == null || classHint.shouldProcess(ElementClassHint.DeclarationKind.METHOD)) {
            MethodResolverProcessor methodResolverProcessor;
            if (processor instanceof MethodResolverProcessor && (methodResolverProcessor = (MethodResolverProcessor)processor).isConstructor()) {
                PsiMethod[] constructors = aClass.getConstructors();
                methodResolverProcessor.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, aClass);
                for (PsiMethod constructor : constructors) {
                    if (methodResolverProcessor.execute(constructor, state)) continue;
                    return false;
                }
                return true;
            }
            Map<String, List<Pair<PsiMethod, PsiSubstitutor>>> allMethodsMap = PsiClassImplUtil.getCachedMembers(cache, PsiMethod.class);
            List<Pair<PsiMethod, PsiSubstitutor>> list3 = allMethodsMap.get(nameHint.getName(state));
            if (list3 != null) {
                for (Pair<PsiMethod, PsiSubstitutor> candidate : list3) {
                    ProgressIndicatorProvider.checkCanceled();
                    PsiMethod candidateMethod = candidate.getFirst();
                    if (processor instanceof MethodResolverProcessor && candidateMethod.isConstructor() != ((MethodResolverProcessor)processor).isConstructor()) continue;
                    PsiClass containingClass = candidateMethod.getContainingClass();
                    if (visited != null && visited.contains(candidateMethod.getContainingClass())) continue;
                    finalSubstitutor = PsiClassImplUtil.obtainFinalSubstitutor(containingClass, candidate.getSecond(), aClass, substitutor, place, factory);
                    finalSubstitutor = PsiClassImplUtil.checkRaw(isRaw, factory, candidateMethod, finalSubstitutor);
                    processor.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, containingClass);
                    if (processor.execute(candidateMethod, state.put(PsiSubstitutor.KEY, finalSubstitutor))) continue;
                    return false;
                }
                if (visited != null) {
                    for (Pair<PsiMethod, PsiSubstitutor> aList : list3) {
                        visited.add(aList.getFirst().getContainingClass());
                    }
                }
            }
        }
        return true;
    }

    private static PsiSubstitutor checkRaw(boolean isRaw, PsiElementFactory factory, PsiMethod candidateMethod, PsiSubstitutor substitutor) {
        if (isRaw && !candidateMethod.hasModifierProperty("static")) {
            PsiTypeParameter[] methodTypeParameters = candidateMethod.getTypeParameters();
            substitutor = factory.createRawSubstitutor(substitutor, methodTypeParameters);
        }
        return substitutor;
    }

    public static PsiSubstitutor obtainFinalSubstitutor(@NotNull PsiClass candidateClass, PsiSubstitutor candidateSubstitutor, PsiClass aClass, PsiSubstitutor substitutor, PsiElement place, PsiElementFactory elementFactory) {
        if (candidateClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiClassImplUtil.obtainFinalSubstitutor must not be null");
        }
        if (PsiUtil.isRawSubstitutor(aClass, substitutor)) {
            return elementFactory.createRawSubstitutor(candidateClass);
        }
        PsiClassType containingType = elementFactory.createType(candidateClass, candidateSubstitutor, PsiUtil.getLanguageLevel(place));
        PsiType type = substitutor.substitute(containingType);
        if (!(type instanceof PsiClassType)) {
            return candidateSubstitutor;
        }
        return ((PsiClassType)type).resolveGenerics().getSubstitutor();
    }

    private static boolean processDeclarationsInClassNotCached(PsiClass aClass, PsiScopeProcessor processor, ResolveState state, @Nullable Set<PsiClass> visited, PsiElement last, PsiElement place, boolean isRaw) {
        if (visited == null) {
            visited = new THashSet<PsiClass>();
        }
        if (!visited.add(aClass)) {
            return true;
        }
        processor.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, aClass);
        ElementClassHint classHint = processor.getHint(ElementClassHint.KEY);
        NameHint nameHint = processor.getHint(NameHint.KEY);
        if (classHint == null || classHint.shouldProcess(ElementClassHint.DeclarationKind.FIELD)) {
            if (nameHint != null) {
                PsiField fieldByName = aClass.findFieldByName(nameHint.getName(state), false);
                if (fieldByName != null && !processor.execute(fieldByName, state)) {
                    return false;
                }
            } else {
                PsiField[] fields;
                for (PsiField field : fields = aClass.getFields()) {
                    if (processor.execute(field, state)) continue;
                    return false;
                }
            }
        }
        PsiElementFactory factory = JavaPsiFacade.getInstance(aClass.getProject()).getElementFactory();
        if (classHint == null || classHint.shouldProcess(ElementClassHint.DeclarationKind.METHOD)) {
            PsiMethod[] methods;
            PsiSubstitutor baseSubstitutor = state.get(PsiSubstitutor.KEY);
            for (PsiMethod method : methods = nameHint != null ? aClass.findMethodsByName(nameHint.getName(state), false) : aClass.getMethods()) {
                ResolveState methodState;
                PsiSubstitutor finalSubstitutor = PsiClassImplUtil.checkRaw(isRaw, factory, method, baseSubstitutor);
                ResolveState resolveState = methodState = finalSubstitutor == baseSubstitutor ? state : state.put(PsiSubstitutor.KEY, finalSubstitutor);
                if (processor.execute(method, methodState)) continue;
                return false;
            }
        }
        if (classHint == null || classHint.shouldProcess(ElementClassHint.DeclarationKind.CLASS)) {
            PsiTypeParameterList list;
            if (last != null && last.getParent() == aClass && (list = aClass.getTypeParameterList()) != null && !list.processDeclarations(processor, ResolveState.initial(), last, place)) {
                return false;
            }
            if (!(last instanceof PsiReferenceList) && !(last instanceof PsiModifierList)) {
                if (nameHint != null) {
                    PsiClass inner = aClass.findInnerClassByName(nameHint.getName(state), false);
                    if (inner != null && !processor.execute(inner, state)) {
                        return false;
                    }
                } else {
                    PsiClass[] inners;
                    for (PsiClass inner : inners = aClass.getInnerClasses()) {
                        if (processor.execute(inner, state)) continue;
                        return false;
                    }
                }
            }
        }
        return last instanceof PsiReferenceList || PsiClassImplUtil.processSuperTypes(aClass, processor, visited, last, place, state, isRaw, factory);
    }

    private static boolean processSuperTypes(PsiClass aClass, PsiScopeProcessor processor, Set<PsiClass> visited, PsiElement last, PsiElement place, ResolveState state, boolean isRaw, PsiElementFactory factory) {
        for (PsiClassType superType : aClass.getSuperTypes()) {
            PsiSubstitutor finalSubstitutor;
            PsiClassType.ClassResolveResult superTypeResolveResult = superType.resolveGenerics();
            PsiClass superClass = superTypeResolveResult.getElement();
            if (superClass == null || PsiClassImplUtil.processDeclarationsInClass(superClass, processor, state.put(PsiSubstitutor.KEY, finalSubstitutor = PsiClassImplUtil.obtainFinalSubstitutor(superClass, superTypeResolveResult.getSubstitutor(), aClass, state.get(PsiSubstitutor.KEY), place, factory)), visited, last, place, isRaw)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public static PsiClass getSuperClass(PsiClass psiClass) {
        PsiManager manager = psiClass.getManager();
        GlobalSearchScope resolveScope = psiClass.getResolveScope();
        JavaPsiFacade facade = JavaPsiFacade.getInstance(manager.getProject());
        if (psiClass.isInterface()) {
            return facade.findClass("java.lang.Object", resolveScope);
        }
        if (psiClass.isEnum()) {
            return facade.findClass("java.lang.Enum", resolveScope);
        }
        if (psiClass instanceof PsiAnonymousClass) {
            PsiClassType baseClassReference = ((PsiAnonymousClass)psiClass).getBaseClassType();
            PsiClass baseClass = baseClassReference.resolve();
            if (baseClass == null || baseClass.isInterface()) {
                return facade.findClass("java.lang.Object", resolveScope);
            }
            return baseClass;
        }
        if ("java.lang.Object".equals(psiClass.getQualifiedName())) {
            return null;
        }
        PsiClassType[] referenceElements = psiClass.getExtendsListTypes();
        if (referenceElements.length == 0) {
            return facade.findClass("java.lang.Object", resolveScope);
        }
        PsiClass psiResoved = referenceElements[0].resolve();
        return psiResoved == null ? facade.findClass("java.lang.Object", resolveScope) : psiResoved;
    }

    @NotNull
    public static PsiClass[] getSupers(PsiClass psiClass) {
        PsiClass[] supers;
        for (PsiClass aSuper : supers = PsiClassImplUtil.getSupersInner(psiClass)) {
            LOG.assertTrue(aSuper != null);
        }
        if (supers == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiClassImplUtil.getSupers must not return null");
        }
        return supers;
    }

    private static PsiClass[] getSupersInner(PsiClass psiClass) {
        PsiClassType[] extendsListTypes = psiClass.getExtendsListTypes();
        PsiClassType[] implementsListTypes = psiClass.getImplementsListTypes();
        if (psiClass.isInterface()) {
            return PsiClassImplUtil.resolveClassReferenceList(extendsListTypes, psiClass.getManager(), psiClass.getResolveScope(), true);
        }
        if (psiClass instanceof PsiAnonymousClass) {
            PsiClass[] psiClassArray;
            PsiAnonymousClass psiAnonymousClass = (PsiAnonymousClass)psiClass;
            PsiClassType baseClassReference = psiAnonymousClass.getBaseClassType();
            PsiClass baseClass = baseClassReference.resolve();
            if (baseClass != null) {
                if (baseClass.isInterface()) {
                    PsiClass[] psiClassArray2;
                    PsiClass objectClass = JavaPsiFacade.getInstance(psiClass.getProject()).findClass("java.lang.Object", psiClass.getResolveScope());
                    if (objectClass != null) {
                        PsiClass[] psiClassArray3 = new PsiClass[2];
                        psiClassArray3[0] = objectClass;
                        psiClassArray2 = psiClassArray3;
                        psiClassArray3[1] = baseClass;
                    } else {
                        PsiClass[] psiClassArray4 = new PsiClass[1];
                        psiClassArray2 = psiClassArray4;
                        psiClassArray4[0] = baseClass;
                    }
                    return psiClassArray2;
                }
                return new PsiClass[]{baseClass};
            }
            PsiClass objectClass = JavaPsiFacade.getInstance(psiClass.getProject()).findClass("java.lang.Object", psiClass.getResolveScope());
            if (objectClass != null) {
                PsiClass[] psiClassArray5 = new PsiClass[1];
                psiClassArray = psiClassArray5;
                psiClassArray5[0] = objectClass;
            } else {
                psiClassArray = PsiClass.EMPTY_ARRAY;
            }
            return psiClassArray;
        }
        if (psiClass instanceof PsiTypeParameter) {
            if (extendsListTypes.length == 0) {
                PsiClass[] psiClassArray;
                PsiClass objectClass = JavaPsiFacade.getInstance(psiClass.getProject()).findClass("java.lang.Object", psiClass.getResolveScope());
                if (objectClass != null) {
                    PsiClass[] psiClassArray6 = new PsiClass[1];
                    psiClassArray = psiClassArray6;
                    psiClassArray6[0] = objectClass;
                } else {
                    psiClassArray = PsiClass.EMPTY_ARRAY;
                }
                return psiClassArray;
            }
            return PsiClassImplUtil.resolveClassReferenceList(extendsListTypes, psiClass.getManager(), psiClass.getResolveScope(), false);
        }
        PsiClass[] interfaces = PsiClassImplUtil.resolveClassReferenceList(implementsListTypes, psiClass.getManager(), psiClass.getResolveScope(), false);
        PsiClass superClass = PsiClassImplUtil.getSuperClass(psiClass);
        if (superClass == null) {
            return interfaces;
        }
        PsiClass[] types = new PsiClass[interfaces.length + 1];
        types[0] = superClass;
        System.arraycopy(interfaces, 0, types, 1, interfaces.length);
        return types;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static PsiClassType[] getSuperTypes(PsiClass psiClass) {
        PsiClassType[] psiClassTypeArray;
        if (psiClass instanceof PsiAnonymousClass) {
            PsiClassType objectType;
            PsiClassType baseClassType = ((PsiAnonymousClass)psiClass).getBaseClassType();
            PsiClass baseClass = baseClassType.resolve();
            if (!(baseClass == null || !baseClass.isInterface() ? (psiClassTypeArray = new PsiClassType[]{baseClassType}) != null : (psiClassTypeArray = new PsiClassType[]{objectType = PsiType.getJavaLangObject(psiClass.getManager(), psiClass.getResolveScope()), baseClassType}) != null)) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiClassImplUtil.getSuperTypes must not return null");
            return psiClassTypeArray;
        }
        PsiClassType[] extendsTypes = psiClass.getExtendsListTypes();
        PsiClassType[] implementsTypes = psiClass.getImplementsListTypes();
        boolean hasExtends = extendsTypes.length != 0;
        int extendsListLength = extendsTypes.length + (hasExtends ? 0 : 1);
        PsiClassType[] result = new PsiClassType[extendsListLength + implementsTypes.length];
        System.arraycopy(extendsTypes, 0, result, 0, extendsTypes.length);
        if (!hasExtends) {
            PsiClassType objectType;
            if ("java.lang.Object".equals(psiClass.getQualifiedName())) {
                psiClassTypeArray = PsiClassType.EMPTY_ARRAY;
                if (PsiClassType.EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiClassImplUtil.getSuperTypes must not return null");
                return psiClassTypeArray;
            }
            PsiManager manager = psiClass.getManager();
            result[0] = objectType = PsiType.getJavaLangObject(manager, psiClass.getResolveScope());
        }
        System.arraycopy(implementsTypes, 0, result, extendsListLength, implementsTypes.length);
        for (int i = 0; i < result.length; ++i) {
            PsiClassType type = result[i];
            result[i] = (PsiClassType)PsiUtil.captureToplevelWildcards(type, psiClass);
        }
        psiClassTypeArray = result;
        if (result != null) return psiClassTypeArray;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiClassImplUtil.getSuperTypes must not return null");
    }

    private static PsiClassType getAnnotationSuperType(PsiClass psiClass, PsiElementFactory factory) {
        return factory.createTypeByFQClassName("java.lang.annotation.Annotation", psiClass.getResolveScope());
    }

    private static PsiClassType getEnumSuperType(PsiClass psiClass, PsiElementFactory factory) {
        PsiClassType superType;
        PsiManager manager = psiClass.getManager();
        PsiClass enumClass = JavaPsiFacade.getInstance(manager.getProject()).findClass("java.lang.Enum", psiClass.getResolveScope());
        if (enumClass == null) {
            try {
                superType = (PsiClassType)factory.createTypeFromText("java.lang.Enum", null);
            }
            catch (IncorrectOperationException e) {
                superType = null;
            }
        } else {
            PsiTypeParameter[] typeParameters = enumClass.getTypeParameters();
            PsiSubstitutor substitutor = PsiSubstitutor.EMPTY;
            if (typeParameters.length == 1) {
                substitutor = substitutor.put(typeParameters[0], factory.createType(psiClass));
            }
            superType = new PsiImmediateClassType(enumClass, substitutor);
        }
        return superType;
    }

    public static PsiClass[] getInterfaces(PsiTypeParameter typeParameter) {
        PsiClassType[] referencedTypes;
        ArrayList<PsiClass> result = new ArrayList<PsiClass>();
        for (PsiClassType referencedType : referencedTypes = typeParameter.getExtendsListTypes()) {
            PsiClass psiClass = referencedType.resolve();
            if (psiClass == null || !psiClass.isInterface()) continue;
            result.add(psiClass);
        }
        return result.toArray(new PsiClass[result.size()]);
    }

    public static PsiClass[] getInterfaces(PsiClass psiClass) {
        if (psiClass.isInterface()) {
            PsiClassType[] extendsListTypes = psiClass.getExtendsListTypes();
            return PsiClassImplUtil.resolveClassReferenceList(extendsListTypes, psiClass.getManager(), psiClass.getResolveScope(), false);
        }
        if (psiClass instanceof PsiAnonymousClass) {
            PsiClass[] psiClassArray;
            PsiClassType baseClassReference = ((PsiAnonymousClass)psiClass).getBaseClassType();
            PsiClass baseClass = baseClassReference.resolve();
            if (baseClass != null && baseClass.isInterface()) {
                PsiClass[] psiClassArray2 = new PsiClass[1];
                psiClassArray = psiClassArray2;
                psiClassArray2[0] = baseClass;
            } else {
                psiClassArray = PsiClass.EMPTY_ARRAY;
            }
            return psiClassArray;
        }
        PsiClassType[] implementsListTypes = psiClass.getImplementsListTypes();
        return PsiClassImplUtil.resolveClassReferenceList(implementsListTypes, psiClass.getManager(), psiClass.getResolveScope(), false);
    }

    private static PsiClass[] resolveClassReferenceList(PsiClassType[] listOfTypes, PsiManager manager, GlobalSearchScope resolveScope, boolean includeObject) {
        PsiClass objectClass = JavaPsiFacade.getInstance(manager.getProject()).findClass("java.lang.Object", resolveScope);
        if (objectClass == null) {
            includeObject = false;
        }
        if (listOfTypes == null || listOfTypes.length == 0) {
            if (includeObject) {
                return new PsiClass[]{objectClass};
            }
            return PsiClass.EMPTY_ARRAY;
        }
        int referenceCount = listOfTypes.length;
        if (includeObject) {
            ++referenceCount;
        }
        PsiClass[] resolved = new PsiClass[referenceCount];
        int resolvedCount = 0;
        if (includeObject) {
            resolved[resolvedCount++] = objectClass;
        }
        for (PsiClassType reference : listOfTypes) {
            PsiClass refResolved = reference.resolve();
            if (refResolved == null) continue;
            resolved[resolvedCount++] = refResolved;
        }
        if (resolvedCount < referenceCount) {
            PsiClass[] shorter = new PsiClass[resolvedCount];
            System.arraycopy(resolved, 0, shorter, 0, resolvedCount);
            resolved = shorter;
        }
        return resolved;
    }

    public static List<Pair<PsiMethod, PsiSubstitutor>> findMethodsAndTheirSubstitutorsByName(PsiClass psiClass, String name, boolean checkBases) {
        if (!checkBases) {
            PsiMethod[] methodsByName = psiClass.findMethodsByName(name, false);
            ArrayList<Pair<PsiMethod, PsiSubstitutor>> ret = new ArrayList<Pair<PsiMethod, PsiSubstitutor>>(methodsByName.length);
            for (PsiMethod method : methodsByName) {
                ret.add(new Pair<PsiMethod, PsiSubstitutor>(method, PsiSubstitutor.EMPTY));
            }
            return ret;
        }
        Map<String, List<Pair<PsiMethod, PsiSubstitutor>>> map = PsiClassImplUtil.getMap(psiClass, PsiMethod.class);
        List<Pair<PsiMethod, PsiSubstitutor>> list = map.get(name);
        return list == null ? Collections.emptyList() : Collections.unmodifiableList(list);
    }

    public static PsiClassType[] getExtendsListTypes(PsiClass psiClass) {
        if (psiClass.isEnum()) {
            return new PsiClassType[]{PsiClassImplUtil.getEnumSuperType(psiClass, JavaPsiFacade.getInstance(psiClass.getProject()).getElementFactory())};
        }
        if (psiClass.isAnnotationType()) {
            return new PsiClassType[]{PsiClassImplUtil.getAnnotationSuperType(psiClass, JavaPsiFacade.getInstance(psiClass.getProject()).getElementFactory())};
        }
        PsiReferenceList extendsList = psiClass.getExtendsList();
        if (extendsList != null) {
            return extendsList.getReferencedTypes();
        }
        return PsiClassType.EMPTY_ARRAY;
    }

    public static PsiClassType[] getImplementsListTypes(PsiClass psiClass) {
        PsiReferenceList extendsList = psiClass.getImplementsList();
        if (extendsList != null) {
            return extendsList.getReferencedTypes();
        }
        return PsiClassType.EMPTY_ARRAY;
    }

    public static boolean isClassEquivalentTo(PsiClass aClass, PsiElement another) {
        PsiFile original2;
        if (aClass == another) {
            return true;
        }
        if (!(another instanceof PsiClass)) {
            return false;
        }
        String name1 = aClass.getName();
        if (name1 == null) {
            return false;
        }
        if (!another.isValid()) {
            return false;
        }
        String name2 = ((PsiClass)another).getName();
        if (name2 == null) {
            return false;
        }
        if (name1.hashCode() != name2.hashCode()) {
            return false;
        }
        if (!name1.equals(name2)) {
            return false;
        }
        String qName1 = aClass.getQualifiedName();
        String qName2 = ((PsiClass)another).getQualifiedName();
        if (qName1 == null || qName2 == null) {
            if (qName1 != qName2) {
                return false;
            }
            if (aClass instanceof PsiTypeParameter && another instanceof PsiTypeParameter) {
                PsiTypeParameter p1 = (PsiTypeParameter)aClass;
                PsiTypeParameter p2 = (PsiTypeParameter)another;
                return p1.getIndex() == p2.getIndex() && aClass.getManager().areElementsEquivalent(p1.getOwner(), p2.getOwner());
            }
            return false;
        }
        if (qName1.hashCode() != qName2.hashCode() || !qName1.equals(qName2)) {
            return false;
        }
        if (PsiClassImplUtil.originalElement(aClass).equals(PsiClassImplUtil.originalElement((PsiClass)another))) {
            return true;
        }
        PsiFile file1 = aClass.getContainingFile().getOriginalFile();
        PsiFile file2 = another.getContainingFile().getOriginalFile();
        PsiFile original1 = file1.getUserData(PsiFileFactory.ORIGINAL_FILE);
        if (original1 == (original2 = file2.getUserData(PsiFileFactory.ORIGINAL_FILE)) && original1 != null || original1 == file2 || original2 == file1 || file1 == file2) {
            return PsiClassImplUtil.compareClassSeqNumber(aClass, (PsiClass)another);
        }
        FileIndexFacade fileIndex = ServiceManager.getService(file1.getProject(), FileIndexFacade.class);
        VirtualFile vfile1 = file1.getViewProvider().getVirtualFile();
        VirtualFile vfile2 = file2.getViewProvider().getVirtualFile();
        return !(!fileIndex.isInSource(vfile1) && !fileIndex.isInLibraryClasses(vfile1) || !fileIndex.isInSource(vfile2) && !fileIndex.isInLibraryClasses(vfile2));
    }

    private static boolean compareClassSeqNumber(PsiClass aClass, PsiClass another) {
        int index1 = PsiClassImplUtil.getSeqNumber(aClass);
        if (index1 == -1) {
            return true;
        }
        int index2 = PsiClassImplUtil.getSeqNumber(another);
        return index1 == index2;
    }

    private static int getSeqNumber(PsiClass aClass) {
        PsiElement parent = aClass.getParent();
        if (parent == null) {
            return -1;
        }
        int seqNo = 0;
        for (PsiElement child : parent.getChildren()) {
            if (child == aClass) {
                return seqNo;
            }
            if (!(child instanceof PsiClass) || !Comparing.strEqual(aClass.getName(), ((PsiClass)child).getName())) continue;
            ++seqNo;
        }
        return -1;
    }

    private static PsiElement originalElement(PsiClass aClass) {
        PsiElement originalElement = aClass.getOriginalElement();
        PsiCompiledElement compiled = originalElement.getUserData(ClsElementImpl.COMPILED_ELEMENT);
        if (compiled != null) {
            return compiled;
        }
        return originalElement;
    }

    public static boolean isFieldEquivalentTo(PsiField field, PsiElement another) {
        if (!(another instanceof PsiField)) {
            return false;
        }
        String name1 = field.getName();
        if (name1 == null) {
            return false;
        }
        if (!another.isValid()) {
            return false;
        }
        String name2 = ((PsiField)another).getName();
        if (!name1.equals(name2)) {
            return false;
        }
        PsiClass aClass1 = field.getContainingClass();
        PsiClass aClass2 = ((PsiField)another).getContainingClass();
        return aClass1 != null && aClass2 != null && field.getManager().areElementsEquivalent(aClass1, aClass2);
    }

    public static boolean isMethodEquivalentTo(PsiMethod method1, PsiElement another) {
        PsiParameter[] parameters2;
        if (method1 == another) {
            return true;
        }
        if (!(another instanceof PsiMethod)) {
            return false;
        }
        PsiMethod method2 = (PsiMethod)another;
        if (!another.isValid()) {
            return false;
        }
        if (!method1.getName().equals(method2.getName())) {
            return false;
        }
        PsiClass aClass1 = method1.getContainingClass();
        PsiClass aClass2 = method2.getContainingClass();
        PsiManager manager = method1.getManager();
        if (aClass1 == null || aClass2 == null || !manager.areElementsEquivalent(aClass1, aClass2)) {
            return false;
        }
        PsiParameter[] parameters1 = method1.getParameterList().getParameters();
        if (parameters1.length != (parameters2 = method2.getParameterList().getParameters()).length) {
            return false;
        }
        for (int i = 0; i < parameters1.length; ++i) {
            PsiType type2;
            PsiParameter parameter1 = parameters1[i];
            PsiParameter parameter2 = parameters2[i];
            PsiType type1 = parameter1.getType();
            if (PsiClassImplUtil.compareParamTypes(manager, type1, type2 = parameter2.getType())) continue;
            return false;
        }
        return true;
    }

    private static boolean compareParamTypes(@NotNull PsiManager manager, @NotNull PsiType type1, @NotNull PsiType type2) {
        if (manager == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiClassImplUtil.compareParamTypes must not be null");
        }
        if (type1 == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/PsiClassImplUtil.compareParamTypes must not be null");
        }
        if (type2 == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/psi/impl/PsiClassImplUtil.compareParamTypes must not be null");
        }
        if (type1 instanceof PsiArrayType) {
            if (!(type2 instanceof PsiArrayType)) {
                return false;
            }
            return PsiClassImplUtil.compareParamTypes(manager, ((PsiArrayType)type1).getComponentType(), ((PsiArrayType)type2).getComponentType());
        }
        if (!(type1 instanceof PsiClassType) || !(type2 instanceof PsiClassType)) {
            return type1.equals(type2);
        }
        PsiClass class1 = ((PsiClassType)type1).resolve();
        PsiClass class2 = ((PsiClassType)type2).resolve();
        if (class1 instanceof PsiTypeParameter && class2 instanceof PsiTypeParameter) {
            return Comparing.equal(class1.getName(), class2.getName()) && ((PsiTypeParameter)class1).getIndex() == ((PsiTypeParameter)class2).getIndex();
        }
        return manager.areElementsEquivalent(class1, class2);
    }

    private static class ByNameCachedValueProvider
    implements CachedValueProvider<Map> {
        private final PsiClass myClass;

        private ByNameCachedValueProvider(PsiClass aClass) {
            this.myClass = aClass;
        }

        @Override
        public CachedValueProvider.Result<Map> compute() {
            Map map = PsiClassImplUtil.buildAllMaps(this.myClass);
            return new CachedValueProvider.Result<Map>(map, PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT);
        }
    }

    private static class ClassIconRequest {
        public final PsiClass psiClass;
        public final int flags;
        public final Icon symbolIcon;

        private ClassIconRequest(PsiClass psiClass, int flags, Icon symbolIcon) {
            this.psiClass = psiClass;
            this.flags = flags;
            this.symbolIcon = symbolIcon;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ClassIconRequest)) {
                return false;
            }
            ClassIconRequest that = (ClassIconRequest)o;
            if (this.flags != that.flags) {
                return false;
            }
            return !(this.psiClass != null ? !this.psiClass.equals(that.psiClass) : that.psiClass != null);
        }

        public int hashCode() {
            int result = this.psiClass != null ? this.psiClass.hashCode() : 0;
            result = 31 * result + this.flags;
            return result;
        }
    }
}

