/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi.impl;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.intellij.openapi.project.Project;
import org.jetbrains.jet.internal.com.intellij.psi.PsiManager;
import org.jetbrains.jet.internal.com.intellij.psi.impl.PsiCachedValueImpl;
import org.jetbrains.jet.internal.com.intellij.psi.impl.PsiParameterizedCachedValue;
import org.jetbrains.jet.internal.com.intellij.psi.util.CachedValue;
import org.jetbrains.jet.internal.com.intellij.psi.util.CachedValueProvider;
import org.jetbrains.jet.internal.com.intellij.psi.util.ParameterizedCachedValue;
import org.jetbrains.jet.internal.com.intellij.psi.util.ParameterizedCachedValueProvider;
import org.jetbrains.jet.internal.com.intellij.util.CachedValuesFactory;

public class PsiCachedValuesFactory
implements CachedValuesFactory {
    private final Project myProject;
    private final PsiManager myManager;

    public PsiCachedValuesFactory(PsiManager manager) {
        this.myManager = manager;
        this.myProject = manager.getProject();
    }

    @Override
    public <T> CachedValue<T> createCachedValue(@NotNull CachedValueProvider<T> provider, boolean trackValue) {
        if (provider == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiCachedValuesFactory.createCachedValue must not be null");
        }
        return trackValue ? new PsiCachedValueImpl<T>(this.myManager, provider){

            @Override
            protected Object[] getDependencies(CachedValueProvider.Result<T> result) {
                return this.getDependenciesPlusValue(result);
            }
        } : new PsiCachedValueImpl<T>(this.myManager, provider);
    }

    @Override
    public <T, P> ParameterizedCachedValue<T, P> createParameterizedCachedValue(@NotNull ParameterizedCachedValueProvider<T, P> provider, boolean trackValue) {
        if (provider == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiCachedValuesFactory.createParameterizedCachedValue must not be null");
        }
        return trackValue ? new PsiParameterizedCachedValue<T, P>(this.myManager, provider){

            @Override
            public boolean isFromMyProject(Project project) {
                return PsiCachedValuesFactory.this.myProject == project;
            }

            @Override
            protected Object[] getDependencies(CachedValueProvider.Result<T> tResult) {
                return this.getDependenciesPlusValue(tResult);
            }
        } : new PsiParameterizedCachedValue<T, P>(this.myManager, provider){

            @Override
            public boolean isFromMyProject(Project project) {
                return PsiCachedValuesFactory.this.myProject == project;
            }
        };
    }
}

