/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi.impl;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.intellij.openapi.project.Project;
import org.jetbrains.jet.internal.com.intellij.psi.PsiDirectory;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiFile;
import org.jetbrains.jet.internal.com.intellij.psi.PsiManager;
import org.jetbrains.jet.internal.com.intellij.psi.util.PsiModificationTracker;
import org.jetbrains.jet.internal.com.intellij.util.CachedValueBase;

public abstract class PsiCachedValue<T>
extends CachedValueBase<T> {
    private final PsiManager myManager;
    protected long myLastPsiTimeStamp;

    public PsiCachedValue(@NotNull PsiManager manager) {
        if (manager == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiCachedValue.<init> must not be null");
        }
        this.myLastPsiTimeStamp = -1L;
        this.myManager = manager;
    }

    @Override
    protected CachedValueBase.Data<T> computeData(T value, Object[] dependencies) {
        CachedValueBase.Data<T> data = super.computeData(value, dependencies);
        this.myLastPsiTimeStamp = this.myManager.getModificationTracker().getModificationCount();
        return data;
    }

    @Override
    protected boolean isUpToDate(@NotNull CachedValueBase.Data data) {
        if (data == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiCachedValue.isUpToDate must not be null");
        }
        return !this.myManager.isDisposed() && super.isUpToDate(data);
    }

    @Override
    protected boolean isDependencyOutOfDate(Object dependency, long oldTimeStamp) {
        if (dependency instanceof PsiElement && this.myLastPsiTimeStamp == this.myManager.getModificationTracker().getModificationCount() && ((PsiElement)dependency).isValid() && ((PsiElement)dependency).isPhysical()) {
            return false;
        }
        return super.isDependencyOutOfDate(dependency, oldTimeStamp);
    }

    @Override
    protected long getTimeStamp(Object dependency) {
        if (dependency instanceof PsiDirectory) {
            return this.myManager.getModificationTracker().getOutOfCodeBlockModificationCount();
        }
        if (dependency instanceof PsiElement) {
            PsiElement element = (PsiElement)dependency;
            if (!element.isValid()) {
                return -1L;
            }
            PsiFile containingFile = element.getContainingFile();
            if (containingFile == null) {
                return -1L;
            }
            return containingFile.getModificationStamp();
        }
        if (dependency == PsiModificationTracker.MODIFICATION_COUNT) {
            return this.myManager.getModificationTracker().getModificationCount();
        }
        if (dependency == PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT) {
            return this.myManager.getModificationTracker().getOutOfCodeBlockModificationCount();
        }
        if (dependency == PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT) {
            return this.myManager.getModificationTracker().getJavaStructureModificationCount();
        }
        return super.getTimeStamp(dependency);
    }

    @Override
    public boolean isFromMyProject(Project project) {
        return this.myManager.getProject() == project;
    }
}

