/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.intellij.openapi.application.ReadActionProcessor;
import org.jetbrains.jet.internal.com.intellij.openapi.progress.ProgressIndicatorProvider;
import org.jetbrains.jet.internal.com.intellij.openapi.project.DumbAware;
import org.jetbrains.jet.internal.com.intellij.openapi.project.DumbService;
import org.jetbrains.jet.internal.com.intellij.openapi.project.Project;
import org.jetbrains.jet.internal.com.intellij.openapi.roots.PackageIndex;
import org.jetbrains.jet.internal.com.intellij.openapi.util.Comparing;
import org.jetbrains.jet.internal.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.jet.internal.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.jet.internal.com.intellij.openapi.vfs.VirtualFileFilter;
import org.jetbrains.jet.internal.com.intellij.psi.JavaDirectoryService;
import org.jetbrains.jet.internal.com.intellij.psi.PsiClass;
import org.jetbrains.jet.internal.com.intellij.psi.PsiClassOwner;
import org.jetbrains.jet.internal.com.intellij.psi.PsiClassOwnerEx;
import org.jetbrains.jet.internal.com.intellij.psi.PsiConstantEvaluationHelper;
import org.jetbrains.jet.internal.com.intellij.psi.PsiDirectory;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElementFactory;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElementFinder;
import org.jetbrains.jet.internal.com.intellij.psi.PsiFile;
import org.jetbrains.jet.internal.com.intellij.psi.PsiJavaFile;
import org.jetbrains.jet.internal.com.intellij.psi.PsiJavaParserFacade;
import org.jetbrains.jet.internal.com.intellij.psi.PsiManager;
import org.jetbrains.jet.internal.com.intellij.psi.PsiNameHelper;
import org.jetbrains.jet.internal.com.intellij.psi.PsiPackage;
import org.jetbrains.jet.internal.com.intellij.psi.PsiResolveHelper;
import org.jetbrains.jet.internal.com.intellij.psi.impl.JavaPsiFacadeEx;
import org.jetbrains.jet.internal.com.intellij.psi.impl.PsiConstantEvaluationHelperImpl;
import org.jetbrains.jet.internal.com.intellij.psi.impl.PsiManagerImpl;
import org.jetbrains.jet.internal.com.intellij.psi.impl.PsiNameHelperImpl;
import org.jetbrains.jet.internal.com.intellij.psi.impl.file.impl.JavaFileManager;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.DummyHolderFactory;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.JavaDummyHolder;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.JavaDummyHolderFactory;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.resolve.FileContextUtil;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.JavaElementType;
import org.jetbrains.jet.internal.com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.jet.internal.com.intellij.psi.util.PsiModificationTracker;
import org.jetbrains.jet.internal.com.intellij.util.ConcurrencyUtil;
import org.jetbrains.jet.internal.com.intellij.util.Processor;
import org.jetbrains.jet.internal.com.intellij.util.SmartList;
import org.jetbrains.jet.internal.com.intellij.util.containers.ConcurrentHashMap;
import org.jetbrains.jet.internal.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.jet.internal.com.intellij.util.containers.HashMap;
import org.jetbrains.jet.internal.com.intellij.util.messages.MessageBus;

public class JavaPsiFacadeImpl
extends JavaPsiFacadeEx {
    private ArrayList<PsiElementFinder> myElementFinders;
    private final PsiNameHelper myNameHelper;
    private final PsiConstantEvaluationHelper myConstantEvaluationHelper;
    private final ConcurrentMap<String, PsiPackage> myPackageCache = new ConcurrentHashMap<String, PsiPackage>();
    private final Project myProject;
    private final JavaFileManager myFileManager;

    public JavaPsiFacadeImpl(Project project, PsiManagerImpl psiManager, JavaFileManager javaFileManager, MessageBus bus) {
        this.myProject = project;
        this.myFileManager = javaFileManager;
        this.myNameHelper = new PsiNameHelperImpl(this);
        this.myConstantEvaluationHelper = new PsiConstantEvaluationHelperImpl();
        final PsiModificationTracker modificationTracker = psiManager.getModificationTracker();
        if (bus != null) {
            bus.connect().subscribe(PsiModificationTracker.TOPIC, new PsiModificationTracker.Listener(){
                private long lastTimeSeen = -1L;

                @Override
                public void modificationCountChanged() {
                    long now = modificationTracker.getJavaStructureModificationCount();
                    if (this.lastTimeSeen != now) {
                        this.lastTimeSeen = now;
                        JavaPsiFacadeImpl.this.myPackageCache.clear();
                    }
                }
            });
        }
        DummyHolderFactory.setFactory(new JavaDummyHolderFactory());
        JavaElementType.ANNOTATION.getIndex();
    }

    @Override
    public PsiClass findClass(@NotNull String qualifiedName) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/JavaPsiFacadeImpl.findClass must not be null");
        }
        return this.findClass(qualifiedName, GlobalSearchScope.allScope(this.myProject));
    }

    @Override
    public PsiClass findClass(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/JavaPsiFacadeImpl.findClass must not be null");
        }
        if (scope == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/JavaPsiFacadeImpl.findClass must not be null");
        }
        ProgressIndicatorProvider.checkCanceled();
        if (DumbService.getInstance(this.getProject()).isDumb()) {
            List<PsiClass> classes = this.findClassesInDumbMode(qualifiedName, scope);
            if (!classes.isEmpty()) {
                return classes.get(0);
            }
            return null;
        }
        for (PsiElementFinder finder : this.finders()) {
            PsiClass aClass = finder.findClass(qualifiedName, scope);
            if (aClass == null) continue;
            return aClass;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private List<PsiClass> findClassesInDumbMode(String qualifiedName, GlobalSearchScope scope) {
        List<PsiClass> list;
        String packageName = StringUtil.getPackageName(qualifiedName);
        PsiPackage pkg = this.findPackage(packageName);
        String className = StringUtil.getShortName(qualifiedName);
        if (pkg == null && packageName.length() < qualifiedName.length()) {
            List<PsiClass> containingClasses = this.findClassesInDumbMode(packageName, scope);
            if (!(containingClasses.size() == 1 ? (list = JavaPsiFacadeImpl.filterByName(className, containingClasses.get(0).getInnerClasses())) != null : (list = Collections.emptyList()) != null)) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/JavaPsiFacadeImpl.findClassesInDumbMode must not return null");
            return list;
        }
        if (pkg == null || !pkg.containsClassNamed(className)) {
            list = Collections.emptyList();
            if (list == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/JavaPsiFacadeImpl.findClassesInDumbMode must not return null");
            return list;
        }
        list = JavaPsiFacadeImpl.filterByName(className, pkg.getClasses(scope));
        if (list != null) return list;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/JavaPsiFacadeImpl.findClassesInDumbMode must not return null");
    }

    private static List<PsiClass> filterByName(String className, PsiClass[] classes) {
        SmartList<PsiClass> foundClasses = new SmartList<PsiClass>();
        for (PsiClass psiClass : classes) {
            if (!className.equals(psiClass.getName())) continue;
            foundClasses.add(psiClass);
        }
        return foundClasses;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public PsiClass[] findClasses(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
        PsiClass[] psiClassArray;
        if (qualifiedName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/JavaPsiFacadeImpl.findClasses must not be null");
        }
        if (scope == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/JavaPsiFacadeImpl.findClasses must not be null");
        }
        if (DumbService.getInstance(this.getProject()).isDumb()) {
            List<PsiClass> classes = this.findClassesInDumbMode(qualifiedName, scope);
            psiClassArray = classes.toArray(new PsiClass[classes.size()]);
            if (psiClassArray == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/JavaPsiFacadeImpl.findClasses must not return null");
            return psiClassArray;
        }
        SmartList classes = new SmartList();
        for (PsiElementFinder finder : this.finders()) {
            PsiClass[] finderClasses = finder.findClasses(qualifiedName, scope);
            ContainerUtil.addAll(classes, finderClasses);
        }
        psiClassArray = classes.toArray(new PsiClass[classes.size()]);
        if (psiClassArray != null) return psiClassArray;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/JavaPsiFacadeImpl.findClasses must not return null");
    }

    private ArrayList<PsiElementFinder> finders() {
        ArrayList<PsiElementFinder> answer = this.myElementFinders;
        if (answer == null) {
            this.myElementFinders = answer = this.calcFinders();
        }
        return answer;
    }

    private ArrayList<PsiElementFinder> calcFinders() {
        ArrayList<PsiElementFinder> elementFinders = new ArrayList<PsiElementFinder>();
        elementFinders.add(new PsiElementFinderImpl());
        ContainerUtil.addAll(elementFinders, this.myProject.getExtensions(PsiElementFinder.EP_NAME));
        return elementFinders;
    }

    @Override
    @NotNull
    public PsiConstantEvaluationHelper getConstantEvaluationHelper() {
        PsiConstantEvaluationHelper psiConstantEvaluationHelper = this.myConstantEvaluationHelper;
        if (psiConstantEvaluationHelper == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/JavaPsiFacadeImpl.getConstantEvaluationHelper must not return null");
        }
        return psiConstantEvaluationHelper;
    }

    @Override
    public PsiPackage findPackage(@NotNull String qualifiedName) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/JavaPsiFacadeImpl.findPackage must not be null");
        }
        PsiPackage aPackage = (PsiPackage)this.myPackageCache.get(qualifiedName);
        if (aPackage != null) {
            return aPackage;
        }
        for (PsiElementFinder finder : this.filteredFinders()) {
            aPackage = finder.findPackage(qualifiedName);
            if (aPackage == null) continue;
            return ConcurrencyUtil.cacheOrGet(this.myPackageCache, qualifiedName, aPackage);
        }
        return null;
    }

    private List<PsiElementFinder> filteredFinders() {
        DumbService dumbService = DumbService.getInstance(this.getProject());
        List<PsiElementFinder> finders = this.finders();
        if (dumbService.isDumb()) {
            finders = dumbService.filterByDumbAwareness(finders);
        }
        return finders;
    }

    @Override
    @NotNull
    public PsiJavaParserFacade getParserFacade() {
        PsiElementFactory psiElementFactory = this.getElementFactory();
        if (psiElementFactory == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/JavaPsiFacadeImpl.getParserFacade must not return null");
        }
        return psiElementFactory;
    }

    @Override
    @NotNull
    public PsiResolveHelper getResolveHelper() {
        PsiResolveHelper psiResolveHelper = PsiResolveHelper.SERVICE.getInstance(this.myProject);
        if (psiResolveHelper == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/JavaPsiFacadeImpl.getResolveHelper must not return null");
        }
        return psiResolveHelper;
    }

    @Override
    @NotNull
    public PsiNameHelper getNameHelper() {
        PsiNameHelper psiNameHelper = this.myNameHelper;
        if (psiNameHelper == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/JavaPsiFacadeImpl.getNameHelper must not return null");
        }
        return psiNameHelper;
    }

    public Set<String> getClassNames(PsiPackage psiPackage, GlobalSearchScope scope) {
        HashSet<String> result = new HashSet<String>();
        for (PsiElementFinder finder : this.filteredFinders()) {
            result.addAll(finder.getClassNames(psiPackage, scope));
        }
        return result;
    }

    public PsiClass[] getClasses(PsiPackage psiPackage, GlobalSearchScope scope) {
        ArrayList result = null;
        for (PsiElementFinder finder : this.filteredFinders()) {
            PsiClass[] classes = finder.getClasses(psiPackage, scope);
            if (classes.length == 0) continue;
            if (result == null) {
                result = new ArrayList();
            }
            ContainerUtil.addAll(result, classes);
        }
        return result == null ? PsiClass.EMPTY_ARRAY : result.toArray(new PsiClass[result.size()]);
    }

    public boolean processPackageDirectories(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope, Processor<PsiDirectory> consumer) {
        if (psiPackage == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/JavaPsiFacadeImpl.processPackageDirectories must not be null");
        }
        if (scope == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/JavaPsiFacadeImpl.processPackageDirectories must not be null");
        }
        for (PsiElementFinder finder : this.filteredFinders()) {
            if (finder.processPackageDirectories(psiPackage, scope, consumer)) continue;
            return false;
        }
        return true;
    }

    public PsiPackage[] getSubPackages(PsiPackage psiPackage, GlobalSearchScope scope) {
        LinkedHashSet result = new LinkedHashSet();
        for (PsiElementFinder finder : this.filteredFinders()) {
            PsiPackage[] packages = finder.getSubPackages(psiPackage, scope);
            ContainerUtil.addAll(result, packages);
        }
        return result.toArray(new PsiPackage[result.size()]);
    }

    @Override
    public boolean isPartOfPackagePrefix(String packageName) {
        Collection<String> packagePrefixes = this.myFileManager.getNonTrivialPackagePrefixes();
        for (String subpackageName : packagePrefixes) {
            if (!JavaPsiFacadeImpl.isSubpackageOf(subpackageName, packageName)) continue;
            return true;
        }
        return false;
    }

    private static boolean isSubpackageOf(String subpackageName, String packageName) {
        return subpackageName.equals(packageName) || subpackageName.startsWith(packageName) && subpackageName.charAt(packageName.length()) == '.';
    }

    @Override
    public boolean isInPackage(@NotNull PsiElement element, @NotNull PsiPackage aPackage) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/JavaPsiFacadeImpl.isInPackage must not be null");
        }
        if (aPackage == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/JavaPsiFacadeImpl.isInPackage must not be null");
        }
        PsiFile file = FileContextUtil.getContextFile(element);
        if (file instanceof JavaDummyHolder) {
            return ((JavaDummyHolder)file).isInPackage(aPackage);
        }
        if (file instanceof PsiJavaFile) {
            String packageName = ((PsiJavaFile)file).getPackageName();
            return packageName.equals(aPackage.getQualifiedName());
        }
        return false;
    }

    @Override
    public boolean arePackagesTheSame(@NotNull PsiElement element1, @NotNull PsiElement element2) {
        PsiFile file2;
        if (element1 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/JavaPsiFacadeImpl.arePackagesTheSame must not be null");
        }
        if (element2 == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/JavaPsiFacadeImpl.arePackagesTheSame must not be null");
        }
        PsiFile file1 = FileContextUtil.getContextFile(element1);
        if (Comparing.equal(file1, file2 = FileContextUtil.getContextFile(element2))) {
            return true;
        }
        if (file1 instanceof JavaDummyHolder && file2 instanceof JavaDummyHolder) {
            return true;
        }
        if (file1 instanceof JavaDummyHolder || file2 instanceof JavaDummyHolder) {
            JavaDummyHolder dummyHolder = (JavaDummyHolder)(file1 instanceof JavaDummyHolder ? file1 : file2);
            PsiFile other = file1 instanceof JavaDummyHolder ? file2 : file1;
            return dummyHolder.isSamePackage(other);
        }
        if (!(file1 instanceof PsiClassOwner)) {
            return false;
        }
        if (!(file2 instanceof PsiClassOwner)) {
            return false;
        }
        String package1 = ((PsiClassOwner)file1).getPackageName();
        String package2 = ((PsiClassOwner)file2).getPackageName();
        return Comparing.equal(package1, package2);
    }

    @Override
    public Project getProject() {
        return this.myProject;
    }

    @Override
    @NotNull
    public PsiElementFactory getElementFactory() {
        PsiElementFactory psiElementFactory = PsiElementFactory.SERVICE.getInstance(this.myProject);
        if (psiElementFactory == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/JavaPsiFacadeImpl.getElementFactory must not return null");
        }
        return psiElementFactory;
    }

    @Override
    public void setAssertOnFileLoadingFilter(VirtualFileFilter filter) {
        ((PsiManagerImpl)PsiManager.getInstance(this.myProject)).setAssertOnFileLoadingFilter(filter);
    }

    private class PsiElementFinderImpl
    extends PsiElementFinder
    implements DumbAware {
        private PsiElementFinderImpl() {
        }

        @Override
        public PsiClass findClass(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
            if (qualifiedName == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/JavaPsiFacadeImpl$PsiElementFinderImpl.findClass must not be null");
            }
            if (scope == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/JavaPsiFacadeImpl$PsiElementFinderImpl.findClass must not be null");
            }
            return JavaPsiFacadeImpl.this.myFileManager.findClass(qualifiedName, scope);
        }

        @Override
        @NotNull
        public PsiClass[] findClasses(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
            if (qualifiedName == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/JavaPsiFacadeImpl$PsiElementFinderImpl.findClasses must not be null");
            }
            if (scope == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/JavaPsiFacadeImpl$PsiElementFinderImpl.findClasses must not be null");
            }
            PsiClass[] psiClassArray = JavaPsiFacadeImpl.this.myFileManager.findClasses(qualifiedName, scope);
            if (psiClassArray == null) {
                throw new IllegalStateException("@NotNull method com/intellij/psi/impl/JavaPsiFacadeImpl$PsiElementFinderImpl.findClasses must not return null");
            }
            return psiClassArray;
        }

        @Override
        public PsiPackage findPackage(@NotNull String qualifiedName) {
            if (qualifiedName == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/JavaPsiFacadeImpl$PsiElementFinderImpl.findPackage must not be null");
            }
            return JavaPsiFacadeImpl.this.myFileManager.findPackage(qualifiedName);
        }

        @Override
        @NotNull
        public PsiPackage[] getSubPackages(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope) {
            if (psiPackage == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/JavaPsiFacadeImpl$PsiElementFinderImpl.getSubPackages must not be null");
            }
            if (scope == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/JavaPsiFacadeImpl$PsiElementFinderImpl.getSubPackages must not be null");
            }
            HashMap<String, PsiPackage> packagesMap = new HashMap<String, PsiPackage>();
            String qualifiedName = psiPackage.getQualifiedName();
            for (PsiDirectory dir : psiPackage.getDirectories(scope)) {
                PsiDirectory[] subDirs;
                for (PsiDirectory subDir : subDirs = dir.getSubdirectories()) {
                    String subQualifiedName;
                    PsiPackage aPackage = JavaDirectoryService.getInstance().getPackage(subDir);
                    if (aPackage == null || !(subQualifiedName = aPackage.getQualifiedName()).startsWith(qualifiedName) || packagesMap.containsKey(subQualifiedName)) continue;
                    packagesMap.put(aPackage.getQualifiedName(), aPackage);
                }
            }
            packagesMap.remove(qualifiedName);
            PsiPackage[] psiPackageArray = packagesMap.values().toArray(new PsiPackage[packagesMap.size()]);
            if (psiPackageArray == null) {
                throw new IllegalStateException("@NotNull method com/intellij/psi/impl/JavaPsiFacadeImpl$PsiElementFinderImpl.getSubPackages must not return null");
            }
            return psiPackageArray;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        @NotNull
        public PsiClass[] getClasses(@NotNull PsiPackage psiPackage, final @NotNull GlobalSearchScope scope) {
            PsiClass[] psiClassArray;
            if (psiPackage == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/JavaPsiFacadeImpl$PsiElementFinderImpl.getClasses must not be null");
            }
            if (scope == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/JavaPsiFacadeImpl$PsiElementFinderImpl.getClasses must not be null");
            }
            ArrayList<PsiClass> list = null;
            String packageName = psiPackage.getQualifiedName();
            for (PsiDirectory dir : psiPackage.getDirectories(scope)) {
                PsiClass[] classes = JavaDirectoryService.getInstance().getClasses(dir);
                if (classes.length == 0) continue;
                if (list == null) {
                    list = new ArrayList<PsiClass>();
                }
                for (PsiClass aClass : classes) {
                    String qualifiedName = aClass.getQualifiedName();
                    if (qualifiedName != null) {
                        qualifiedName = StringUtil.getPackageName(qualifiedName);
                    }
                    if (!Comparing.strEqual(qualifiedName, packageName)) continue;
                    list.add(aClass);
                }
            }
            if (list == null) {
                psiClassArray = PsiClass.EMPTY_ARRAY;
                if (PsiClass.EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/JavaPsiFacadeImpl$PsiElementFinderImpl.getClasses must not return null");
                return psiClassArray;
            }
            ContainerUtil.quickSort(list, new Comparator<PsiClass>(){

                @Override
                public int compare(PsiClass o1, PsiClass o2) {
                    return scope.compare(o2.getContainingFile().getVirtualFile(), o1.getContainingFile().getVirtualFile());
                }
            });
            psiClassArray = list.toArray(new PsiClass[list.size()]);
            if (psiClassArray != null) return psiClassArray;
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/JavaPsiFacadeImpl$PsiElementFinderImpl.getClasses must not return null");
        }

        @Override
        public Set<String> getClassNames(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope) {
            if (psiPackage == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/JavaPsiFacadeImpl$PsiElementFinderImpl.getClassNames must not be null");
            }
            if (scope == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/JavaPsiFacadeImpl$PsiElementFinderImpl.getClassNames must not be null");
            }
            HashSet<String> names = null;
            for (PsiDirectory dir : psiPackage.getDirectories(scope)) {
                for (PsiFile file : dir.getFiles()) {
                    Set<String> inFile;
                    if (!(file instanceof PsiClassOwner) || file.getViewProvider().getLanguages().size() != 1) continue;
                    Set<String> set = inFile = file instanceof PsiClassOwnerEx ? ((PsiClassOwnerEx)file).getClassNames() : PsiElementFinderImpl.getClassNames(((PsiClassOwner)file).getClasses());
                    if (inFile.isEmpty()) continue;
                    if (names == null) {
                        names = new HashSet<String>();
                    }
                    names.addAll(inFile);
                }
            }
            return names == null ? Collections.emptySet() : names;
        }

        @Override
        public boolean processPackageDirectories(@NotNull PsiPackage psiPackage, final @NotNull GlobalSearchScope scope, final Processor<PsiDirectory> consumer) {
            if (psiPackage == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/JavaPsiFacadeImpl$PsiElementFinderImpl.processPackageDirectories must not be null");
            }
            if (scope == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/JavaPsiFacadeImpl$PsiElementFinderImpl.processPackageDirectories must not be null");
            }
            final PsiManager psiManager = PsiManager.getInstance(JavaPsiFacadeImpl.this.getProject());
            PackageIndex.getInstance(JavaPsiFacadeImpl.this.getProject()).getDirsByPackageName(psiPackage.getQualifiedName(), false).forEach((Processor<VirtualFile>)new ReadActionProcessor<VirtualFile>(){

                @Override
                public boolean processInReadAction(VirtualFile dir) {
                    if (!scope.contains(dir)) {
                        return true;
                    }
                    PsiDirectory psiDir = psiManager.findDirectory(dir);
                    return psiDir == null || consumer.process(psiDir);
                }
            });
            return true;
        }
    }
}

