/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi.impl;

import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.intellij.injected.editor.VirtualFileWindow;
import org.jetbrains.jet.internal.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.jet.internal.com.intellij.psi.FileViewProvider;
import org.jetbrains.jet.internal.com.intellij.psi.PsiDirectory;
import org.jetbrains.jet.internal.com.intellij.psi.PsiFile;
import org.jetbrains.jet.internal.com.intellij.psi.SingleRootFileViewProvider;
import org.jetbrains.jet.internal.com.intellij.psi.impl.PsiManagerImpl;
import org.jetbrains.jet.internal.com.intellij.psi.impl.file.impl.FileManager;
import org.jetbrains.jet.internal.com.intellij.util.containers.ConcurrentWeakValueHashMap;

class EmptyFileManager
implements FileManager {
    private final PsiManagerImpl myManager;
    private final ConcurrentWeakValueHashMap<VirtualFile, FileViewProvider> myVFileToViewProviderMap = new ConcurrentWeakValueHashMap();

    EmptyFileManager(PsiManagerImpl manager) {
        this.myManager = manager;
    }

    @Override
    public void dispose() {
    }

    @Override
    public PsiFile findFile(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/EmptyFileManager.findFile must not be null");
        }
        return null;
    }

    @Override
    public PsiDirectory findDirectory(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/EmptyFileManager.findDirectory must not be null");
        }
        return null;
    }

    @Override
    public void reloadFromDisk(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/EmptyFileManager.reloadFromDisk must not be null");
        }
    }

    @Override
    public PsiFile getCachedPsiFile(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/EmptyFileManager.getCachedPsiFile must not be null");
        }
        return null;
    }

    @Override
    public void cleanupForNextTest() {
    }

    @Override
    public FileViewProvider findViewProvider(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/EmptyFileManager.findViewProvider must not be null");
        }
        return this.myVFileToViewProviderMap.get(file);
    }

    @Override
    public FileViewProvider findCachedViewProvider(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/EmptyFileManager.findCachedViewProvider must not be null");
        }
        return this.myVFileToViewProviderMap.get(file);
    }

    @Override
    @NotNull
    public FileViewProvider createFileViewProvider(@NotNull VirtualFile file, boolean physical) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/EmptyFileManager.createFileViewProvider must not be null");
        }
        SingleRootFileViewProvider singleRootFileViewProvider = new SingleRootFileViewProvider(this.myManager, file, physical);
        if (singleRootFileViewProvider == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/EmptyFileManager.createFileViewProvider must not return null");
        }
        return singleRootFileViewProvider;
    }

    @Override
    public void setViewProvider(@NotNull VirtualFile virtualFile, FileViewProvider singleRootFileViewProvider) {
        if (virtualFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/EmptyFileManager.setViewProvider must not be null");
        }
        if (!(virtualFile instanceof VirtualFileWindow)) {
            if (singleRootFileViewProvider == null) {
                this.myVFileToViewProviderMap.remove(virtualFile);
            } else {
                this.myVFileToViewProviderMap.put(virtualFile, singleRootFileViewProvider);
            }
        }
    }

    @Override
    public List<PsiFile> getAllCachedFiles() {
        return Collections.emptyList();
    }
}

