/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi.impl;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.intellij.openapi.fileTypes.FileTypeRegistry;
import org.jetbrains.jet.internal.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.jet.internal.com.intellij.psi.PsiBundle;
import org.jetbrains.jet.internal.com.intellij.psi.PsiDirectory;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiFile;
import org.jetbrains.jet.internal.com.intellij.util.IncorrectOperationException;

public class CheckUtil {
    private CheckUtil() {
    }

    public static void checkWritable(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/CheckUtil.checkWritable must not be null");
        }
        if (!element.isWritable()) {
            if (element instanceof PsiDirectory) {
                throw new IncorrectOperationException(PsiBundle.message("cannot.modify.a.read.only.directory", ((PsiDirectory)element).getVirtualFile().getPresentableUrl()));
            }
            PsiFile file = element.getContainingFile();
            if (file == null) {
                throw new IncorrectOperationException();
            }
            VirtualFile virtualFile = file.getVirtualFile();
            if (virtualFile == null) {
                throw new IncorrectOperationException();
            }
            throw new IncorrectOperationException(PsiBundle.message("cannot.modify.a.read.only.file", virtualFile.getPresentableUrl()));
        }
    }

    public static void checkDelete(@NotNull VirtualFile file) throws IncorrectOperationException {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/CheckUtil.checkDelete must not be null");
        }
        if (FileTypeRegistry.getInstance().isFileIgnored(file)) {
            return;
        }
        if (!file.isWritable()) {
            throw new IncorrectOperationException(PsiBundle.message("cannot.delete.a.read.only.file", file.getPresentableUrl()));
        }
        if (file.isDirectory() && !file.isSymLink()) {
            VirtualFile[] children;
            for (VirtualFile aChildren : children = file.getChildren()) {
                CheckUtil.checkDelete(aChildren);
            }
        }
    }
}

