/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi.controlFlow;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiStatement;
import org.jetbrains.jet.internal.com.intellij.psi.controlFlow.CommentInstruction;
import org.jetbrains.jet.internal.com.intellij.psi.controlFlow.ControlFlow;
import org.jetbrains.jet.internal.com.intellij.psi.controlFlow.Instruction;
import org.jetbrains.jet.internal.com.intellij.util.containers.Stack;
import org.jetbrains.jet.internal.gnu.trove.TObjectIntHashMap;

class ControlFlowImpl
implements ControlFlow {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.controlFlow.ControlFlowImpl");
    private final List<Instruction> myInstructions = new ArrayList<Instruction>();
    private final TObjectIntHashMap<PsiElement> myElementToStartOffsetMap = new TObjectIntHashMap();
    private final TObjectIntHashMap<PsiElement> myElementToEndOffsetMap = new TObjectIntHashMap();
    private final List<PsiElement> myElementsForInstructions = new ArrayList<PsiElement>();
    private boolean myConstantConditionOccurred;
    private final Stack<PsiElement> myElementStack = new Stack();

    ControlFlowImpl() {
    }

    public void addInstruction(Instruction instruction) {
        this.myInstructions.add(instruction);
        this.myElementsForInstructions.add(this.myElementStack.peek());
    }

    public void startElement(PsiElement element) {
        this.myElementStack.push(element);
        this.myElementToStartOffsetMap.put(element, this.myInstructions.size());
        if (LOG.isDebugEnabled() && element instanceof PsiStatement) {
            String text = element.getText();
            int index = Math.min(text.indexOf(10), text.indexOf(13));
            if (index >= 0) {
                text = text.substring(0, index);
            }
            this.addInstruction(new CommentInstruction(text));
        }
    }

    public void finishElement(PsiElement element) {
        PsiElement popped = this.myElementStack.pop();
        LOG.assertTrue(popped.equals(element));
        this.myElementToEndOffsetMap.put(element, this.myInstructions.size());
    }

    @Override
    @NotNull
    public List<Instruction> getInstructions() {
        List<Instruction> list = this.myInstructions;
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/controlFlow/ControlFlowImpl.getInstructions must not return null");
        }
        return list;
    }

    @Override
    public int getSize() {
        return this.myInstructions.size();
    }

    @Override
    public int getStartOffset(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/controlFlow/ControlFlowImpl.getStartOffset must not be null");
        }
        int value = this.myElementToStartOffsetMap.get(element);
        if (value == 0 && !this.myElementToStartOffsetMap.containsKey(element)) {
            return -1;
        }
        return value;
    }

    @Override
    public int getEndOffset(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/controlFlow/ControlFlowImpl.getEndOffset must not be null");
        }
        int value = this.myElementToEndOffsetMap.get(element);
        if (value == 0 && !this.myElementToEndOffsetMap.containsKey(element)) {
            return -1;
        }
        return value;
    }

    @Override
    public PsiElement getElement(int offset) {
        return this.myElementsForInstructions.get(offset);
    }

    @Override
    public boolean isConstantConditionOccurred() {
        return this.myConstantConditionOccurred;
    }

    public void setConstantConditionOccurred(boolean constantConditionOccurred) {
        this.myConstantConditionOccurred = constantConditionOccurred;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < this.myInstructions.size(); ++i) {
            Instruction instruction = this.myInstructions.get(i);
            buffer.append(Integer.toString(i));
            buffer.append(": ");
            buffer.append(instruction.toString());
            buffer.append("\n");
        }
        return buffer.toString();
    }
}

