/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi.controlFlow;

import org.jetbrains.jet.internal.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.jet.internal.com.intellij.psi.PsiExpression;
import org.jetbrains.jet.internal.com.intellij.psi.controlFlow.BranchingInstruction;
import org.jetbrains.jet.internal.com.intellij.psi.controlFlow.ControlFlowInstructionVisitor;

public abstract class ConditionalBranchingInstruction
extends BranchingInstruction {
    protected static final Logger LOG = Logger.getInstance("#com.intellij.psi.controlFlow.ConditionalGoToInstruction");
    public final PsiExpression expression;

    public ConditionalBranchingInstruction(int offset, PsiExpression expression, BranchingInstruction.Role role) {
        super(offset, role);
        this.expression = expression;
    }

    @Override
    public int nNext() {
        return 2;
    }

    @Override
    public int getNext(int index, int no) {
        switch (no) {
            case 0: {
                return this.offset;
            }
            case 1: {
                return index + 1;
            }
        }
        LOG.assertTrue(false);
        return -1;
    }

    @Override
    public void accept(ControlFlowInstructionVisitor visitor, int offset, int nextOffset) {
        visitor.visitConditionalBranchingInstruction(this, offset, nextOffset);
    }
}

