/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi.controlFlow;

import org.jetbrains.jet.internal.com.intellij.psi.controlFlow.BranchingInstruction;
import org.jetbrains.jet.internal.com.intellij.psi.controlFlow.CallInstruction;
import org.jetbrains.jet.internal.com.intellij.psi.controlFlow.CommentInstruction;
import org.jetbrains.jet.internal.com.intellij.psi.controlFlow.ConditionalBranchingInstruction;
import org.jetbrains.jet.internal.com.intellij.psi.controlFlow.ConditionalGoToInstruction;
import org.jetbrains.jet.internal.com.intellij.psi.controlFlow.ConditionalThrowToInstruction;
import org.jetbrains.jet.internal.com.intellij.psi.controlFlow.EmptyInstruction;
import org.jetbrains.jet.internal.com.intellij.psi.controlFlow.GoToInstruction;
import org.jetbrains.jet.internal.com.intellij.psi.controlFlow.Instruction;
import org.jetbrains.jet.internal.com.intellij.psi.controlFlow.InstructionClientVisitor;
import org.jetbrains.jet.internal.com.intellij.psi.controlFlow.ReadVariableInstruction;
import org.jetbrains.jet.internal.com.intellij.psi.controlFlow.ReturnInstruction;
import org.jetbrains.jet.internal.com.intellij.psi.controlFlow.SimpleInstruction;
import org.jetbrains.jet.internal.com.intellij.psi.controlFlow.ThrowToInstruction;
import org.jetbrains.jet.internal.com.intellij.psi.controlFlow.WriteVariableInstruction;

class CompositeInstructionClientVisitor
extends InstructionClientVisitor<Object[]> {
    private final InstructionClientVisitor[] myVisitors;

    public CompositeInstructionClientVisitor(InstructionClientVisitor[] visitors) {
        this.myVisitors = visitors;
    }

    @Override
    public Object[] getResult() {
        Object[] result = new Object[this.myVisitors.length];
        for (int i = 0; i < this.myVisitors.length; ++i) {
            InstructionClientVisitor visitor = this.myVisitors[i];
            result[i] = visitor.getResult();
        }
        return result;
    }

    @Override
    public void visitInstruction(Instruction instruction, int offset, int nextOffset) {
        for (InstructionClientVisitor visitor : this.myVisitors) {
            visitor.visitInstruction(instruction, offset, nextOffset);
        }
    }

    @Override
    public void visitEmptyInstruction(EmptyInstruction instruction, int offset, int nextOffset) {
        for (InstructionClientVisitor visitor : this.myVisitors) {
            visitor.visitEmptyInstruction(instruction, offset, nextOffset);
        }
    }

    @Override
    public void visitCommentInstruction(CommentInstruction instruction, int offset, int nextOffset) {
        for (InstructionClientVisitor visitor : this.myVisitors) {
            visitor.visitCommentInstruction(instruction, offset, nextOffset);
        }
    }

    @Override
    public void visitReadVariableInstruction(ReadVariableInstruction instruction, int offset, int nextOffset) {
        for (InstructionClientVisitor visitor : this.myVisitors) {
            visitor.visitReadVariableInstruction(instruction, offset, nextOffset);
        }
    }

    @Override
    public void visitWriteVariableInstruction(WriteVariableInstruction instruction, int offset, int nextOffset) {
        for (InstructionClientVisitor visitor : this.myVisitors) {
            visitor.visitWriteVariableInstruction(instruction, offset, nextOffset);
        }
    }

    @Override
    public void visitSimpleInstruction(SimpleInstruction instruction, int offset, int nextOffset) {
        for (InstructionClientVisitor visitor : this.myVisitors) {
            visitor.visitSimpleInstruction(instruction, offset, nextOffset);
        }
    }

    @Override
    public void visitBranchingInstruction(BranchingInstruction instruction, int offset, int nextOffset) {
        for (InstructionClientVisitor visitor : this.myVisitors) {
            visitor.visitBranchingInstruction(instruction, offset, nextOffset);
        }
    }

    @Override
    public void visitConditionalBranchingInstruction(ConditionalBranchingInstruction instruction, int offset, int nextOffset) {
        for (InstructionClientVisitor visitor : this.myVisitors) {
            visitor.visitConditionalBranchingInstruction(instruction, offset, nextOffset);
        }
    }

    @Override
    public void visitConditionalGoToInstruction(ConditionalGoToInstruction instruction, int offset, int nextOffset) {
        for (InstructionClientVisitor visitor : this.myVisitors) {
            visitor.visitConditionalGoToInstruction(instruction, offset, nextOffset);
        }
    }

    @Override
    public void visitConditionalThrowToInstruction(ConditionalThrowToInstruction instruction, int offset, int nextOffset) {
        for (InstructionClientVisitor visitor : this.myVisitors) {
            visitor.visitConditionalThrowToInstruction(instruction, offset, nextOffset);
        }
    }

    @Override
    public void visitThrowToInstruction(ThrowToInstruction instruction, int offset, int nextOffset) {
        for (InstructionClientVisitor visitor : this.myVisitors) {
            visitor.visitThrowToInstruction(instruction, offset, nextOffset);
        }
    }

    @Override
    public void visitGoToInstruction(GoToInstruction instruction, int offset, int nextOffset) {
        for (InstructionClientVisitor visitor : this.myVisitors) {
            visitor.visitGoToInstruction(instruction, offset, nextOffset);
        }
    }

    @Override
    public void visitCallInstruction(CallInstruction instruction, int offset, int nextOffset) {
        for (InstructionClientVisitor visitor : this.myVisitors) {
            visitor.visitCallInstruction(instruction, offset, nextOffset);
        }
    }

    @Override
    public void visitReturnInstruction(ReturnInstruction instruction, int offset, int nextOffset) {
        for (InstructionClientVisitor visitor : this.myVisitors) {
            visitor.visitReturnInstruction(instruction, offset, nextOffset);
        }
    }
}

