/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi.controlFlow;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.intellij.psi.controlFlow.ControlFlowInstructionVisitor;
import org.jetbrains.jet.internal.com.intellij.psi.controlFlow.ControlFlowStack;
import org.jetbrains.jet.internal.com.intellij.psi.controlFlow.GoToInstruction;

public class CallInstruction
extends GoToInstruction {
    public final ControlFlowStack stack;
    public int procBegin;
    public int procEnd;

    public CallInstruction(int procBegin, int procEnd, @NotNull ControlFlowStack stack) {
        if (stack == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/psi/controlFlow/CallInstruction.<init> must not be null");
        }
        super(procBegin);
        this.stack = stack;
        this.procBegin = procBegin;
        this.procEnd = procEnd;
    }

    @Override
    public String toString() {
        return "CALL " + this.offset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(int returnOffset) {
        ControlFlowStack controlFlowStack = this.stack;
        synchronized (controlFlowStack) {
            this.stack.push(returnOffset, this);
        }
    }

    @Override
    public void accept(ControlFlowInstructionVisitor visitor, int offset, int nextOffset) {
        visitor.visitCallInstruction(this, offset, nextOffset);
    }
}

