/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi.codeStyle;

import java.util.Collection;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.intellij.openapi.components.ServiceManager;
import org.jetbrains.jet.internal.com.intellij.openapi.project.Project;
import org.jetbrains.jet.internal.com.intellij.psi.PsiClass;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiExpression;
import org.jetbrains.jet.internal.com.intellij.psi.PsiFile;
import org.jetbrains.jet.internal.com.intellij.psi.PsiImportList;
import org.jetbrains.jet.internal.com.intellij.psi.PsiImportStatementBase;
import org.jetbrains.jet.internal.com.intellij.psi.PsiJavaFile;
import org.jetbrains.jet.internal.com.intellij.psi.PsiType;
import org.jetbrains.jet.internal.com.intellij.psi.PsiVariable;
import org.jetbrains.jet.internal.com.intellij.psi.codeStyle.SuggestedNameInfo;
import org.jetbrains.jet.internal.com.intellij.psi.codeStyle.VariableKind;
import org.jetbrains.jet.internal.com.intellij.util.IncorrectOperationException;

public abstract class JavaCodeStyleManager {
    public static final int DO_NOT_ADD_IMPORTS = 4096;
    public static final int UNCOMPLETE_CODE = 8192;

    public static JavaCodeStyleManager getInstance(Project project) {
        return ServiceManager.getService(project, JavaCodeStyleManager.class);
    }

    public abstract boolean addImport(@NotNull PsiJavaFile var1, @NotNull PsiClass var2);

    public abstract PsiElement shortenClassReferences(@NotNull PsiElement var1, int var2) throws IncorrectOperationException;

    @NotNull
    public abstract String getPrefixByVariableKind(VariableKind var1);

    @NotNull
    public abstract String getSuffixByVariableKind(VariableKind var1);

    public abstract int findEntryIndex(@NotNull PsiImportStatementBase var1);

    public abstract PsiElement shortenClassReferences(@NotNull PsiElement var1) throws IncorrectOperationException;

    public abstract void shortenClassReferences(@NotNull PsiElement var1, int var2, int var3) throws IncorrectOperationException;

    public abstract void optimizeImports(@NotNull PsiFile var1) throws IncorrectOperationException;

    public abstract PsiImportList prepareOptimizeImportsResult(@NotNull PsiJavaFile var1);

    public abstract VariableKind getVariableKind(@NotNull PsiVariable var1);

    public SuggestedNameInfo suggestVariableName(@NotNull VariableKind kind, @Nullable String propertyName, @Nullable PsiExpression expr, @Nullable PsiType type) {
        if (kind == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/codeStyle/JavaCodeStyleManager.suggestVariableName must not be null");
        }
        return this.suggestVariableName(kind, propertyName, expr, type, true);
    }

    public abstract SuggestedNameInfo suggestVariableName(@NotNull VariableKind var1, @Nullable String var2, @Nullable PsiExpression var3, @Nullable PsiType var4, boolean var5);

    public abstract String variableNameToPropertyName(@NonNls String var1, VariableKind var2);

    public abstract String propertyNameToVariableName(@NonNls String var1, VariableKind var2);

    public abstract String suggestUniqueVariableName(@NonNls String var1, PsiElement var2, boolean var3);

    @NotNull
    public SuggestedNameInfo suggestUniqueVariableName(@NotNull SuggestedNameInfo baseNameInfo, PsiElement place, boolean lookForward) {
        if (baseNameInfo == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/codeStyle/JavaCodeStyleManager.suggestUniqueVariableName must not be null");
        }
        SuggestedNameInfo suggestedNameInfo = this.suggestUniqueVariableName(baseNameInfo, place, false, lookForward);
        if (suggestedNameInfo == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/codeStyle/JavaCodeStyleManager.suggestUniqueVariableName must not return null");
        }
        return suggestedNameInfo;
    }

    @NotNull
    public abstract SuggestedNameInfo suggestUniqueVariableName(@NotNull SuggestedNameInfo var1, PsiElement var2, boolean var3, boolean var4);

    public abstract PsiElement qualifyClassReferences(@NotNull PsiElement var1);

    public abstract void removeRedundantImports(@NotNull PsiJavaFile var1) throws IncorrectOperationException;

    @Nullable
    public abstract Collection<PsiImportStatementBase> findRedundantImports(PsiJavaFile var1);
}

