/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi.codeStyle;

import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.intellij.lang.ASTNode;
import org.jetbrains.jet.internal.com.intellij.openapi.components.ServiceManager;
import org.jetbrains.jet.internal.com.intellij.openapi.editor.Document;
import org.jetbrains.jet.internal.com.intellij.openapi.fileTypes.FileType;
import org.jetbrains.jet.internal.com.intellij.openapi.project.Project;
import org.jetbrains.jet.internal.com.intellij.openapi.util.Computable;
import org.jetbrains.jet.internal.com.intellij.openapi.util.TextRange;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiFile;
import org.jetbrains.jet.internal.com.intellij.psi.PsiManager;
import org.jetbrains.jet.internal.com.intellij.psi.codeStyle.Indent;
import org.jetbrains.jet.internal.com.intellij.util.IncorrectOperationException;
import org.jetbrains.jet.internal.com.intellij.util.ThrowableRunnable;

public abstract class CodeStyleManager {
    public static CodeStyleManager getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/codeStyle/CodeStyleManager.getInstance must not be null");
        }
        return ServiceManager.getService(project, CodeStyleManager.class);
    }

    public static CodeStyleManager getInstance(@NotNull PsiManager manager) {
        if (manager == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/codeStyle/CodeStyleManager.getInstance must not be null");
        }
        return CodeStyleManager.getInstance(manager.getProject());
    }

    @NotNull
    public abstract Project getProject();

    @NotNull
    public abstract PsiElement reformat(@NotNull PsiElement var1) throws IncorrectOperationException;

    @NotNull
    public abstract PsiElement reformat(@NotNull PsiElement var1, boolean var2) throws IncorrectOperationException;

    public abstract PsiElement reformatRange(@NotNull PsiElement var1, int var2, int var3) throws IncorrectOperationException;

    public abstract PsiElement reformatRange(@NotNull PsiElement var1, int var2, int var3, boolean var4) throws IncorrectOperationException;

    public abstract void reformatText(@NotNull PsiFile var1, int var2, int var3) throws IncorrectOperationException;

    public abstract void reformatText(@NotNull PsiFile var1, @NotNull Collection<TextRange> var2) throws IncorrectOperationException;

    public abstract void adjustLineIndent(@NotNull PsiFile var1, TextRange var2) throws IncorrectOperationException;

    public abstract int adjustLineIndent(@NotNull PsiFile var1, int var2) throws IncorrectOperationException;

    public abstract int adjustLineIndent(@NotNull Document var1, int var2);

    public abstract boolean isLineToBeIndented(@NotNull PsiFile var1, int var2);

    @Nullable
    public abstract String getLineIndent(@NotNull PsiFile var1, int var2);

    @Nullable
    public abstract String getLineIndent(@NotNull Document var1, int var2);

    public abstract Indent getIndent(String var1, FileType var2);

    public abstract String fillIndent(Indent var1, FileType var2);

    public abstract Indent zeroIndent();

    public abstract void reformatNewlyAddedElement(@NotNull ASTNode var1, @NotNull ASTNode var2) throws IncorrectOperationException;

    public abstract boolean isSequentialProcessingAllowed();

    public abstract void performActionWithFormatterDisabled(Runnable var1);

    public abstract <T extends Throwable> void performActionWithFormatterDisabled(ThrowableRunnable<T> var1) throws T;

    public abstract <T> T performActionWithFormatterDisabled(Computable<T> var1);
}

