/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.jet.internal.com.intellij.openapi.util.TextRange;
import org.jetbrains.jet.internal.com.intellij.psi.MultiRangeReference;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiReference;

public class ReferenceRange {
    private ReferenceRange() {
    }

    public static List<TextRange> getRanges(PsiReference ref) {
        if (ref instanceof MultiRangeReference) {
            return ((MultiRangeReference)ref).getRanges();
        }
        return Collections.singletonList(ref.getRangeInElement());
    }

    public static List<TextRange> getAbsoluteRanges(PsiReference ref) {
        PsiElement elt = ref.getElement();
        List<TextRange> relativeRanges = ReferenceRange.getRanges(ref);
        ArrayList<TextRange> answer = new ArrayList<TextRange>(relativeRanges.size());
        int parentOffset = elt.getTextRange().getStartOffset();
        for (TextRange relativeRange : relativeRanges) {
            answer.add(relativeRange.shiftRight(parentOffset));
        }
        return answer;
    }

    public static TextRange getRange(PsiReference ref) {
        if (ref instanceof MultiRangeReference) {
            List<TextRange> ranges = ((MultiRangeReference)ref).getRanges();
            return new TextRange(ranges.get(0).getStartOffset(), ranges.get(ranges.size() - 1).getEndOffset());
        }
        return ref.getRangeInElement();
    }

    public static boolean containsOffsetInElement(PsiReference ref, int offset) {
        if (ref instanceof MultiRangeReference) {
            for (TextRange range : ((MultiRangeReference)ref).getRanges()) {
                if (!range.containsOffset(offset)) continue;
                return true;
            }
            return false;
        }
        TextRange rangeInElement = ref.getRangeInElement();
        return rangeInElement != null && rangeInElement.containsOffset(offset);
    }

    public static boolean containsRangeInElement(PsiReference ref, TextRange rangeInElement) {
        if (ref instanceof MultiRangeReference) {
            for (TextRange range : ((MultiRangeReference)ref).getRanges()) {
                if (!range.contains(rangeInElement)) continue;
                return true;
            }
            return false;
        }
        TextRange rangeInElement1 = ref.getRangeInElement();
        return rangeInElement1 != null && rangeInElement1.contains(rangeInElement);
    }
}

