/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.jet.internal.com.intellij.openapi.util.Comparing;
import org.jetbrains.jet.internal.com.intellij.openapi.util.Key;
import org.jetbrains.jet.internal.com.intellij.psi.PsiAnnotation;
import org.jetbrains.jet.internal.com.intellij.psi.PsiManager;
import org.jetbrains.jet.internal.com.intellij.psi.PsiType;
import org.jetbrains.jet.internal.com.intellij.psi.PsiTypeVisitor;
import org.jetbrains.jet.internal.com.intellij.psi.search.GlobalSearchScope;

public class PsiWildcardType
extends PsiType {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.PsiWildcardType");
    private static final Key<PsiWildcardType> UNBOUNDED_WILDCARD = new Key("UNBOUNDED_WILDCARD");
    private final PsiManager myManager;
    private final PsiType myBound;
    private final boolean myIsExtending;

    private PsiWildcardType(@NotNull PsiManager manager, boolean isExtending, PsiType bound) {
        if (manager == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/PsiWildcardType.<init> must not be null");
        }
        super(PsiAnnotation.EMPTY_ARRAY);
        this.myManager = manager;
        this.myIsExtending = isExtending;
        this.myBound = bound;
    }

    @NotNull
    public static PsiWildcardType createUnbounded(PsiManager manager) {
        PsiWildcardType unboundedWildcard = manager.getUserData(UNBOUNDED_WILDCARD);
        if (unboundedWildcard == null) {
            unboundedWildcard = manager.putUserDataIfAbsent(UNBOUNDED_WILDCARD, new PsiWildcardType(manager, false, null));
        }
        PsiWildcardType psiWildcardType = unboundedWildcard;
        if (psiWildcardType == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/PsiWildcardType.createUnbounded must not return null");
        }
        return psiWildcardType;
    }

    @NotNull
    public static PsiWildcardType createExtends(@NotNull PsiManager manager, @NotNull PsiType bound) {
        if (manager == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/PsiWildcardType.createExtends must not be null");
        }
        if (bound == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/PsiWildcardType.createExtends must not be null");
        }
        LOG.assertTrue(!(bound instanceof PsiWildcardType));
        PsiWildcardType psiWildcardType = new PsiWildcardType(manager, true, bound);
        if (psiWildcardType == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/PsiWildcardType.createExtends must not return null");
        }
        return psiWildcardType;
    }

    @NotNull
    public static PsiWildcardType createSuper(@NotNull PsiManager manager, @NotNull PsiType bound) {
        if (manager == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/PsiWildcardType.createSuper must not be null");
        }
        if (bound == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/PsiWildcardType.createSuper must not be null");
        }
        PsiWildcardType psiWildcardType = new PsiWildcardType(manager, false, bound);
        if (psiWildcardType == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/PsiWildcardType.createSuper must not return null");
        }
        return psiWildcardType;
    }

    public static PsiWildcardType changeBound(@NotNull PsiWildcardType type, @NotNull PsiType newBound) {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/PsiWildcardType.changeBound must not be null");
        }
        if (newBound == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/PsiWildcardType.changeBound must not be null");
        }
        LOG.assertTrue(type.getBound() != null);
        return new PsiWildcardType(type.myManager, type.myIsExtending, newBound);
    }

    @Override
    public String getPresentableText() {
        if (this.myBound == null) {
            return "?";
        }
        if (this.myIsExtending) {
            return "? extends " + this.myBound.getPresentableText();
        }
        return "? super " + this.myBound.getPresentableText();
    }

    @Override
    public String getCanonicalText() {
        if (this.myBound == null) {
            return "?";
        }
        if (this.myIsExtending) {
            return "? extends " + this.myBound.getCanonicalText();
        }
        return "? super " + this.myBound.getCanonicalText();
    }

    @Override
    public String getInternalCanonicalText() {
        if (this.myBound == null) {
            return "?";
        }
        if (this.myIsExtending) {
            return "? extends " + this.myBound.getInternalCanonicalText();
        }
        return "? super " + this.myBound.getInternalCanonicalText();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public GlobalSearchScope getResolveScope() {
        GlobalSearchScope globalSearchScope;
        GlobalSearchScope scope;
        if (this.myBound != null && (scope = this.myBound.getResolveScope()) != null) {
            globalSearchScope = scope;
            if (globalSearchScope == null) throw new IllegalStateException("@NotNull method com/intellij/psi/PsiWildcardType.getResolveScope must not return null");
            return globalSearchScope;
        }
        globalSearchScope = GlobalSearchScope.allScope(this.myManager.getProject());
        if (globalSearchScope != null) return globalSearchScope;
        throw new IllegalStateException("@NotNull method com/intellij/psi/PsiWildcardType.getResolveScope must not return null");
    }

    @Override
    @NotNull
    public PsiType[] getSuperTypes() {
        PsiType[] psiTypeArray = new PsiType[]{this.getExtendsBound()};
        if (psiTypeArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/PsiWildcardType.getSuperTypes must not return null");
        }
        return psiTypeArray;
    }

    @Override
    public boolean equalsToText(String text) {
        if (this.myBound == null) {
            return "?".equals(text);
        }
        if (this.myIsExtending) {
            return text.startsWith("? extends ") && this.myBound.equalsToText(text.substring("? extends ".length()));
        }
        return text.startsWith("? super ") && this.myBound.equalsToText(text.substring("? super ".length()));
    }

    public PsiManager getManager() {
        return this.myManager;
    }

    public boolean equals(Object o) {
        if (!(o instanceof PsiWildcardType)) {
            return false;
        }
        PsiWildcardType that = (PsiWildcardType)o;
        if (this.myBound == null && that.myBound != null) {
            return that.isExtends() && that.myBound.equalsToText("java.lang.Object");
        }
        if (this.myBound != null && that.myBound == null) {
            return this.isExtends() && this.myBound.equalsToText("java.lang.Object");
        }
        return this.myIsExtending == that.myIsExtending && Comparing.equal(this.myBound, that.myBound);
    }

    public int hashCode() {
        return (this.myIsExtending ? 1 : 0) + (this.myBound != null ? this.myBound.hashCode() : 0);
    }

    @Nullable
    public PsiType getBound() {
        return this.myBound;
    }

    @Override
    public <A> A accept(PsiTypeVisitor<A> visitor) {
        return visitor.visitWildcardType(this);
    }

    @Override
    public boolean isValid() {
        return this.myBound == null || this.myBound.isValid();
    }

    public boolean isExtends() {
        return this.myBound != null && this.myIsExtending;
    }

    public boolean isSuper() {
        return this.myBound != null && !this.myIsExtending;
    }

    public boolean isBounded() {
        return this.myBound != null;
    }

    public PsiType getExtendsBound() {
        if (this.myBound == null || !this.myIsExtending) {
            return PsiWildcardType.getJavaLangObject(this.myManager, this.getResolveScope());
        }
        return this.myBound;
    }

    public PsiType getSuperBound() {
        return this.myBound == null || this.myIsExtending ? NULL : this.myBound;
    }
}

