/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.jet.internal.com.intellij.psi.PsiCompiledElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.jet.internal.com.intellij.util.WalkingState;

public abstract class PsiWalkingState
extends WalkingState<PsiElement> {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.PsiWalkingState");
    private final PsiElementVisitor myVisitor;

    protected PsiWalkingState(PsiElementVisitor delegate) {
        super(PsiTreeGuide.instance);
        this.myVisitor = delegate;
    }

    @Override
    public void visit(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/PsiWalkingState.visit must not be null");
        }
        element.accept(this.myVisitor);
    }

    @Override
    public void elementStarted(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/PsiWalkingState.elementStarted must not be null");
        }
        if (!this.startedWalking && element instanceof PsiCompiledElement) {
            LOG.error(element + "; Do not use walking visitor inside compiled PSI since getNextSibling() is too slow there");
        }
        super.elementStarted(element);
    }

    private static class PsiTreeGuide
    implements WalkingState.TreeGuide<PsiElement> {
        private static final PsiTreeGuide instance = new PsiTreeGuide();

        private PsiTreeGuide() {
        }

        @Override
        public PsiElement getNextSibling(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/PsiWalkingState$PsiTreeGuide.getNextSibling must not be null");
            }
            return element.getNextSibling();
        }

        @Override
        public PsiElement getPrevSibling(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/PsiWalkingState$PsiTreeGuide.getPrevSibling must not be null");
            }
            return element.getPrevSibling();
        }

        @Override
        public PsiElement getFirstChild(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/PsiWalkingState$PsiTreeGuide.getFirstChild must not be null");
            }
            return element.getFirstChild();
        }

        @Override
        public PsiElement getParent(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/PsiWalkingState$PsiTreeGuide.getParent must not be null");
            }
            return element.getParent();
        }
    }
}

