/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.intellij.openapi.progress.ProgressIndicatorProvider;
import org.jetbrains.jet.internal.com.intellij.psi.FileViewProvider;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.jet.internal.com.intellij.psi.PsiFile;
import org.jetbrains.jet.internal.com.intellij.psi.PsiWalkingState;

public abstract class PsiRecursiveElementWalkingVisitor
extends PsiElementVisitor {
    private final boolean myVisitAllFileRoots;
    private final PsiWalkingState myWalkingState = new PsiWalkingState(this){

        @Override
        public void elementFinished(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/PsiRecursiveElementWalkingVisitor$1.elementFinished must not be null");
            }
            PsiRecursiveElementWalkingVisitor.this.elementFinished(element);
        }
    };

    protected PsiRecursiveElementWalkingVisitor() {
        this(false);
    }

    protected PsiRecursiveElementWalkingVisitor(boolean visitAllFileRoots) {
        this.myVisitAllFileRoots = visitAllFileRoots;
    }

    @Override
    public void visitElement(PsiElement element) {
        ProgressIndicatorProvider.checkCanceled();
        this.myWalkingState.elementStarted(element);
    }

    protected void elementFinished(PsiElement element) {
    }

    @Override
    public void visitFile(PsiFile file) {
        FileViewProvider viewProvider;
        List<PsiFile> allFiles;
        if (this.myVisitAllFileRoots && (allFiles = (viewProvider = file.getViewProvider()).getAllFiles()).size() > 1 && file == viewProvider.getPsi(viewProvider.getBaseLanguage())) {
            for (PsiFile lFile : allFiles) {
                lFile.acceptChildren(this);
            }
            return;
        }
        super.visitFile(file);
    }

    public void stopWalking() {
        this.myWalkingState.stopWalking();
    }
}

