/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi;

import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.intellij.pom.java.LanguageLevel;
import org.jetbrains.jet.internal.com.intellij.psi.PsiJavaCodeReferenceElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiType;
import org.jetbrains.jet.internal.com.intellij.util.ArrayUtil;

public abstract class PsiNameHelper {
    private static final Pattern WHITESPACE_PATTERN = Pattern.compile("(?:\\s)|(?:/\\*.*\\*/)|(?://[^\\n]*)");

    public abstract boolean isIdentifier(@Nullable String var1);

    public abstract boolean isIdentifier(@Nullable String var1, LanguageLevel var2);

    public abstract boolean isKeyword(@Nullable String var1);

    public abstract boolean isQualifiedName(@Nullable String var1);

    @NotNull
    public static String getShortClassName(@NotNull String referenceText) {
        if (referenceText == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/PsiNameHelper.getShortClassName must not be null");
        }
        String string = PsiNameHelper.getShortClassName(referenceText, true);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/PsiNameHelper.getShortClassName must not return null");
        }
        return string;
    }

    private static String getShortClassName(String referenceText, boolean removeWhitespace) {
        String sub;
        int i;
        int lessPos = referenceText.length();
        int bracesBalance = 0;
        block5: for (i = referenceText.length() - 1; i >= 0; --i) {
            char aChar = referenceText.charAt(i);
            switch (aChar) {
                case ')': 
                case '>': {
                    ++bracesBalance;
                    continue block5;
                }
                case '(': 
                case '<': {
                    --bracesBalance;
                    lessPos = i;
                    continue block5;
                }
                case '.': 
                case '@': {
                    if (bracesBalance != 0) continue block5;
                    break block5;
                }
                default: {
                    if (bracesBalance != 0 || !removeWhitespace || Character.isWhitespace(aChar) || Character.isJavaIdentifierPart(aChar)) continue block5;
                    return PsiNameHelper.getShortClassName(PsiNameHelper.removeWhitespace(referenceText), false);
                }
            }
        }
        return (sub = referenceText.substring(i + 1, lessPos).trim()).length() == referenceText.length() ? sub : new String(sub);
    }

    public static String getPresentableText(PsiJavaCodeReferenceElement ref) {
        String referenceName = ref.getReferenceName();
        PsiType[] typeParameters = ref.getTypeParameters();
        return PsiNameHelper.getPresentableText(referenceName, typeParameters);
    }

    public static String getPresentableText(String referenceName, PsiType[] typeParameters) {
        if (typeParameters.length > 0) {
            StringBuilder buffer = new StringBuilder();
            buffer.append(referenceName);
            buffer.append("<");
            for (int i = 0; i < typeParameters.length; ++i) {
                buffer.append(typeParameters[i].getPresentableText());
                if (i >= typeParameters.length - 1) continue;
                buffer.append(", ");
            }
            buffer.append(">");
            return buffer.toString();
        }
        return referenceName != null ? referenceName : "";
    }

    public static String getQualifiedClassName(String referenceText, boolean removeWhitespace) {
        if (removeWhitespace) {
            referenceText = PsiNameHelper.removeWhitespace(referenceText);
        }
        if (referenceText.indexOf(60) < 0) {
            return referenceText;
        }
        StringBuilder buffer = new StringBuilder(referenceText.length());
        char[] chars = referenceText.toCharArray();
        int gtPos = 0;
        int count = 0;
        block4: for (int i = 0; i < chars.length; ++i) {
            char aChar = chars[i];
            switch (aChar) {
                case '<': {
                    if (++count != 1) continue block4;
                    buffer.append(new String(chars, gtPos, i - gtPos));
                    continue block4;
                }
                case '>': {
                    --count;
                    gtPos = i + 1;
                }
            }
        }
        if (count == 0) {
            buffer.append(new String(chars, gtPos, chars.length - gtPos));
        }
        return buffer.toString();
    }

    private static String removeWhitespace(String referenceText) {
        return WHITESPACE_PATTERN.matcher(referenceText).replaceAll("");
    }

    public static String[] getClassParametersText(String referenceText) {
        if (referenceText.indexOf(60) < 0) {
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        referenceText = PsiNameHelper.removeWhitespace(referenceText);
        char[] chars = referenceText.toCharArray();
        int afterLastDotIndex = 0;
        int level = 0;
        block15: for (int i = 0; i < chars.length; ++i) {
            char aChar = chars[i];
            switch (aChar) {
                case '<': {
                    ++level;
                    continue block15;
                }
                case '.': {
                    if (level != 0) continue block15;
                    afterLastDotIndex = i + 1;
                    continue block15;
                }
                case '>': {
                    --level;
                }
            }
        }
        if (level != 0) {
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        int dim = 0;
        block16: for (int i = afterLastDotIndex; i < chars.length; ++i) {
            char aChar = chars[i];
            switch (aChar) {
                case '<': {
                    if (++level != 1) continue block16;
                    ++dim;
                    continue block16;
                }
                case ',': {
                    if (level != 1) continue block16;
                    ++dim;
                    continue block16;
                }
                case '>': {
                    --level;
                }
            }
        }
        if (level != 0 || dim == 0) {
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        String[] result = new String[dim];
        dim = 0;
        int ltPos = 0;
        block17: for (int i = afterLastDotIndex; i < chars.length; ++i) {
            char aChar = chars[i];
            switch (aChar) {
                case '<': {
                    if (++level != 1) continue block17;
                    ltPos = i;
                    continue block17;
                }
                case ',': {
                    if (level != 1) continue block17;
                    result[dim++] = new String(chars, ltPos + 1, i - ltPos - 1);
                    ltPos = i;
                    continue block17;
                }
                case '>': {
                    if (--level != 0) continue block17;
                    result[dim++] = new String(chars, ltPos + 1, i - ltPos - 1);
                }
            }
        }
        return result;
    }
}

