/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi;

import org.jetbrains.jet.internal.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.jet.internal.com.intellij.psi.PsiArrayType;
import org.jetbrains.jet.internal.com.intellij.psi.PsiType;
import org.jetbrains.jet.internal.com.intellij.psi.PsiTypeVisitor;

public class PsiEllipsisType
extends PsiArrayType {
    public PsiEllipsisType(PsiType componentType) {
        super(componentType);
    }

    @Override
    public String getPresentableText() {
        return StringUtil.joinOrNull(this.getComponentType().getPresentableText(), "...");
    }

    @Override
    public String getCanonicalText() {
        return StringUtil.joinOrNull(this.getComponentType().getCanonicalText(), "...");
    }

    @Override
    public String getInternalCanonicalText() {
        return StringUtil.joinOrNull(this.getComponentType().getInternalCanonicalText(), "...");
    }

    @Override
    public boolean equalsToText(String text) {
        return text.endsWith("...") && this.getComponentType().equalsToText(text.substring(0, text.length() - 3)) || super.equalsToText(text);
    }

    public PsiType toArrayType() {
        return this.getComponentType().createArrayType();
    }

    @Override
    public <A> A accept(PsiTypeVisitor<A> visitor) {
        return visitor.visitEllipsisType(this);
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof PsiEllipsisType && super.equals(obj);
    }

    @Override
    public int hashCode() {
        return super.hashCode() * 5;
    }
}

