/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi;

import java.util.Collection;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiNamedElement;
import org.jetbrains.jet.internal.com.intellij.psi.ResolveResult;

public class PsiElementResolveResult
implements ResolveResult {
    @NotNull
    private final PsiElement myElement;
    private final boolean myValidResult;

    public PsiElementResolveResult(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/PsiElementResolveResult.<init> must not be null");
        }
        this(element, true);
    }

    public PsiElementResolveResult(@NotNull PsiElement element, boolean validResult) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/PsiElementResolveResult.<init> must not be null");
        }
        this.myElement = element;
        this.myValidResult = validResult;
    }

    @Override
    @NotNull
    public PsiElement getElement() {
        PsiElement psiElement = this.myElement;
        if (psiElement == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/PsiElementResolveResult.getElement must not return null");
        }
        return psiElement;
    }

    @Override
    public boolean isValidResult() {
        return this.myValidResult;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PsiElementResolveResult that = (PsiElementResolveResult)o;
        return this.myElement.equals(that.myElement);
    }

    public int hashCode() {
        return this.myElement.hashCode();
    }

    @NonNls
    public String toString() {
        return "PsiElementResolveResult with " + this.myElement.getClass() + ": " + (this.myElement instanceof PsiNamedElement ? ((PsiNamedElement)this.myElement).getName() : this.myElement.getText());
    }

    public static ResolveResult[] createResults(@Nullable Collection<? extends PsiElement> elements) {
        if (elements == null || elements.isEmpty()) {
            return EMPTY_ARRAY;
        }
        ResolveResult[] results = new ResolveResult[elements.size()];
        int i = 0;
        for (PsiElement psiElement : elements) {
            results[i++] = new PsiElementResolveResult(psiElement);
        }
        return results;
    }

    public static ResolveResult[] createResults(@Nullable PsiElement[] elements) {
        if (elements == null || elements.length == 0) {
            return EMPTY_ARRAY;
        }
        ResolveResult[] results = new ResolveResult[elements.length];
        for (int i = 0; i < elements.length; ++i) {
            results[i] = new PsiElementResolveResult(elements[i]);
        }
        return results;
    }
}

