/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi;

import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.intellij.lang.ASTNode;
import org.jetbrains.jet.internal.com.intellij.lang.Language;
import org.jetbrains.jet.internal.com.intellij.openapi.project.Project;
import org.jetbrains.jet.internal.com.intellij.openapi.util.Iconable;
import org.jetbrains.jet.internal.com.intellij.openapi.util.Key;
import org.jetbrains.jet.internal.com.intellij.openapi.util.TextRange;
import org.jetbrains.jet.internal.com.intellij.openapi.util.UserDataHolder;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.jet.internal.com.intellij.psi.PsiFile;
import org.jetbrains.jet.internal.com.intellij.psi.PsiInvalidElementAccessException;
import org.jetbrains.jet.internal.com.intellij.psi.PsiManager;
import org.jetbrains.jet.internal.com.intellij.psi.PsiReference;
import org.jetbrains.jet.internal.com.intellij.psi.ResolveState;
import org.jetbrains.jet.internal.com.intellij.psi.scope.PsiScopeProcessor;
import org.jetbrains.jet.internal.com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.jet.internal.com.intellij.psi.search.SearchScope;
import org.jetbrains.jet.internal.com.intellij.util.IncorrectOperationException;

public interface PsiElement
extends Iconable,
UserDataHolder {
    public static final PsiElement[] EMPTY_ARRAY = new PsiElement[0];

    @NotNull
    public Project getProject() throws PsiInvalidElementAccessException;

    @NotNull
    public Language getLanguage();

    public PsiManager getManager();

    @NotNull
    public PsiElement[] getChildren();

    public PsiElement getParent();

    @Nullable
    public PsiElement getFirstChild();

    @Nullable
    public PsiElement getLastChild();

    @Nullable
    public PsiElement getNextSibling();

    @Nullable
    public PsiElement getPrevSibling();

    public PsiFile getContainingFile() throws PsiInvalidElementAccessException;

    public TextRange getTextRange();

    public int getStartOffsetInParent();

    public int getTextLength();

    @Nullable
    public PsiElement findElementAt(int var1);

    @Nullable
    public PsiReference findReferenceAt(int var1);

    public int getTextOffset();

    @NonNls
    public String getText();

    @NotNull
    public char[] textToCharArray();

    public PsiElement getNavigationElement();

    public PsiElement getOriginalElement();

    public boolean textMatches(@NotNull @NonNls CharSequence var1);

    public boolean textMatches(@NotNull PsiElement var1);

    public boolean textContains(char var1);

    public void accept(@NotNull PsiElementVisitor var1);

    public void acceptChildren(@NotNull PsiElementVisitor var1);

    public PsiElement copy();

    public PsiElement add(@NotNull PsiElement var1) throws IncorrectOperationException;

    public PsiElement addBefore(@NotNull PsiElement var1, @Nullable PsiElement var2) throws IncorrectOperationException;

    public PsiElement addAfter(@NotNull PsiElement var1, @Nullable PsiElement var2) throws IncorrectOperationException;

    public void checkAdd(@NotNull PsiElement var1) throws IncorrectOperationException;

    public PsiElement addRange(PsiElement var1, PsiElement var2) throws IncorrectOperationException;

    public PsiElement addRangeBefore(@NotNull PsiElement var1, @NotNull PsiElement var2, PsiElement var3) throws IncorrectOperationException;

    public PsiElement addRangeAfter(PsiElement var1, PsiElement var2, PsiElement var3) throws IncorrectOperationException;

    public void delete() throws IncorrectOperationException;

    public void checkDelete() throws IncorrectOperationException;

    public void deleteChildRange(PsiElement var1, PsiElement var2) throws IncorrectOperationException;

    public PsiElement replace(@NotNull PsiElement var1) throws IncorrectOperationException;

    public boolean isValid();

    public boolean isWritable();

    @Nullable
    public PsiReference getReference();

    @NotNull
    public PsiReference[] getReferences();

    @Nullable
    public <T> T getCopyableUserData(Key<T> var1);

    public <T> void putCopyableUserData(Key<T> var1, @Nullable T var2);

    public boolean processDeclarations(@NotNull PsiScopeProcessor var1, @NotNull ResolveState var2, @Nullable PsiElement var3, @NotNull PsiElement var4);

    @Nullable
    public PsiElement getContext();

    public boolean isPhysical();

    @NotNull
    public GlobalSearchScope getResolveScope();

    @NotNull
    public SearchScope getUseScope();

    public ASTNode getNode();

    @NonNls
    public String toString();

    public boolean isEquivalentTo(PsiElement var1);
}

