/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi;

import java.util.EventListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.intellij.openapi.editor.Document;
import org.jetbrains.jet.internal.com.intellij.openapi.project.Project;
import org.jetbrains.jet.internal.com.intellij.openapi.util.Computable;
import org.jetbrains.jet.internal.com.intellij.psi.PsiFile;

public abstract class PsiDocumentManager {
    public abstract boolean isCommitted(@NotNull Document var1);

    public abstract boolean performWhenAllCommitted(@NotNull Runnable var1);

    public static PsiDocumentManager getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/PsiDocumentManager.getInstance must not be null");
        }
        return project.getComponent(PsiDocumentManager.class);
    }

    @Nullable
    public abstract PsiFile getPsiFile(@NotNull Document var1);

    @Nullable
    public abstract PsiFile getCachedPsiFile(@NotNull Document var1);

    public abstract Document getDocument(@NotNull PsiFile var1);

    @Nullable
    public abstract Document getCachedDocument(@NotNull PsiFile var1);

    public abstract void commitAllDocuments();

    public abstract void performForCommittedDocument(@NotNull Document var1, @NotNull Runnable var2);

    public abstract void commitDocument(@NotNull Document var1);

    @NotNull
    public abstract Document[] getUncommittedDocuments();

    public abstract boolean isUncommited(@NotNull Document var1);

    public abstract boolean hasUncommitedDocuments();

    public abstract void commitAndRunReadAction(@NotNull Runnable var1);

    public abstract <T> T commitAndRunReadAction(@NotNull Computable<T> var1);

    public abstract void addListener(@NotNull Listener var1);

    public abstract void removeListener(@NotNull Listener var1);

    public abstract boolean isDocumentBlockedByPsi(@NotNull Document var1);

    public abstract void doPostponedOperationsAndUnblockDocument(@NotNull Document var1);

    public static interface Listener
    extends EventListener {
        public void documentCreated(Document var1, PsiFile var2);

        public void fileCreated(@NotNull PsiFile var1, @NotNull Document var2);
    }
}

