/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi;

import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.intellij.openapi.util.Comparing;
import org.jetbrains.jet.internal.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.jet.internal.com.intellij.psi.GenericsUtil;
import org.jetbrains.jet.internal.com.intellij.psi.PsiAnnotation;
import org.jetbrains.jet.internal.com.intellij.psi.PsiIntersectionType;
import org.jetbrains.jet.internal.com.intellij.psi.PsiManager;
import org.jetbrains.jet.internal.com.intellij.psi.PsiType;
import org.jetbrains.jet.internal.com.intellij.psi.PsiTypeVisitor;
import org.jetbrains.jet.internal.com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.jet.internal.com.intellij.psi.util.CachedValue;
import org.jetbrains.jet.internal.com.intellij.psi.util.CachedValueProvider;
import org.jetbrains.jet.internal.com.intellij.psi.util.CachedValuesManager;
import org.jetbrains.jet.internal.com.intellij.psi.util.PsiModificationTracker;
import org.jetbrains.jet.internal.com.intellij.util.Function;

public class PsiDisjunctionType
extends PsiType {
    private final PsiManager myManager;
    private final List<PsiType> myTypes;
    private final CachedValue<PsiType> myLubCache;

    public PsiDisjunctionType(List<PsiType> types, final PsiManager psiManager) {
        super(PsiAnnotation.EMPTY_ARRAY);
        this.myManager = psiManager;
        this.myTypes = Collections.unmodifiableList(types);
        CachedValuesManager cacheManager = CachedValuesManager.getManager(psiManager.getProject());
        this.myLubCache = cacheManager.createCachedValue(new CachedValueProvider<PsiType>(){

            @Override
            public CachedValueProvider.Result<PsiType> compute() {
                PsiType lub = (PsiType)PsiDisjunctionType.this.myTypes.get(0);
                for (int i = 1; i < PsiDisjunctionType.this.myTypes.size(); ++i) {
                    lub = GenericsUtil.getLeastUpperBound(lub, (PsiType)PsiDisjunctionType.this.myTypes.get(i), psiManager);
                }
                return CachedValueProvider.Result.create(lub, PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT);
            }
        }, false);
    }

    public PsiType getLeastUpperBound() {
        return this.myLubCache.getValue();
    }

    public List<PsiType> getDisjunctions() {
        return this.myTypes;
    }

    public PsiDisjunctionType newDisjunctionType(List<PsiType> types) {
        return new PsiDisjunctionType(types, this.myManager);
    }

    @Override
    public String getPresentableText() {
        return StringUtil.join(this.myTypes, new Function<PsiType, String>(){

            @Override
            public String fun(PsiType psiType) {
                return psiType.getPresentableText();
            }
        }, " | ");
    }

    @Override
    public String getCanonicalText() {
        return StringUtil.join(this.myTypes, new Function<PsiType, String>(){

            @Override
            public String fun(PsiType psiType) {
                return psiType.getCanonicalText();
            }
        }, " | ");
    }

    @Override
    public String getInternalCanonicalText() {
        return StringUtil.join(this.myTypes, new Function<PsiType, String>(){

            @Override
            public String fun(PsiType psiType) {
                return psiType.getInternalCanonicalText();
            }
        }, " | ");
    }

    @Override
    public boolean isValid() {
        for (PsiType type : this.myTypes) {
            if (type.isValid()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equalsToText(@NonNls String text) {
        return Comparing.equal(text, this.getCanonicalText());
    }

    @Override
    public <A> A accept(PsiTypeVisitor<A> visitor) {
        return visitor.visitDisjunctionType(this);
    }

    @Override
    public GlobalSearchScope getResolveScope() {
        return this.getLeastUpperBound().getResolveScope();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public PsiType[] getSuperTypes() {
        PsiType[] psiTypeArray;
        PsiType lub = this.getLeastUpperBound();
        if (lub instanceof PsiIntersectionType) {
            psiTypeArray = ((PsiIntersectionType)lub).getConjuncts();
            if (psiTypeArray == null) throw new IllegalStateException("@NotNull method com/intellij/psi/PsiDisjunctionType.getSuperTypes must not return null");
            return psiTypeArray;
        }
        psiTypeArray = new PsiType[]{lub};
        if (psiTypeArray != null) return psiTypeArray;
        throw new IllegalStateException("@NotNull method com/intellij/psi/PsiDisjunctionType.getSuperTypes must not return null");
    }
}

