/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.intellij.openapi.project.Project;
import org.jetbrains.jet.internal.com.intellij.psi.PsiAnnotation;
import org.jetbrains.jet.internal.com.intellij.psi.PsiType;

public abstract class PsiDiamondType
extends PsiType {
    public PsiDiamondType(PsiAnnotation[] annotations) {
        super(annotations);
    }

    public abstract DiamondInferenceResult resolveInferredTypes();

    public static class DiamondInferenceResult {
        public static final DiamondInferenceResult EXPLICIT_CONSTRUCTOR_TYPE_ARGS = new DiamondInferenceResult(){

            @Override
            @NotNull
            public PsiType[] getTypes() {
                if (PsiType.EMPTY_ARRAY == null) {
                    throw new IllegalStateException("@NotNull method com/intellij/psi/PsiDiamondType$DiamondInferenceResult$1.getTypes must not return null");
                }
                return PsiType.EMPTY_ARRAY;
            }

            @Override
            public String getErrorMessage() {
                return "Cannot use diamonds with explicit type parameters for constructor";
            }
        };
        public static final DiamondInferenceResult NULL_RESULT = new DiamondInferenceResult(){

            @Override
            @NotNull
            public PsiType[] getTypes() {
                if (PsiType.EMPTY_ARRAY == null) {
                    throw new IllegalStateException("@NotNull method com/intellij/psi/PsiDiamondType$DiamondInferenceResult$2.getTypes must not return null");
                }
                return PsiType.EMPTY_ARRAY;
            }

            @Override
            public String getErrorMessage() {
                return "Cannot infer arguments";
            }
        };
        public static final DiamondInferenceResult ANONYMOUS_INNER_RESULT = new DiamondInferenceResult(){

            @Override
            @NotNull
            public PsiType[] getTypes() {
                if (PsiType.EMPTY_ARRAY == null) {
                    throw new IllegalStateException("@NotNull method com/intellij/psi/PsiDiamondType$DiamondInferenceResult$3.getTypes must not return null");
                }
                return PsiType.EMPTY_ARRAY;
            }

            @Override
            public String getErrorMessage() {
                return "Cannot use ''<>'' with anonymous inner classes";
            }
        };
        private final List<PsiType> myInferredTypes = new ArrayList<PsiType>();
        private String myErrorMessage;
        private String myNewExpressionPresentableText;
        private Project myProject;

        public DiamondInferenceResult() {
        }

        public DiamondInferenceResult(String expressionPresentableText, Project project) {
            this.myNewExpressionPresentableText = expressionPresentableText;
            this.myProject = project;
        }

        /*
         * Enabled aggressive block sorting
         */
        @NotNull
        public PsiType[] getTypes() {
            PsiType[] psiTypeArray;
            if (this.myErrorMessage != null) {
                psiTypeArray = PsiType.EMPTY_ARRAY;
                if (PsiType.EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method com/intellij/psi/PsiDiamondType$DiamondInferenceResult.getTypes must not return null");
                return psiTypeArray;
            }
            psiTypeArray = this.myInferredTypes.toArray(new PsiType[this.myInferredTypes.size()]);
            if (psiTypeArray != null) return psiTypeArray;
            throw new IllegalStateException("@NotNull method com/intellij/psi/PsiDiamondType$DiamondInferenceResult.getTypes must not return null");
        }

        public List<PsiType> getInferredTypes() {
            return this.myInferredTypes;
        }

        public String getErrorMessage() {
            return this.myErrorMessage;
        }

        public boolean failedToInfer() {
            return this.myErrorMessage != null;
        }

        public void addInferredType(PsiType psiType) {
            if (this.myErrorMessage != null) {
                return;
            }
            if (psiType == null) {
                this.myErrorMessage = "Cannot infer type arguments for " + this.myNewExpressionPresentableText;
            } else {
                this.myInferredTypes.add(psiType);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DiamondInferenceResult that = (DiamondInferenceResult)o;
            if (this.myErrorMessage != null ? !this.myErrorMessage.equals(that.myErrorMessage) : that.myErrorMessage != null) {
                return false;
            }
            return ((Object)this.myInferredTypes).equals(that.myInferredTypes);
        }

        public int hashCode() {
            int result = ((Object)this.myInferredTypes).hashCode();
            result = 31 * result + (this.myErrorMessage != null ? this.myErrorMessage.hashCode() : 0);
            return result;
        }
    }
}

