/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.intellij.openapi.util.Condition;
import org.jetbrains.jet.internal.com.intellij.openapi.util.Pair;
import org.jetbrains.jet.internal.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.jet.internal.com.intellij.psi.PsiAnnotation;
import org.jetbrains.jet.internal.com.intellij.psi.PsiArrayType;
import org.jetbrains.jet.internal.com.intellij.psi.PsiCapturedWildcardType;
import org.jetbrains.jet.internal.com.intellij.psi.PsiClass;
import org.jetbrains.jet.internal.com.intellij.psi.PsiClassType;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElementFactory;
import org.jetbrains.jet.internal.com.intellij.psi.PsiIntersectionType;
import org.jetbrains.jet.internal.com.intellij.psi.PsiManager;
import org.jetbrains.jet.internal.com.intellij.psi.PsiSubstitutor;
import org.jetbrains.jet.internal.com.intellij.psi.PsiType;
import org.jetbrains.jet.internal.com.intellij.psi.PsiTypeParameter;
import org.jetbrains.jet.internal.com.intellij.psi.PsiTypeVisitor;
import org.jetbrains.jet.internal.com.intellij.psi.PsiWildcardType;
import org.jetbrains.jet.internal.com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.jet.internal.com.intellij.psi.util.InheritanceUtil;
import org.jetbrains.jet.internal.com.intellij.psi.util.PsiUtil;
import org.jetbrains.jet.internal.com.intellij.psi.util.TypeConversionUtil;
import org.jetbrains.jet.internal.com.intellij.util.containers.ContainerUtil;

public class GenericsUtil {
    private GenericsUtil() {
    }

    public static PsiType getGreatestLowerBound(PsiType type1, PsiType type2) {
        return PsiIntersectionType.createIntersection(type1, type2);
    }

    @Nullable
    public static PsiType getLeastUpperBound(PsiType type1, PsiType type2, PsiManager manager) {
        if (TypeConversionUtil.isPrimitiveAndNotNull(type1) || TypeConversionUtil.isPrimitiveAndNotNull(type2)) {
            return null;
        }
        if (TypeConversionUtil.isNullType(type1)) {
            return type2;
        }
        if (TypeConversionUtil.isNullType(type2)) {
            return type1;
        }
        return GenericsUtil.getLeastUpperBound(type1, type2, new LinkedHashSet<Pair<PsiType, PsiType>>(), manager);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private static PsiType getLeastUpperBound(PsiType type1, PsiType type2, Set<Pair<PsiType, PsiType>> compared, PsiManager manager) {
        PsiClass[] supers;
        PsiClass bClass;
        PsiClass aClass;
        PsiClassType.ClassResolveResult classResolveResult2;
        PsiClassType.ClassResolveResult classResolveResult1;
        PsiType componentType;
        PsiType psiType;
        if (type1 instanceof PsiCapturedWildcardType) {
            psiType = GenericsUtil.getLeastUpperBound(((PsiCapturedWildcardType)type1).getUpperBound(), type2, compared, manager);
            if (psiType == null) throw new IllegalStateException("@NotNull method com/intellij/psi/GenericsUtil.getLeastUpperBound must not return null");
            return psiType;
        }
        if (type2 instanceof PsiCapturedWildcardType) {
            psiType = GenericsUtil.getLeastUpperBound(type1, ((PsiCapturedWildcardType)type2).getUpperBound(), compared, manager);
            if (psiType == null) throw new IllegalStateException("@NotNull method com/intellij/psi/GenericsUtil.getLeastUpperBound must not return null");
            return psiType;
        }
        if (type1 instanceof PsiWildcardType) {
            psiType = GenericsUtil.getLeastUpperBound(((PsiWildcardType)type1).getExtendsBound(), type2, compared, manager);
            if (psiType == null) throw new IllegalStateException("@NotNull method com/intellij/psi/GenericsUtil.getLeastUpperBound must not return null");
            return psiType;
        }
        if (type2 instanceof PsiWildcardType) {
            psiType = GenericsUtil.getLeastUpperBound(type1, ((PsiWildcardType)type2).getExtendsBound(), compared, manager);
            if (psiType == null) throw new IllegalStateException("@NotNull method com/intellij/psi/GenericsUtil.getLeastUpperBound must not return null");
            return psiType;
        }
        if (type1 instanceof PsiArrayType && type2 instanceof PsiArrayType && (componentType = GenericsUtil.getLeastUpperBound(((PsiArrayType)type1).getComponentType(), ((PsiArrayType)type2).getComponentType(), manager)) != null) {
            psiType = componentType.createArrayType();
            if (psiType == null) throw new IllegalStateException("@NotNull method com/intellij/psi/GenericsUtil.getLeastUpperBound must not return null");
            return psiType;
        }
        if (type1 instanceof PsiIntersectionType) {
            PsiType[] conjuncts;
            LinkedHashSet<PsiType> newConjuncts = new LinkedHashSet<PsiType>();
            for (PsiType type : conjuncts = ((PsiIntersectionType)type1).getConjuncts()) {
                newConjuncts.add(GenericsUtil.getLeastUpperBound(type, type2, compared, manager));
            }
            psiType = PsiIntersectionType.createIntersection(newConjuncts.toArray(new PsiType[newConjuncts.size()]));
            if (psiType == null) throw new IllegalStateException("@NotNull method com/intellij/psi/GenericsUtil.getLeastUpperBound must not return null");
            return psiType;
        }
        if (type2 instanceof PsiIntersectionType) {
            psiType = GenericsUtil.getLeastUpperBound(type2, type1, compared, manager);
            if (psiType == null) throw new IllegalStateException("@NotNull method com/intellij/psi/GenericsUtil.getLeastUpperBound must not return null");
            return psiType;
        }
        if (type1 instanceof PsiClassType && type2 instanceof PsiClassType) {
            classResolveResult1 = ((PsiClassType)type1).resolveGenerics();
            classResolveResult2 = ((PsiClassType)type2).resolveGenerics();
            aClass = classResolveResult1.getElement();
            bClass = classResolveResult2.getElement();
            if (aClass == null || bClass == null) {
                psiType = PsiType.getJavaLangObject(manager, GlobalSearchScope.allScope(manager.getProject()));
                if (psiType == null) throw new IllegalStateException("@NotNull method com/intellij/psi/GenericsUtil.getLeastUpperBound must not return null");
                return psiType;
            }
            supers = GenericsUtil.getLeastUpperClasses(aClass, bClass);
            if (supers.length == 0) {
                psiType = PsiType.getJavaLangObject(manager, aClass.getResolveScope());
                if (psiType == null) throw new IllegalStateException("@NotNull method com/intellij/psi/GenericsUtil.getLeastUpperBound must not return null");
                return psiType;
            }
        } else {
            PsiClassType cloneable;
            GlobalSearchScope all;
            PsiElementFactory factory;
            PsiClassType serializable;
            PsiType arraySupers;
            if (!(type2 instanceof PsiArrayType && !(type1 instanceof PsiArrayType) ? (psiType = GenericsUtil.getLeastUpperBound(type2, type1, compared, manager)) != null : (type1 instanceof PsiArrayType ? (psiType = GenericsUtil.getLeastUpperBound(arraySupers = PsiIntersectionType.createIntersection(serializable = (factory = JavaPsiFacade.getInstance(manager.getProject()).getElementFactory()).createTypeByFQClassName("java.io.Serializable", all = GlobalSearchScope.allScope(manager.getProject())), cloneable = factory.createTypeByFQClassName("java.lang.Cloneable", all)), type2, compared, manager)) != null : (psiType = PsiType.getJavaLangObject(manager, GlobalSearchScope.allScope(manager.getProject()))) != null))) throw new IllegalStateException("@NotNull method com/intellij/psi/GenericsUtil.getLeastUpperBound must not return null");
            return psiType;
        }
        PsiType[] conjuncts = new PsiClassType[supers.length];
        int i = 0;
        while (true) {
            Iterator<PsiTypeParameter> i$;
            PsiSubstitutor substitutor;
            PsiSubstitutor subst2;
            PsiSubstitutor subst1;
            PsiClass aSuper;
            if (i < supers.length) {
                aSuper = supers[i];
                subst1 = TypeConversionUtil.getSuperClassSubstitutor(aSuper, aClass, classResolveResult1.getSubstitutor());
                subst2 = TypeConversionUtil.getSuperClassSubstitutor(aSuper, bClass, classResolveResult2.getSubstitutor());
                substitutor = PsiSubstitutor.EMPTY;
                i$ = PsiUtil.typeParametersIterable(aSuper).iterator();
            } else {
                psiType = PsiIntersectionType.createIntersection(conjuncts);
                if (psiType == null) throw new IllegalStateException("@NotNull method com/intellij/psi/GenericsUtil.getLeastUpperBound must not return null");
                return psiType;
            }
            while (i$.hasNext()) {
                PsiTypeParameter parameter = i$.next();
                PsiType mapping1 = subst1.substitute(parameter);
                PsiType mapping2 = subst2.substitute(parameter);
                if (mapping1 != null && mapping2 != null) {
                    substitutor = substitutor.put(parameter, GenericsUtil.getLeastContainingTypeArgument(mapping1, mapping2, compared, manager));
                    continue;
                }
                substitutor = substitutor.put(parameter, null);
            }
            conjuncts[i] = JavaPsiFacade.getInstance(manager.getProject()).getElementFactory().createType(aSuper, substitutor);
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PsiType getLeastContainingTypeArgument(PsiType type1, PsiType type2, Set<Pair<PsiType, PsiType>> compared, PsiManager manager) {
        Pair<PsiType, PsiType> types = new Pair<PsiType, PsiType>(type1, type2);
        if (compared.contains(types)) {
            return PsiWildcardType.createUnbounded(manager);
        }
        compared.add(types);
        try {
            if (type1 instanceof PsiWildcardType) {
                PsiWildcardType wild1 = (PsiWildcardType)type1;
                PsiType bound1 = wild1.getBound();
                if (bound1 == null) {
                    PsiType psiType = type1;
                    return psiType;
                }
                if (type2 instanceof PsiWildcardType) {
                    PsiWildcardType wild2 = (PsiWildcardType)type2;
                    PsiType bound2 = wild2.getBound();
                    if (bound2 == null) {
                        PsiWildcardType psiWildcardType = wild1;
                        return psiWildcardType;
                    }
                    if (wild1.isExtends() == wild2.isExtends()) {
                        PsiWildcardType psiWildcardType = wild1.isExtends() ? PsiWildcardType.createExtends(manager, GenericsUtil.getLeastUpperBound(bound1, bound2, compared, manager)) : PsiWildcardType.createSuper(manager, GenericsUtil.getGreatestLowerBound(bound1, bound2));
                        return psiWildcardType;
                    }
                    PsiType psiType = bound1.equals(bound2) ? bound1 : PsiWildcardType.createUnbounded(manager);
                    return psiType;
                }
                PsiWildcardType psiWildcardType = wild1.isExtends() ? PsiWildcardType.createExtends(manager, GenericsUtil.getLeastUpperBound(bound1, type2, compared, manager)) : (wild1.isSuper() ? PsiWildcardType.createSuper(manager, GenericsUtil.getGreatestLowerBound(bound1, type2)) : wild1);
                return psiWildcardType;
            }
            if (type2 instanceof PsiWildcardType) {
                PsiType psiType = GenericsUtil.getLeastContainingTypeArgument(type2, type1, compared, manager);
                return psiType;
            }
            if (type1.equals(type2)) {
                PsiType psiType = type1;
                return psiType;
            }
            PsiWildcardType psiWildcardType = PsiWildcardType.createExtends(manager, GenericsUtil.getLeastUpperBound(type1, type2, compared, manager));
            return psiWildcardType;
        }
        finally {
            compared.remove(types);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static PsiClass[] getLeastUpperClasses(PsiClass aClass, PsiClass bClass) {
        PsiClass[] psiClassArray;
        if (InheritanceUtil.isInheritorOrSelf(aClass, bClass, true)) {
            psiClassArray = new PsiClass[]{bClass};
            if (psiClassArray == null) throw new IllegalStateException("@NotNull method com/intellij/psi/GenericsUtil.getLeastUpperClasses must not return null");
            return psiClassArray;
        }
        LinkedHashSet<PsiClass> supers = new LinkedHashSet<PsiClass>();
        GenericsUtil.getLeastUpperClassesInner(aClass, bClass, supers);
        psiClassArray = supers.toArray(new PsiClass[supers.size()]);
        if (psiClassArray != null) return psiClassArray;
        throw new IllegalStateException("@NotNull method com/intellij/psi/GenericsUtil.getLeastUpperClasses must not return null");
    }

    private static void getLeastUpperClassesInner(PsiClass aClass, PsiClass bClass, Set<PsiClass> supers) {
        if (bClass.isInheritor(aClass, true)) {
            GenericsUtil.addSuper(supers, aClass);
        } else {
            PsiClass[] aSupers;
            for (PsiClass aSuper : aSupers = aClass.getSupers()) {
                GenericsUtil.getLeastUpperClassesInner(aSuper, bClass, supers);
            }
        }
    }

    private static void addSuper(Set<PsiClass> supers, PsiClass classToAdd) {
        Iterator<PsiClass> iterator = supers.iterator();
        while (iterator.hasNext()) {
            PsiClass superClass = iterator.next();
            if (InheritanceUtil.isInheritorOrSelf(superClass, classToAdd, true)) {
                return;
            }
            if (!classToAdd.isInheritor(superClass, true)) continue;
            iterator.remove();
        }
        supers.add(classToAdd);
    }

    public static boolean isTypeArgumentsApplicable(PsiTypeParameter[] typeParams, PsiSubstitutor substitutor, PsiElement context) {
        for (PsiTypeParameter typeParameter : typeParams) {
            PsiClassType[] extendsTypes;
            PsiType substituted = substitutor.substitute(typeParameter);
            if (substituted == null) {
                return true;
            }
            substituted = PsiUtil.captureToplevelWildcards(substituted, context);
            for (PsiClassType type : extendsTypes = typeParameter.getExtendsListTypes()) {
                PsiType extendsType = substitutor.substitute(type);
                if (extendsType.isAssignableFrom(substituted)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isFromExternalTypeLanguage(@NotNull PsiType type) {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/GenericsUtil.isFromExternalTypeLanguage must not be null");
        }
        String internalCanonicalText = type.getInternalCanonicalText();
        return internalCanonicalText != null && internalCanonicalText.equals(type.getCanonicalText());
    }

    public static PsiType getVariableTypeByExpressionType(PsiType type) {
        PsiType transformed = type.accept(new PsiTypeVisitor<PsiType>(){

            @Override
            public PsiType visitArrayType(PsiArrayType arrayType) {
                PsiType componentType = arrayType.getComponentType();
                PsiType type = componentType.accept(this);
                if (type == componentType) {
                    return arrayType;
                }
                return type.createArrayType();
            }

            @Override
            public PsiType visitType(PsiType type) {
                return type;
            }

            @Override
            public PsiType visitWildcardType(PsiWildcardType wildcardType) {
                PsiType bound = wildcardType.getBound();
                PsiManager manager = wildcardType.getManager();
                if (bound != null) {
                    PsiType acceptedBound = bound.accept(this);
                    if (acceptedBound instanceof PsiWildcardType) {
                        if (((PsiWildcardType)acceptedBound).isExtends() != wildcardType.isExtends()) {
                            return PsiWildcardType.createUnbounded(manager);
                        }
                        return acceptedBound;
                    }
                    if (acceptedBound.equals(bound)) {
                        return wildcardType;
                    }
                    return wildcardType.isExtends() ? PsiWildcardType.createExtends(manager, acceptedBound) : PsiWildcardType.createSuper(manager, acceptedBound);
                }
                return wildcardType;
            }

            @Override
            public PsiType visitCapturedWildcardType(PsiCapturedWildcardType capturedWildcardType) {
                return capturedWildcardType.getWildcard().accept(this);
            }

            @Override
            public PsiType visitClassType(PsiClassType classType) {
                PsiClassType.ClassResolveResult resolveResult = classType.resolveGenerics();
                PsiClass aClass = resolveResult.getElement();
                if (aClass == null) {
                    return classType;
                }
                boolean toExtend = false;
                PsiSubstitutor substitutor = PsiSubstitutor.EMPTY;
                for (PsiTypeParameter typeParameter : PsiUtil.typeParametersIterable(aClass)) {
                    PsiType toPut;
                    PsiType typeArgument = resolveResult.getSubstitutor().substitute(typeParameter);
                    if (typeArgument instanceof PsiCapturedWildcardType) {
                        toExtend = true;
                    }
                    if (typeArgument instanceof PsiWildcardType && ((PsiWildcardType)typeArgument).getBound() instanceof PsiIntersectionType) {
                        toExtend = true;
                    }
                    if (typeArgument == null) {
                        toPut = null;
                    } else {
                        PsiType accepted = typeArgument.accept(this);
                        toPut = typeArgument instanceof PsiIntersectionType ? PsiWildcardType.createExtends(typeParameter.getManager(), accepted) : accepted;
                    }
                    substitutor = substitutor.put(typeParameter, toPut);
                }
                PsiAnnotation[] applicableAnnotations = classType.getApplicableAnnotations();
                if (substitutor == PsiSubstitutor.EMPTY && !toExtend && applicableAnnotations.length == 0 && !(aClass instanceof PsiTypeParameter)) {
                    return classType;
                }
                PsiManager manager = aClass.getManager();
                PsiType result = JavaPsiFacade.getInstance(manager.getProject()).getElementFactory().createType(aClass, substitutor, PsiUtil.getLanguageLevel(aClass), applicableAnnotations);
                if (toExtend) {
                    result = PsiWildcardType.createExtends(manager, result);
                }
                return result;
            }
        });
        PsiType componentType = transformed.getDeepComponentType();
        if (componentType instanceof PsiWildcardType) {
            componentType = ((PsiWildcardType)componentType).getExtendsBound();
            int dims = transformed.getArrayDimensions();
            for (int i = 0; i < dims; ++i) {
                componentType = componentType.createArrayType();
            }
            return componentType;
        }
        return transformed;
    }

    public static PsiSubstitutor substituteByParameterName(PsiClass psiClass, PsiSubstitutor parentSubstitutor) {
        Map<PsiTypeParameter, PsiType> substitutionMap = parentSubstitutor.getSubstitutionMap();
        ArrayList<PsiType> result = new ArrayList<PsiType>(substitutionMap.size());
        for (PsiTypeParameter typeParameter : psiClass.getTypeParameters()) {
            final String name = typeParameter.getName();
            PsiTypeParameter key = (PsiTypeParameter)((Object)ContainerUtil.find(substitutionMap.keySet(), new Condition<PsiTypeParameter>(){

                @Override
                public boolean value(PsiTypeParameter psiTypeParameter) {
                    return name.equals(psiTypeParameter.getName());
                }
            }));
            if (key == null) continue;
            result.add(substitutionMap.get(key));
        }
        return PsiSubstitutor.EMPTY.putAll(psiClass, result.toArray(new PsiType[result.size()]));
    }
}

