/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi;

import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.jet.internal.com.intellij.openapi.util.ClassExtension;
import org.jetbrains.jet.internal.com.intellij.openapi.util.TextRange;
import org.jetbrains.jet.internal.com.intellij.psi.ElementManipulator;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;

public class ElementManipulators
extends ClassExtension<ElementManipulator> {
    @NonNls
    public static final String EP_NAME = "org.jetbrains.jet.internal.com.intellij.lang.elementManipulator";
    public static final ElementManipulators INSTANCE = new ElementManipulators();
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.ElementManipulators");

    private ElementManipulators() {
        super(EP_NAME);
    }

    public static <T extends PsiElement> ElementManipulator<T> getManipulator(@NotNull T element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/ElementManipulators.getManipulator must not be null");
        }
        return (ElementManipulator)INSTANCE.forClass(element.getClass());
    }

    public static int getOffsetInElement(PsiElement element) {
        ElementManipulator<PsiElement> manipulator = ElementManipulators.getManipulator(element);
        LOG.assertTrue(manipulator != null, element.getClass().getName());
        return manipulator.getRangeInElement(element).getStartOffset();
    }

    public static TextRange getValueTextRange(PsiElement element) {
        ElementManipulator<PsiElement> manipulator = ElementManipulators.getManipulator(element);
        assert (manipulator != null) : element.getClass().getName();
        return manipulator.getRangeInElement(element);
    }

    public static String getValueText(PsiElement element) {
        TextRange valueTextRange = ElementManipulators.getValueTextRange(element);
        if (valueTextRange.isEmpty()) {
            return "";
        }
        String text = element.getText();
        LOG.assertTrue(valueTextRange.getEndOffset() <= text.length(), "Wrong range for " + element + " text: " + text + " range " + valueTextRange);
        return valueTextRange.substring(text);
    }
}

