/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.intellij.lang.Language;
import org.jetbrains.jet.internal.com.intellij.openapi.editor.Document;
import org.jetbrains.jet.internal.com.intellij.openapi.fileEditor.FileDocumentManager;
import org.jetbrains.jet.internal.com.intellij.openapi.util.UserDataHolderBase;
import org.jetbrains.jet.internal.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.jet.internal.com.intellij.psi.FileViewProvider;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiFile;
import org.jetbrains.jet.internal.com.intellij.psi.PsiManager;
import org.jetbrains.jet.internal.com.intellij.psi.PsiReference;
import org.jetbrains.jet.internal.com.intellij.psi.impl.PsiManagerEx;
import org.jetbrains.jet.internal.com.intellij.psi.impl.SharedPsiElementImplUtil;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.DummyHolder;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.PsiFileImpl;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.LeafElement;
import org.jetbrains.jet.internal.com.intellij.testFramework.LightVirtualFile;
import org.jetbrains.jet.internal.com.intellij.util.LocalTimeCounter;

public class DummyHolderViewProvider
extends UserDataHolderBase
implements FileViewProvider {
    private DummyHolder myHolder;
    private final PsiManager myManager;
    private final long myModificationStamp;
    private final LightVirtualFile myLightVirtualFile;

    public DummyHolderViewProvider(@NotNull PsiManager manager) {
        if (manager == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/DummyHolderViewProvider.<init> must not be null");
        }
        this.myLightVirtualFile = new LightVirtualFile("DummyHolder");
        this.myManager = manager;
        this.myModificationStamp = LocalTimeCounter.currentTime();
    }

    @Override
    @NotNull
    public PsiManager getManager() {
        PsiManager psiManager = this.myManager;
        if (psiManager == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/DummyHolderViewProvider.getManager must not return null");
        }
        return psiManager;
    }

    @Override
    @Nullable
    public Document getDocument() {
        return FileDocumentManager.getInstance().getDocument(this.getVirtualFile());
    }

    @Override
    @NotNull
    public CharSequence getContents() {
        String string = this.myHolder != null ? this.myHolder.getNode().getText() : "";
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/DummyHolderViewProvider.getContents must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public VirtualFile getVirtualFile() {
        LightVirtualFile lightVirtualFile = this.myLightVirtualFile;
        if (lightVirtualFile == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/DummyHolderViewProvider.getVirtualFile must not return null");
        }
        return lightVirtualFile;
    }

    @Override
    @NotNull
    public Language getBaseLanguage() {
        Language language = this.myHolder.getLanguage();
        if (language == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/DummyHolderViewProvider.getBaseLanguage must not return null");
        }
        return language;
    }

    @Override
    @NotNull
    public Set<Language> getLanguages() {
        Set<Language> set = Collections.singleton(this.getBaseLanguage());
        if (set == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/DummyHolderViewProvider.getLanguages must not return null");
        }
        return set;
    }

    @Override
    public PsiFile getPsi(@NotNull Language target) {
        if (target == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/DummyHolderViewProvider.getPsi must not be null");
        }
        ((PsiManagerEx)this.myManager).getFileManager().setViewProvider(this.getVirtualFile(), this);
        return target == this.getBaseLanguage() ? this.myHolder : null;
    }

    @Override
    @NotNull
    public List<PsiFile> getAllFiles() {
        List<PsiFile> list = Collections.singletonList(this.getPsi(this.getBaseLanguage()));
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/DummyHolderViewProvider.getAllFiles must not return null");
        }
        return list;
    }

    @Override
    public void beforeContentsSynchronized() {
    }

    @Override
    public void contentsSynchronized() {
    }

    @Override
    public boolean isEventSystemEnabled() {
        return false;
    }

    @Override
    public boolean isPhysical() {
        return false;
    }

    @Override
    public long getModificationStamp() {
        return this.myModificationStamp;
    }

    @Override
    public boolean supportsIncrementalReparse(@NotNull Language rootLanguage) {
        if (rootLanguage == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/DummyHolderViewProvider.supportsIncrementalReparse must not be null");
        }
        return true;
    }

    @Override
    public void rootChanged(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/DummyHolderViewProvider.rootChanged must not be null");
        }
    }

    public void setDummyHolder(@NotNull DummyHolder dummyHolder) {
        if (dummyHolder == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/DummyHolderViewProvider.setDummyHolder must not be null");
        }
        this.myHolder = dummyHolder;
        this.myLightVirtualFile.setFileType(dummyHolder.getFileType());
    }

    @Override
    public FileViewProvider clone() {
        throw new RuntimeException("Clone is not supported for DummyHolderProviders. Use DummyHolder clone directly.");
    }

    @Override
    public PsiReference findReferenceAt(int offset) {
        return SharedPsiElementImplUtil.findReferenceAt(this.getPsi(this.getBaseLanguage()), offset);
    }

    @Override
    @Nullable
    public PsiElement findElementAt(int offset, @NotNull Language language) {
        if (language == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/DummyHolderViewProvider.findElementAt must not be null");
        }
        return language == this.getBaseLanguage() ? this.findElementAt(offset) : null;
    }

    @Override
    public PsiElement findElementAt(int offset, @NotNull Class<? extends Language> lang) {
        if (lang == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/DummyHolderViewProvider.findElementAt must not be null");
        }
        if (!lang.isAssignableFrom(this.getBaseLanguage().getClass())) {
            return null;
        }
        return this.findElementAt(offset);
    }

    @Override
    public PsiReference findReferenceAt(int offsetInElement, @NotNull Language language) {
        if (language == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/DummyHolderViewProvider.findReferenceAt must not be null");
        }
        return language == this.getBaseLanguage() ? this.findReferenceAt(offsetInElement) : null;
    }

    @Override
    @NotNull
    public FileViewProvider createCopy(@NotNull VirtualFile copy) {
        if (copy == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/DummyHolderViewProvider.createCopy must not be null");
        }
        throw new RuntimeException("Clone is not supported for DummyHolderProviders. Use DummyHolder clone directly.");
    }

    @Override
    public PsiElement findElementAt(int offset) {
        LeafElement element = ((PsiFileImpl)this.getPsi(this.getBaseLanguage())).calcTreeElement().findLeafElementAt(offset);
        return element != null ? element.getPsi() : null;
    }
}

