/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.intellij.lang.Language;
import org.jetbrains.jet.internal.com.intellij.openapi.extensions.Extensions;
import org.jetbrains.jet.internal.com.intellij.openapi.fileTypes.ContentBasedFileSubstitutor;
import org.jetbrains.jet.internal.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.jet.internal.com.intellij.psi.ClassFileViewProvider;
import org.jetbrains.jet.internal.com.intellij.psi.FileViewProvider;
import org.jetbrains.jet.internal.com.intellij.psi.FileViewProviderFactory;
import org.jetbrains.jet.internal.com.intellij.psi.LanguageFileViewProviders;
import org.jetbrains.jet.internal.com.intellij.psi.PsiManager;

public class ClassFileViewProviderFactory
implements FileViewProviderFactory {
    @Override
    public FileViewProvider createFileViewProvider(@NotNull VirtualFile file, Language language, @NotNull PsiManager manager, boolean physical) {
        ContentBasedFileSubstitutor[] processors;
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/ClassFileViewProviderFactory.createFileViewProvider must not be null");
        }
        if (manager == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/psi/ClassFileViewProviderFactory.createFileViewProvider must not be null");
        }
        for (ContentBasedFileSubstitutor processor : processors = Extensions.getExtensions(ContentBasedFileSubstitutor.EP_NAME)) {
            Language lang = processor.obtainLanguageForFile(file);
            if (lang == null) continue;
            FileViewProviderFactory factory = (FileViewProviderFactory)LanguageFileViewProviders.INSTANCE.forLanguage(language);
            return factory.createFileViewProvider(file, language, manager, physical);
        }
        return new ClassFileViewProvider(manager, file, physical);
    }
}

