/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.intellij.openapi.components.ServiceManager;
import org.jetbrains.jet.internal.com.intellij.openapi.fileTypes.FileType;
import org.jetbrains.jet.internal.com.intellij.openapi.project.Project;
import org.jetbrains.jet.internal.com.intellij.openapi.roots.FileIndexFacade;
import org.jetbrains.jet.internal.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.jet.internal.com.intellij.psi.PsiFile;
import org.jetbrains.jet.internal.com.intellij.psi.PsiManager;
import org.jetbrains.jet.internal.com.intellij.psi.SingleRootFileViewProvider;
import org.jetbrains.jet.internal.com.intellij.psi.impl.PsiManagerImpl;
import org.jetbrains.jet.internal.com.intellij.psi.impl.compiled.ClsFileImpl;

public class ClassFileViewProvider
extends SingleRootFileViewProvider {
    public ClassFileViewProvider(@NotNull PsiManager manager, @NotNull VirtualFile file) {
        if (manager == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/ClassFileViewProvider.<init> must not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/ClassFileViewProvider.<init> must not be null");
        }
        super(manager, file);
    }

    public ClassFileViewProvider(@NotNull PsiManager manager, @NotNull VirtualFile virtualFile, boolean physical) {
        if (manager == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/ClassFileViewProvider.<init> must not be null");
        }
        if (virtualFile == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/ClassFileViewProvider.<init> must not be null");
        }
        super(manager, virtualFile, physical);
    }

    @Override
    protected PsiFile createFile(@NotNull Project project, @NotNull VirtualFile vFile, @NotNull FileType fileType) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/ClassFileViewProvider.createFile must not be null");
        }
        if (vFile == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/ClassFileViewProvider.createFile must not be null");
        }
        if (fileType == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/psi/ClassFileViewProvider.createFile must not be null");
        }
        FileIndexFacade fileIndex = ServiceManager.getService(project, FileIndexFacade.class);
        if (fileIndex.isInLibraryClasses(vFile) || !fileIndex.isInSource(vFile)) {
            int index;
            String name = vFile.getName();
            int dotIndex = name.lastIndexOf(46);
            if (dotIndex < 0) {
                dotIndex = name.length();
            }
            if ((index = name.lastIndexOf(36, dotIndex)) >= 0) {
                return null;
            }
            return new ClsFileImpl((PsiManagerImpl)PsiManager.getInstance(project), this);
        }
        return null;
    }

    @Override
    @NotNull
    public SingleRootFileViewProvider createCopy(@NotNull VirtualFile copy) {
        if (copy == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/ClassFileViewProvider.createCopy must not be null");
        }
        ClassFileViewProvider classFileViewProvider = new ClassFileViewProvider(this.getManager(), copy, false);
        if (classFileViewProvider == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/ClassFileViewProvider.createCopy must not return null");
        }
        return classFileViewProvider;
    }
}

