/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.pom.tree.events.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.intellij.lang.ASTNode;
import org.jetbrains.jet.internal.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.jet.internal.com.intellij.openapi.util.Pair;
import org.jetbrains.jet.internal.com.intellij.pom.tree.events.ChangeInfo;
import org.jetbrains.jet.internal.com.intellij.pom.tree.events.ReplaceChangeInfo;
import org.jetbrains.jet.internal.com.intellij.pom.tree.events.TreeChange;
import org.jetbrains.jet.internal.com.intellij.pom.tree.events.impl.ChangeInfoImpl;
import org.jetbrains.jet.internal.com.intellij.pom.tree.events.impl.ReplaceChangeInfoImpl;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.LeafElement;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.TreeElement;
import org.jetbrains.jet.internal.gnu.trove.THashMap;

public class TreeChangeImpl
implements TreeChange {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.tree.events.impl.TreeChangeImpl");
    private final Map<ASTNode, ChangeInfo> myChanges = new THashMap<ASTNode, ChangeInfo>();
    private final List<Pair<ASTNode, Integer>> myOffsets = new ArrayList<Pair<ASTNode, Integer>>();
    private final ASTNode myParent;

    public TreeChangeImpl(ASTNode parent) {
        this.myParent = parent;
    }

    @Override
    public void addChange(ASTNode child, @NotNull ChangeInfo changeInfo) {
        if (changeInfo == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/pom/tree/events/impl/TreeChangeImpl.addChange must not be null");
        }
        LOG.assertTrue(child.getTreeParent() == this.myParent);
        ChangeInfo current = this.myChanges.get(child);
        if (current != null && changeInfo.getChangeType() == 3) {
            return;
        }
        if (changeInfo.getChangeType() == 2) {
            ReplaceChangeInfoImpl replaceChangeInfo = (ReplaceChangeInfoImpl)changeInfo;
            ASTNode replaced = replaceChangeInfo.getReplaced();
            ChangeInfo replacedInfo = this.myChanges.get(replaced);
            if (replacedInfo == null) {
                this.addChangeInternal(child, changeInfo);
            } else {
                switch (replacedInfo.getChangeType()) {
                    case 2: {
                        replaceChangeInfo.setOldLength(replacedInfo.getOldLength());
                        replaceChangeInfo.setReplaced(((ReplaceChangeInfo)((Object)replacedInfo)).getReplaced());
                        break;
                    }
                    case 0: {
                        changeInfo = ChangeInfoImpl.create((short)0, replaced);
                        this.removeChangeInternal(replaced);
                    }
                }
                this.addChangeInternal(child, changeInfo);
            }
            return;
        }
        if (current != null && current.getChangeType() == 1) {
            if (changeInfo.getChangeType() == 0) {
                if (!(child instanceof LeafElement)) {
                    changeInfo = ChangeInfoImpl.create((short)3, child);
                    ((ChangeInfoImpl)changeInfo).setOldLength(current.getOldLength());
                    this.myChanges.put(child, changeInfo);
                } else {
                    this.removeChangeInternal(child);
                }
            }
            return;
        }
        if (current != null && current.getChangeType() == 0) {
            if (changeInfo.getChangeType() == 1) {
                this.removeChangeInternal(child);
            }
            return;
        }
        if (changeInfo.getChangeType() == 1) {
            if (child instanceof LeafElement) {
                CharSequence charTabIndex = child.getChars();
                if (this.checkLeaf(child.getTreeNext(), charTabIndex) || this.checkLeaf(child.getTreePrev(), charTabIndex)) {
                    return;
                }
            }
            this.addChangeInternal(child, changeInfo);
            if (current != null) {
                ((ChangeInfoImpl)changeInfo).setOldLength(current.getOldLength());
            }
            return;
        }
        if (current == null) {
            this.addChangeInternal(child, changeInfo);
        }
    }

    private void addChangeInternal(ASTNode child, ChangeInfo info) {
        if (!this.myChanges.containsKey(child)) {
            int nodeOffset = this.getNodeOffset(child);
            this.addChangeAtOffset(child, nodeOffset);
        }
        this.myChanges.put(child, info);
    }

    private void addChangeAtOffset(ASTNode child, int nodeOffset) {
        int index = 0;
        for (Pair<ASTNode, Integer> pair : this.myOffsets) {
            if (child == pair.getFirst()) {
                return;
            }
            if (nodeOffset < pair.getSecond() || nodeOffset == pair.getSecond() && TreeChangeImpl.isAfter(pair.getFirst(), child)) {
                this.myOffsets.add(index, new Pair<ASTNode, Integer>(child, nodeOffset));
                return;
            }
            ++index;
        }
        this.myOffsets.add(new Pair<ASTNode, Integer>(child, nodeOffset));
    }

    private static boolean isAfter(ASTNode what, ASTNode afterWhat) {
        ASTNode current = afterWhat.getTreeNext();
        while (current != null) {
            if (current == what) {
                return true;
            }
            if ((current = current.getTreeNext()) == null || current.getTextLength() == 0) continue;
            break;
        }
        return false;
    }

    private void removeChangeInternal(ASTNode child) {
        this.myChanges.remove(child);
        int n = this.myOffsets.size();
        for (int i = 0; i < n; ++i) {
            if (child != this.myOffsets.get(i).getFirst()) continue;
            this.myOffsets.remove(i);
            break;
        }
    }

    private boolean checkLeaf(ASTNode treeNext, CharSequence charTabIndex) {
        if (!(treeNext instanceof LeafElement)) {
            return false;
        }
        ChangeInfo right = this.myChanges.get(treeNext);
        if (right != null && right.getChangeType() == 0 && charTabIndex == treeNext.getChars()) {
            this.removeChangeInternal(treeNext);
            return true;
        }
        return false;
    }

    @NotNull
    public TreeElement[] getAffectedChildren() {
        TreeElement[] treeElements = new TreeElement[this.myChanges.size()];
        int index = 0;
        for (Pair<ASTNode, Integer> pair : this.myOffsets) {
            treeElements[index++] = (TreeElement)pair.getFirst();
        }
        if (treeElements == null) {
            throw new IllegalStateException("@NotNull method com/intellij/pom/tree/events/impl/TreeChangeImpl.getAffectedChildren must not return null");
        }
        return treeElements;
    }

    @Override
    public ChangeInfo getChangeByChild(ASTNode child) {
        return this.myChanges.get(child);
    }

    @Override
    public int getChildOffsetInNewTree(@NotNull ASTNode child) {
        if (child == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/pom/tree/events/impl/TreeChangeImpl.getChildOffsetInNewTree must not be null");
        }
        return this.myParent.getStartOffset() + this.getNewOffset(child);
    }

    @Override
    public void composite(@NotNull TreeChange treeChange) {
        if (treeChange == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/pom/tree/events/impl/TreeChangeImpl.composite must not be null");
        }
        TreeChangeImpl change = (TreeChangeImpl)treeChange;
        Set<Map.Entry<ASTNode, ChangeInfo>> entries = change.myChanges.entrySet();
        for (Map.Entry<ASTNode, ChangeInfo> entry : entries) {
            this.addChange(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public void removeChange(ASTNode beforeEqualDepth) {
        this.removeChangeInternal(beforeEqualDepth);
    }

    @Override
    public void add(@NotNull TreeChange value) {
        if (value == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/pom/tree/events/impl/TreeChangeImpl.add must not be null");
        }
        TreeChangeImpl impl = (TreeChangeImpl)value;
        LOG.assertTrue(impl.myParent == this.myParent);
        for (Pair<ASTNode, Integer> pair : impl.myOffsets) {
            ASTNode replaced;
            ASTNode child = pair.getFirst();
            ChangeInfo change = impl.getChangeByChild(child);
            if (change.getChangeType() == 1) {
                ChangeInfo oldChange = this.getChangeByChild(child);
                if (oldChange != null) {
                    switch (oldChange.getChangeType()) {
                        case 0: {
                            this.removeChangeInternal(child);
                            break;
                        }
                        case 2: {
                            replaced = ((ReplaceChangeInfo)((Object)oldChange)).getReplaced();
                            this.removeChangeInternal(child);
                            this.myChanges.put(replaced, ChangeInfoImpl.create((short)1, replaced));
                            this.addChangeAtOffset(replaced, this.getOldOffset(pair.getSecond()));
                            break;
                        }
                        case 3: {
                            ((ChangeInfoImpl)change).setOldLength(oldChange.getOldLength());
                            this.myChanges.put(child, change);
                        }
                    }
                    continue;
                }
                this.myChanges.put(child, change);
                this.addChangeAtOffset(child, this.getOldOffset(pair.getSecond()));
                continue;
            }
            if (change.getChangeType() == 2) {
                ReplaceChangeInfo replaceChangeInfo = (ReplaceChangeInfo)((Object)change);
                replaced = replaceChangeInfo.getReplaced();
                ChangeInfo oldChange = this.getChangeByChild(replaced);
                if (oldChange != null) {
                    switch (oldChange.getChangeType()) {
                        case 0: {
                            change = ChangeInfoImpl.create((short)0, child);
                            break;
                        }
                        case 3: {
                            ((ChangeInfoImpl)change).setOldLength(oldChange.getOldLength());
                            break;
                        }
                        case 2: {
                            ASTNode oldReplaced = ((ReplaceChangeInfo)((Object)oldChange)).getReplaced();
                            ReplaceChangeInfoImpl rep = new ReplaceChangeInfoImpl(child);
                            rep.setReplaced(oldReplaced);
                            change = rep;
                        }
                    }
                    this.removeChangeInternal(replaced);
                }
                this.addChange(child, change);
                continue;
            }
            this.addChange(child, change);
        }
    }

    @Override
    public int getOldLength() {
        int oldLength = ((TreeElement)this.myParent).getNotCachedLength();
        for (Map.Entry<ASTNode, ChangeInfo> entry : this.myChanges.entrySet()) {
            ASTNode key = entry.getKey();
            ChangeInfo change = entry.getValue();
            int length = ((TreeElement)key).getNotCachedLength();
            switch (change.getChangeType()) {
                case 0: {
                    oldLength -= length;
                    break;
                }
                case 1: {
                    oldLength += length;
                    break;
                }
                case 2: 
                case 3: {
                    oldLength += change.getOldLength() - length;
                }
            }
        }
        return oldLength;
    }

    private static int getNewLength(ChangeInfo change, ASTNode node) {
        if (change.getChangeType() == 1) {
            return 0;
        }
        return node.getTextLength();
    }

    private int getNodeOffset(ASTNode child) {
        LOG.assertTrue(child.getTreeParent() == this.myParent);
        int oldOffsetInParent = 0;
        for (ASTNode current = this.myParent.getFirstChildNode(); current != child; current = current.getTreeNext()) {
            if (this.myChanges.containsKey(current)) continue;
            oldOffsetInParent += current.getTextLength();
        }
        for (Pair<ASTNode, Integer> offset : this.myOffsets) {
            if (offset.getSecond() > oldOffsetInParent) break;
            ASTNode changedNode = offset.getFirst();
            ChangeInfo change = this.getChangeByChild(changedNode);
            oldOffsetInParent += change.getOldLength();
        }
        return oldOffsetInParent;
    }

    private int getOldOffset(int offset) {
        for (Pair<ASTNode, Integer> pair : this.myOffsets) {
            if (pair.getSecond() > offset) break;
            ASTNode changedNode = pair.getFirst();
            ChangeInfo change = this.getChangeByChild(changedNode);
            offset += change.getOldLength() - TreeChangeImpl.getNewLength(change, changedNode);
        }
        return offset;
    }

    private int getNewOffset(ASTNode node) {
        ASTNode current = this.myParent.getFirstChildNode();
        Iterator<Pair<ASTNode, Integer>> i = this.myOffsets.iterator();
        Pair<ASTNode, Integer> currentChange = i.hasNext() ? i.next() : null;
        int currentOffsetInNewTree = 0;
        int currentOldOffset = 0;
        while (current != null) {
            boolean counted = false;
            while (currentChange != null && currentOldOffset == currentChange.getSecond()) {
                if (currentChange.getFirst() == node) {
                    return currentOffsetInNewTree;
                }
                if (current == currentChange.getFirst()) {
                    int textLength = current.getTextLength();
                    counted = true;
                    current = current.getTreeNext();
                    currentOffsetInNewTree += textLength;
                }
                ChangeInfo changeInfo = this.myChanges.get(currentChange.getFirst());
                currentOldOffset += changeInfo.getOldLength();
                currentChange = i.hasNext() ? i.next() : null;
            }
            if (current == null) break;
            if (counted) continue;
            int textLength = current.getTextLength();
            currentOldOffset += textLength;
            current = current.getTreeNext();
            currentOffsetInNewTree += textLength;
        }
        return currentOffsetInNewTree;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        Iterator<Pair<ASTNode, Integer>> iterator = this.myOffsets.iterator();
        while (iterator.hasNext()) {
            Pair<ASTNode, Integer> pair = iterator.next();
            ASTNode node = pair.getFirst();
            buffer.append("(");
            buffer.append(node.getElementType().toString());
            buffer.append(" at ").append(pair.getSecond()).append(", ");
            buffer.append(this.getChangeByChild(node).toString());
            buffer.append(")");
            if (!iterator.hasNext()) continue;
            buffer.append(", ");
        }
        return buffer.toString();
    }
}

