/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.pom.tree.events.impl;

import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.intellij.lang.ASTNode;
import org.jetbrains.jet.internal.com.intellij.pom.tree.events.ChangeInfo;
import org.jetbrains.jet.internal.com.intellij.pom.tree.events.TreeChange;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.TreeElement;

public class ChangeInfoImpl
implements ChangeInfo {
    @NonNls
    private static final String[] TO_STRING = new String[]{"add", "remove", "replace", "changed"};
    private final short type;
    private int myOldLength;

    public static ChangeInfoImpl create(short type, @NotNull ASTNode changed) {
        if (changed == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/pom/tree/events/impl/ChangeInfoImpl.create must not be null");
        }
        if (type == 2) {
            throw new IllegalArgumentException("use com.intellij.pom.tree.events.impl.ReplaceChangeInfoImpl");
        }
        return new ChangeInfoImpl(type, changed);
    }

    protected ChangeInfoImpl(short type, @NotNull ASTNode changed) {
        if (changed == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/pom/tree/events/impl/ChangeInfoImpl.<init> must not be null");
        }
        this.myOldLength = 0;
        this.type = type;
        this.myOldLength = type != 0 ? ((TreeElement)changed).getNotCachedLength() : 0;
    }

    @Override
    public int getChangeType() {
        return this.type;
    }

    public String toString() {
        return TO_STRING[this.getChangeType()];
    }

    public void compactChange(TreeChange change) {
        for (ASTNode treeElement : change.getAffectedChildren()) {
            ChangeInfo changeByChild = change.getChangeByChild(treeElement);
            this.processElementaryChange(changeByChild, treeElement);
        }
    }

    public void processElementaryChange(ChangeInfo changeByChild, ASTNode treeElement) {
        switch (changeByChild.getChangeType()) {
            case 0: {
                this.myOldLength -= ((TreeElement)treeElement).getNotCachedLength();
                break;
            }
            case 1: {
                this.myOldLength += changeByChild.getOldLength();
                break;
            }
            case 2: {
                this.myOldLength -= ((TreeElement)treeElement).getNotCachedLength();
                this.myOldLength += changeByChild.getOldLength();
                break;
            }
            case 3: {
                this.myOldLength -= ((TreeElement)treeElement).getNotCachedLength();
                this.myOldLength += changeByChild.getOldLength();
            }
        }
    }

    @Override
    public int getOldLength() {
        return this.myOldLength;
    }

    public void setOldLength(int oldTreeLength) {
        this.myOldLength = oldTreeLength;
    }
}

