/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.pom.java;

import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.intellij.core.JavaCoreBundle;
import org.jetbrains.jet.internal.com.intellij.openapi.util.Key;

public enum LanguageLevel {
    JDK_1_3(JavaCoreBundle.message("jdk.1.3.language.level.description", new Object[0])),
    JDK_1_4(JavaCoreBundle.message("jdk.1.4.language.level.description", new Object[0])),
    JDK_1_5(JavaCoreBundle.message("jdk.1.5.language.level.description", new Object[0])),
    JDK_1_6(JavaCoreBundle.message("jdk.1.6.language.level.description", new Object[0])),
    JDK_1_7(JavaCoreBundle.message("jdk.1.7.language.level.description", new Object[0])),
    JDK_1_8(JavaCoreBundle.message("jdk.1.8.language.level.description", new Object[0]));

    public static final LanguageLevel HIGHEST;
    public static final Key<LanguageLevel> KEY;
    private final String myPresentableText;

    private LanguageLevel(String presentableText) {
        this.myPresentableText = presentableText;
    }

    public int getIndex() {
        return this.ordinal() + 3;
    }

    public boolean hasAssertKeyword() {
        return this.isAtLeast(JDK_1_4);
    }

    public boolean hasEnumKeywordAndAutoboxing() {
        return this.isAtLeast(JDK_1_5);
    }

    public String getPresentableText() {
        return this.myPresentableText;
    }

    public boolean isAtLeast(LanguageLevel level) {
        return this.compareTo(level) >= 0;
    }

    @Nullable
    public static LanguageLevel parse(String value) {
        if ("1.3".equals(value)) {
            return JDK_1_3;
        }
        if ("1.4".equals(value)) {
            return JDK_1_4;
        }
        if ("1.5".equals(value)) {
            return JDK_1_5;
        }
        if ("1.6".equals(value)) {
            return JDK_1_6;
        }
        if ("1.7".equals(value)) {
            return JDK_1_7;
        }
        if ("1.8".equals(value)) {
            return JDK_1_8;
        }
        return null;
    }

    static {
        HIGHEST = JDK_1_8;
        KEY = Key.create("LANGUAGE_LEVEL");
    }
}

