/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.pom.impl;

import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.intellij.pom.PomManager;
import org.jetbrains.jet.internal.com.intellij.pom.PomModelAspect;
import org.jetbrains.jet.internal.com.intellij.pom.PomTransaction;
import org.jetbrains.jet.internal.com.intellij.pom.event.PomModelEvent;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.internal.com.intellij.util.IncorrectOperationException;

public abstract class PomTransactionBase
implements PomTransaction {
    private final PsiElement myScope;
    private final PomModelAspect myAspect;
    private final PomModelEvent myAccumulatedEvent;

    public PomTransactionBase(PsiElement scope, PomModelAspect aspect) {
        this.myScope = scope;
        this.myAspect = aspect;
        this.myAccumulatedEvent = new PomModelEvent(PomManager.getModel(scope.getProject()));
    }

    @Override
    public PomModelEvent getAccumulatedEvent() {
        return this.myAccumulatedEvent;
    }

    @Override
    public void run() throws IncorrectOperationException {
        PomModelEvent event = this.runInner();
        if (event == null) {
            this.myAccumulatedEvent.registerChangeSet(this.myAspect, null);
            return;
        }
        this.myAccumulatedEvent.merge(event);
    }

    @Nullable
    public abstract PomModelEvent runInner() throws IncorrectOperationException;

    @Override
    public PsiElement getChangeScope() {
        return this.myScope;
    }

    @Override
    public PomModelAspect getTransactionAspect() {
        return this.myAspect;
    }
}

