/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.pom.event;

import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.intellij.pom.PomModel;
import org.jetbrains.jet.internal.com.intellij.pom.PomModelAspect;
import org.jetbrains.jet.internal.com.intellij.pom.event.PomChangeSet;

public class PomModelEvent
extends EventObject {
    private Map<PomModelAspect, PomChangeSet> myChangeSets;

    public PomModelEvent(PomModel source) {
        super(source);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public Set<PomModelAspect> getChangedAspects() {
        Set<Object> set;
        if (this.myChangeSets != null) {
            set = this.myChangeSets.keySet();
            if (set == null) throw new IllegalStateException("@NotNull method com/intellij/pom/event/PomModelEvent.getChangedAspects must not return null");
            return set;
        }
        set = Collections.emptySet();
        if (set != null) return set;
        throw new IllegalStateException("@NotNull method com/intellij/pom/event/PomModelEvent.getChangedAspects must not return null");
    }

    public void registerChangeSet(PomModelAspect aspect, PomChangeSet set) {
        if (this.myChangeSets == null) {
            this.myChangeSets = new HashMap<PomModelAspect, PomChangeSet>();
        }
        if (set == null) {
            this.myChangeSets.remove(aspect);
        } else {
            this.myChangeSets.put(aspect, set);
        }
    }

    public <T extends PomChangeSet> T registerChangeSetIfAbsent(PomModelAspect aspect, @NotNull T set) {
        if (set == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/pom/event/PomModelEvent.registerChangeSetIfAbsent must not be null");
        }
        PomChangeSet oldSet = this.getChangeSet(aspect);
        if (oldSet != null) {
            return (T)oldSet;
        }
        this.registerChangeSet(aspect, set);
        return set;
    }

    @Nullable
    public PomChangeSet getChangeSet(PomModelAspect aspect) {
        if (this.myChangeSets == null) {
            return null;
        }
        return this.myChangeSets.get(aspect);
    }

    public void merge(PomModelEvent event) {
        if (event.myChangeSets == null) {
            return;
        }
        if (this.myChangeSets == null) {
            this.myChangeSets = new HashMap<PomModelAspect, PomChangeSet>(event.myChangeSets);
            return;
        }
        for (Map.Entry<PomModelAspect, PomChangeSet> entry : event.myChangeSets.entrySet()) {
            PomModelAspect aspect = entry.getKey();
            PomChangeSet pomChangeSet = this.myChangeSets.get(aspect);
            if (pomChangeSet != null) {
                pomChangeSet.merge(entry.getValue());
                continue;
            }
            this.myChangeSets.put(aspect, entry.getValue());
        }
    }

    @Override
    public PomModel getSource() {
        return (PomModel)super.getSource();
    }
}

