/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.patterns;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.jet.internal.com.intellij.patterns.ElementPattern;
import org.jetbrains.jet.internal.com.intellij.util.PairProcessor;
import org.jetbrains.jet.internal.com.intellij.util.ProcessingContext;
import org.jetbrains.jet.internal.com.intellij.util.ReflectionCache;

public abstract class PatternCondition<T> {
    private static final Logger LOG = Logger.getInstance("#com.intellij.patterns.PatternCondition");
    private final String myDebugMethodName;

    public PatternCondition(@Nullable @NonNls String debugMethodName) {
        this.myDebugMethodName = debugMethodName;
    }

    public String getDebugMethodName() {
        return this.myDebugMethodName;
    }

    private static void appendValue(StringBuilder builder, String indent, Object obj) {
        if (obj instanceof ElementPattern) {
            ((ElementPattern)obj).getCondition().append(builder, indent + "  ");
        } else if (obj instanceof Object[]) {
            PatternCondition.appendArray(builder, indent, (Object[])obj);
        } else if (obj instanceof Collection) {
            PatternCondition.appendArray(builder, indent, ((Collection)obj).toArray());
        } else if (obj instanceof String) {
            builder.append('\"').append(obj).append('\"');
        } else {
            builder.append(obj);
        }
    }

    protected static void appendArray(StringBuilder builder, String indent, Object[] objects) {
        builder.append("[");
        boolean first = true;
        for (Object o : objects) {
            if (!first) {
                builder.append(", ");
            }
            first = false;
            PatternCondition.appendValue(builder, indent, o);
        }
        builder.append("]");
    }

    public abstract boolean accepts(@NotNull T var1, ProcessingContext var2);

    @NonNls
    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.append(builder, "");
        return builder.toString();
    }

    public void append(StringBuilder builder, String indent) {
        builder.append(this.myDebugMethodName);
        builder.append("(");
        this.appendParams(builder, indent);
        builder.append(")");
    }

    private void appendParams(final StringBuilder builder, final String indent) {
        this.processParameters(new PairProcessor<String, Object>(){
            int count;
            String prevName;
            int prevOffset;

            @Override
            public boolean process(String name, Object value) {
                ++this.count;
                if (this.count == 2) {
                    builder.insert(this.prevOffset, this.prevName + "=");
                }
                if (this.count > 1) {
                    builder.append(", ");
                }
                this.prevOffset = builder.length();
                if (this.count > 1) {
                    builder.append(name).append("=");
                }
                PatternCondition.appendValue(builder, indent, value);
                this.prevName = name;
                return true;
            }
        });
    }

    public boolean processParameters(PairProcessor<String, Object> processor) {
        Class aClass = this.getClass();
        while (aClass != null) {
            for (Field field : aClass.getDeclaredFields()) {
                Object value;
                String name;
                String fixedName;
                if (Modifier.isStatic(field.getModifiers()) || ((field.getModifiers() & 0x1000) != 0 || aClass.equals(PatternCondition.class)) && !field.getName().startsWith("val$") || processor.process(fixedName = (name = field.getName()).startsWith("val$") ? name.substring("val$".length()) : name, value = this.getFieldValue(field))) continue;
                return false;
            }
            aClass = ReflectionCache.getSuperClass(aClass);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getFieldValue(Field field) {
        boolean accessible = field.isAccessible();
        try {
            field.setAccessible(true);
            Object object = field.get(this);
            return object;
        }
        catch (IllegalAccessException e) {
            LOG.error(e);
        }
        finally {
            field.setAccessible(accessible);
        }
        return null;
    }
}

