/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.patterns;

import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.intellij.util.ProcessingContext;

public abstract class InitialPatternCondition<T> {
    private final Class<T> myAcceptedClass;

    protected InitialPatternCondition(Class<T> aAcceptedClass) {
        this.myAcceptedClass = aAcceptedClass;
    }

    public Class<T> getAcceptedClass() {
        return this.myAcceptedClass;
    }

    public boolean accepts(@Nullable Object o, ProcessingContext context) {
        return this.myAcceptedClass.isInstance(o);
    }

    @NonNls
    public final String toString() {
        StringBuilder builder = new StringBuilder();
        this.append(builder, "");
        return builder.toString();
    }

    public void append(@NonNls StringBuilder builder, String indent) {
        builder.append("instanceOf(").append(this.myAcceptedClass.getSimpleName()).append(")");
    }
}

