/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.openapi.vfs.newvfs.persistent;

import org.jetbrains.jet.internal.com.intellij.openapi.application.ApplicationManager;

public class PersistentFSConstants {
    public static final long FILE_LENGTH_TO_CACHE_THRESHOLD = 0x1400000L;
    private static int ourMaxIntellisenseFilesize = PersistentFSConstants.computeMaxIntellisenseFileSize();

    public static int getMaxIntellisenseFileSize() {
        return ourMaxIntellisenseFilesize;
    }

    public static void setMaxIntellisenseFileSize(int sizeInBytes) {
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            throw new IllegalStateException("cannot change max setMaxIntellisenseFileSize while running");
        }
        ourMaxIntellisenseFilesize = sizeInBytes;
    }

    private PersistentFSConstants() {
    }

    private static int computeMaxIntellisenseFileSize() {
        int maxLimitBytes = 0x1400000;
        String userLimitKb = System.getProperty("idea.max.intellisense.filesize");
        try {
            return userLimitKb != null ? Math.min(Integer.parseInt(userLimitKb) * 1024, 0x1400000) : 0x1400000;
        }
        catch (NumberFormatException ignored) {
            return 0x1400000;
        }
    }
}

