/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.openapi.vfs.newvfs.events;

import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.jet.internal.com.intellij.openapi.vfs.VirtualFileSystem;
import org.jetbrains.jet.internal.com.intellij.openapi.vfs.newvfs.events.VFileEvent;

public class VFileMoveEvent
extends VFileEvent {
    private final VirtualFile myFile;
    private final VirtualFile myOldParent;
    private final VirtualFile myNewParent;

    public VFileMoveEvent(Object requestor, VirtualFile file, VirtualFile newParent) {
        super(requestor, false);
        this.myFile = file;
        this.myNewParent = newParent;
        this.myOldParent = file.getParent();
    }

    @Override
    public VirtualFile getFile() {
        return this.myFile;
    }

    public VirtualFile getNewParent() {
        return this.myNewParent;
    }

    public VirtualFile getOldParent() {
        return this.myOldParent;
    }

    @NonNls
    public String toString() {
        return "VfsEvent[move " + this.myFile.getName() + " from " + this.myOldParent + " to " + this.myNewParent + "]";
    }

    @Override
    public String getPath() {
        return this.myFile.getPath();
    }

    @Override
    @NotNull
    public VirtualFileSystem getFileSystem() {
        VirtualFileSystem virtualFileSystem = this.myFile.getFileSystem();
        if (virtualFileSystem == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/newvfs/events/VFileMoveEvent.getFileSystem must not return null");
        }
        return virtualFileSystem;
    }

    @Override
    public boolean isValid() {
        return this.myFile.isValid() && this.myFile.getParent() == this.myOldParent && this.myOldParent.isValid();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VFileMoveEvent event = (VFileMoveEvent)o;
        if (!this.myFile.equals(event.myFile)) {
            return false;
        }
        if (!this.myNewParent.equals(event.myNewParent)) {
            return false;
        }
        return this.myOldParent.equals(event.myOldParent);
    }

    @Override
    public int hashCode() {
        int result = this.myFile.hashCode();
        result = 31 * result + this.myOldParent.hashCode();
        result = 31 * result + this.myNewParent.hashCode();
        return result;
    }
}

