/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.openapi.vfs.newvfs.events;

import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.jet.internal.com.intellij.openapi.vfs.VirtualFileSystem;
import org.jetbrains.jet.internal.com.intellij.openapi.vfs.newvfs.events.VFileEvent;

public class VFileDeleteEvent
extends VFileEvent {
    @NotNull
    private final VirtualFile myFile;
    private int myDepth;

    public VFileDeleteEvent(@Nullable Object requestor, @NotNull VirtualFile file, boolean isFromRefresh) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vfs/newvfs/events/VFileDeleteEvent.<init> must not be null");
        }
        super(requestor, isFromRefresh);
        this.myDepth = -1;
        this.myFile = file;
    }

    @Override
    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile = this.myFile;
        if (virtualFile == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/newvfs/events/VFileDeleteEvent.getFile must not return null");
        }
        return virtualFile;
    }

    @NonNls
    public String toString() {
        return "VfsEvent[deleted: " + this.myFile.getUrl() + "]";
    }

    @Override
    public String getPath() {
        return this.myFile.getPath();
    }

    @Override
    @NotNull
    public VirtualFileSystem getFileSystem() {
        VirtualFileSystem virtualFileSystem = this.myFile.getFileSystem();
        if (virtualFileSystem == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/newvfs/events/VFileDeleteEvent.getFileSystem must not return null");
        }
        return virtualFileSystem;
    }

    @Override
    public boolean isValid() {
        return this.myFile.isValid();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VFileDeleteEvent event = (VFileDeleteEvent)o;
        return this.myFile.equals(event.myFile);
    }

    @Override
    public int hashCode() {
        return this.myFile.hashCode();
    }

    public int getFileDepth() {
        if (this.myDepth == -1) {
            int d = 0;
            for (VirtualFile cur = this.myFile; cur != null; cur = cur.getParent()) {
                ++d;
            }
            this.myDepth = d;
        }
        return this.myDepth;
    }
}

