/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.openapi.vfs.local;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.intellij.openapi.util.io.FileUtil;
import org.jetbrains.jet.internal.com.intellij.openapi.vfs.VfsUtilCore;
import org.jetbrains.jet.internal.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.jet.internal.com.intellij.openapi.vfs.VirtualFileSystem;
import org.jetbrains.jet.internal.com.intellij.openapi.vfs.local.CoreLocalFileSystem;

public class CoreLocalVirtualFile
extends VirtualFile {
    private final CoreLocalFileSystem myFileSystem;
    private final File myIoFile;
    private VirtualFile[] myChildren;
    private final boolean isDirectory;

    public CoreLocalVirtualFile(CoreLocalFileSystem fileSystem, File ioFile) {
        this.myFileSystem = fileSystem;
        this.myIoFile = ioFile;
        this.isDirectory = ioFile == null || ioFile.isDirectory();
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myIoFile.getName();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/local/CoreLocalVirtualFile.getName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public VirtualFileSystem getFileSystem() {
        CoreLocalFileSystem coreLocalFileSystem = this.myFileSystem;
        if (coreLocalFileSystem == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/local/CoreLocalVirtualFile.getFileSystem must not return null");
        }
        return coreLocalFileSystem;
    }

    @Override
    public String getPath() {
        return this.myIoFile.getAbsolutePath();
    }

    @Override
    public boolean isWritable() {
        return false;
    }

    @Override
    public boolean isDirectory() {
        return this.isDirectory;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public VirtualFile getParent() {
        File parentFile = this.myIoFile.getParentFile();
        return parentFile != null ? new CoreLocalVirtualFile(this.myFileSystem, parentFile) : null;
    }

    @Override
    public VirtualFile[] getChildren() {
        VirtualFile[] answer = this.myChildren;
        if (answer == null) {
            File[] files;
            ArrayList<CoreLocalVirtualFile> result = new ArrayList<CoreLocalVirtualFile>();
            for (File file : files = this.myIoFile.listFiles()) {
                result.add(new CoreLocalVirtualFile(this.myFileSystem, file));
            }
            answer = result.toArray(new VirtualFile[result.size()]);
            this.myChildren = answer;
        }
        return answer;
    }

    @Override
    @NotNull
    public OutputStream getOutputStream(Object requestor, long newModificationStamp, long newTimeStamp) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public byte[] contentsToByteArray() throws IOException {
        byte[] byArray = FileUtil.loadFileBytes(this.myIoFile);
        if (byArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/local/CoreLocalVirtualFile.contentsToByteArray must not return null");
        }
        return byArray;
    }

    @Override
    public long getTimeStamp() {
        return this.myIoFile.lastModified();
    }

    @Override
    public long getLength() {
        return this.myIoFile.length();
    }

    @Override
    public void refresh(boolean asynchronous, boolean recursive, Runnable postRunnable) {
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return VfsUtilCore.inputStreamSkippingBOM(new FileInputStream(this.myIoFile), this);
    }

    @Override
    public long getModificationStamp() {
        return 0L;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CoreLocalVirtualFile that = (CoreLocalVirtualFile)o;
        return !(this.myIoFile != null ? !this.myIoFile.equals(that.myIoFile) : that.myIoFile != null);
    }

    public int hashCode() {
        return this.myIoFile != null ? this.myIoFile.hashCode() : 0;
    }
}

