/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.openapi.vfs.impl;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.jet.internal.com.intellij.openapi.vfs.VirtualFileCopyEvent;
import org.jetbrains.jet.internal.com.intellij.openapi.vfs.VirtualFileEvent;
import org.jetbrains.jet.internal.com.intellij.openapi.vfs.VirtualFileListener;
import org.jetbrains.jet.internal.com.intellij.openapi.vfs.VirtualFileMoveEvent;
import org.jetbrains.jet.internal.com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import org.jetbrains.jet.internal.com.intellij.openapi.vfs.newvfs.BulkFileListener;
import org.jetbrains.jet.internal.com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import org.jetbrains.jet.internal.com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import org.jetbrains.jet.internal.com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import org.jetbrains.jet.internal.com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import org.jetbrains.jet.internal.com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import org.jetbrains.jet.internal.com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import org.jetbrains.jet.internal.com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;

public class BulkVirtualFileListenerAdapter
implements BulkFileListener {
    private final VirtualFileListener myAdaptee;

    public BulkVirtualFileListenerAdapter(VirtualFileListener adaptee) {
        this.myAdaptee = adaptee;
    }

    @Override
    public void before(@NotNull List<? extends VFileEvent> events) {
        if (events == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/impl/BulkVirtualFileListenerAdapter.before must not be null");
        }
        for (VFileEvent vFileEvent : events) {
            this.fireBefore(vFileEvent);
        }
    }

    @Override
    public void after(@NotNull List<? extends VFileEvent> events) {
        if (events == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/impl/BulkVirtualFileListenerAdapter.after must not be null");
        }
        for (VFileEvent vFileEvent : events) {
            this.fireAfter(vFileEvent);
        }
    }

    private void fireAfter(VFileEvent event) {
        if (event instanceof VFileContentChangeEvent) {
            VFileContentChangeEvent ce = (VFileContentChangeEvent)event;
            VirtualFile file = ce.getFile();
            this.myAdaptee.contentsChanged(new VirtualFileEvent(event.getRequestor(), file, file.getParent(), ce.getOldModificationStamp(), ce.getModificationStamp()));
        } else if (event instanceof VFileCopyEvent) {
            VFileCopyEvent ce = (VFileCopyEvent)event;
            this.myAdaptee.fileCopied(new VirtualFileCopyEvent(event.getRequestor(), ce.getFile(), ce.getNewParent().findChild(ce.getNewChildName())));
        } else if (event instanceof VFileCreateEvent) {
            VFileCreateEvent ce = (VFileCreateEvent)event;
            VirtualFile newChild = ce.getParent().findChild(ce.getChildName());
            if (newChild != null) {
                this.myAdaptee.fileCreated(new VirtualFileEvent(event.getRequestor(), newChild, ce.getChildName(), ce.getParent()));
            }
        } else if (event instanceof VFileDeleteEvent) {
            VFileDeleteEvent de = (VFileDeleteEvent)event;
            this.myAdaptee.fileDeleted(new VirtualFileEvent(event.getRequestor(), de.getFile(), de.getFile().getParent(), 0L, 0L));
        } else if (event instanceof VFileMoveEvent) {
            VFileMoveEvent me = (VFileMoveEvent)event;
            this.myAdaptee.fileMoved(new VirtualFileMoveEvent(event.getRequestor(), me.getFile(), me.getOldParent(), me.getNewParent()));
        } else if (event instanceof VFilePropertyChangeEvent) {
            VFilePropertyChangeEvent pce = (VFilePropertyChangeEvent)event;
            this.myAdaptee.propertyChanged(new VirtualFilePropertyEvent(event.getRequestor(), pce.getFile(), pce.getPropertyName(), pce.getOldValue(), pce.getNewValue()));
        }
    }

    private void fireBefore(VFileEvent event) {
        if (event instanceof VFileContentChangeEvent) {
            VFileContentChangeEvent ce = (VFileContentChangeEvent)event;
            VirtualFile file = ce.getFile();
            this.myAdaptee.beforeContentsChange(new VirtualFileEvent(event.getRequestor(), file, file.getParent(), ce.getOldModificationStamp(), ce.getModificationStamp()));
        } else if (event instanceof VFileDeleteEvent) {
            VFileDeleteEvent de = (VFileDeleteEvent)event;
            this.myAdaptee.beforeFileDeletion(new VirtualFileEvent(event.getRequestor(), de.getFile(), de.getFile().getParent(), 0L, 0L));
        } else if (event instanceof VFileMoveEvent) {
            VFileMoveEvent me = (VFileMoveEvent)event;
            this.myAdaptee.beforeFileMovement(new VirtualFileMoveEvent(event.getRequestor(), me.getFile(), me.getOldParent(), me.getNewParent()));
        } else if (event instanceof VFilePropertyChangeEvent) {
            VFilePropertyChangeEvent pce = (VFilePropertyChangeEvent)event;
            this.myAdaptee.beforePropertyChange(new VirtualFilePropertyEvent(event.getRequestor(), pce.getFile(), pce.getPropertyName(), pce.getOldValue(), pce.getNewValue()));
        }
    }
}

