/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.openapi.vfs;

import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.intellij.openapi.Disposable;
import org.jetbrains.jet.internal.com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.jet.internal.com.intellij.openapi.util.ModificationTracker;
import org.jetbrains.jet.internal.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.jet.internal.com.intellij.openapi.vfs.VirtualFileListener;
import org.jetbrains.jet.internal.com.intellij.openapi.vfs.VirtualFileManagerListener;
import org.jetbrains.jet.internal.com.intellij.openapi.vfs.VirtualFileSystem;
import org.jetbrains.jet.internal.com.intellij.openapi.vfs.newvfs.BulkFileListener;
import org.jetbrains.jet.internal.com.intellij.util.messages.Topic;

public abstract class VirtualFileManager
implements ModificationTracker {
    public static final Topic<BulkFileListener> VFS_CHANGES = new Topic<BulkFileListener>("NewVirtualFileSystem changes", BulkFileListener.class);

    @NotNull
    public static VirtualFileManager getInstance() {
        VirtualFileManager virtualFileManager = ApplicationManager.getApplication().getComponent(VirtualFileManager.class);
        if (virtualFileManager == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/VirtualFileManager.getInstance must not return null");
        }
        return virtualFileManager;
    }

    public abstract VirtualFileSystem getFileSystem(String var1);

    public abstract void refresh(boolean var1);

    public abstract void refreshWithoutFileWatcher(boolean var1);

    public abstract void refresh(boolean var1, @Nullable Runnable var2);

    @Nullable
    public abstract VirtualFile findFileByUrl(@NonNls @NotNull String var1);

    @Nullable
    public abstract VirtualFile refreshAndFindFileByUrl(@NotNull String var1);

    public abstract void addVirtualFileListener(@NotNull VirtualFileListener var1);

    public abstract void addVirtualFileListener(@NotNull VirtualFileListener var1, @NotNull Disposable var2);

    public abstract void removeVirtualFileListener(@NotNull VirtualFileListener var1);

    @NotNull
    public static String constructUrl(@NotNull String protocol, @NotNull String path) {
        if (protocol == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/VirtualFileManager.constructUrl must not be null");
        }
        if (path == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vfs/VirtualFileManager.constructUrl must not be null");
        }
        String string = protocol + "://" + path;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/VirtualFileManager.constructUrl must not return null");
        }
        return string;
    }

    @Nullable
    public static String extractProtocol(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/VirtualFileManager.extractProtocol must not be null");
        }
        int index = url.indexOf("://");
        if (index < 0) {
            return null;
        }
        return url.substring(0, index);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static String extractPath(@NotNull String url) {
        String string;
        if (url == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/VirtualFileManager.extractPath must not be null");
        }
        int index = url.indexOf("://");
        if (index < 0) {
            string = url;
            if (string == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/VirtualFileManager.extractPath must not return null");
            return string;
        }
        string = url.substring(index + "://".length());
        if (string != null) return string;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/VirtualFileManager.extractPath must not return null");
    }

    public abstract void addVirtualFileManagerListener(@NotNull VirtualFileManagerListener var1);

    public abstract void addVirtualFileManagerListener(@NotNull VirtualFileManagerListener var1, @NotNull Disposable var2);

    public abstract void removeVirtualFileManagerListener(@NotNull VirtualFileManagerListener var1);

    public abstract void notifyPropertyChanged(VirtualFile var1, String var2, Object var3, Object var4);
}

