/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.openapi.vfs;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.jet.internal.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.jet.internal.com.intellij.openapi.vfs.VirtualFileCopyEvent;
import org.jetbrains.jet.internal.com.intellij.openapi.vfs.VirtualFileEvent;
import org.jetbrains.jet.internal.com.intellij.openapi.vfs.VirtualFileListener;
import org.jetbrains.jet.internal.com.intellij.openapi.vfs.VirtualFileMoveEvent;
import org.jetbrains.jet.internal.com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import org.jetbrains.jet.internal.com.intellij.openapi.vfs.VirtualFileSystem;
import org.jetbrains.jet.internal.com.intellij.util.containers.ContainerUtil;

public abstract class DeprecatedVirtualFileSystem
extends VirtualFileSystem {
    protected final List<VirtualFileListener> myFileListeners = ContainerUtil.createEmptyCOWList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addVirtualFileListener(@NotNull VirtualFileListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/DeprecatedVirtualFileSystem.addVirtualFileListener must not be null");
        }
        List<VirtualFileListener> list = this.myFileListeners;
        synchronized (list) {
            this.myFileListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeVirtualFileListener(@NotNull VirtualFileListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/DeprecatedVirtualFileSystem.removeVirtualFileListener must not be null");
        }
        List<VirtualFileListener> list = this.myFileListeners;
        synchronized (list) {
            this.myFileListeners.remove(listener);
        }
    }

    protected void firePropertyChanged(Object requestor, @NotNull VirtualFile file, @NotNull String propertyName, Object oldValue, Object newValue) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vfs/DeprecatedVirtualFileSystem.firePropertyChanged must not be null");
        }
        if (propertyName == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/vfs/DeprecatedVirtualFileSystem.firePropertyChanged must not be null");
        }
        this.assertWriteAccessAllowed();
        if (!this.myFileListeners.isEmpty()) {
            VirtualFilePropertyEvent event = new VirtualFilePropertyEvent(requestor, file, propertyName, oldValue, newValue);
            for (VirtualFileListener listener : this.myFileListeners) {
                listener.propertyChanged(event);
            }
        }
    }

    protected void fireContentsChanged(Object requestor, @NotNull VirtualFile file, long oldModificationStamp) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vfs/DeprecatedVirtualFileSystem.fireContentsChanged must not be null");
        }
        this.assertWriteAccessAllowed();
        if (!this.myFileListeners.isEmpty()) {
            VirtualFileEvent event = new VirtualFileEvent(requestor, file, file.getParent(), oldModificationStamp, file.getModificationStamp());
            for (VirtualFileListener listener : this.myFileListeners) {
                listener.contentsChanged(event);
            }
        }
    }

    protected void fireFileCreated(@Nullable Object requestor, @NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vfs/DeprecatedVirtualFileSystem.fireFileCreated must not be null");
        }
        this.assertWriteAccessAllowed();
        if (!this.myFileListeners.isEmpty()) {
            VirtualFileEvent event = new VirtualFileEvent(requestor, file, file.getName(), file.getParent());
            for (VirtualFileListener listener : this.myFileListeners) {
                listener.fileCreated(event);
            }
        }
    }

    protected void fireFileDeleted(Object requestor, @NotNull VirtualFile file, @NotNull String fileName, VirtualFile parent) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vfs/DeprecatedVirtualFileSystem.fireFileDeleted must not be null");
        }
        if (fileName == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/vfs/DeprecatedVirtualFileSystem.fireFileDeleted must not be null");
        }
        this.assertWriteAccessAllowed();
        if (!this.myFileListeners.isEmpty()) {
            VirtualFileEvent event = new VirtualFileEvent(requestor, file, fileName, parent);
            for (VirtualFileListener listener : this.myFileListeners) {
                listener.fileDeleted(event);
            }
        }
    }

    protected void fireFileMoved(Object requestor, @NotNull VirtualFile file, VirtualFile oldParent) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vfs/DeprecatedVirtualFileSystem.fireFileMoved must not be null");
        }
        this.assertWriteAccessAllowed();
        if (!this.myFileListeners.isEmpty()) {
            VirtualFileMoveEvent event = new VirtualFileMoveEvent(requestor, file, oldParent, file.getParent());
            for (VirtualFileListener listener : this.myFileListeners) {
                listener.fileMoved(event);
            }
        }
    }

    protected void fireFileCopied(@Nullable Object requestor, @NotNull VirtualFile originalFile, @NotNull VirtualFile createdFile) {
        if (originalFile == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vfs/DeprecatedVirtualFileSystem.fireFileCopied must not be null");
        }
        if (createdFile == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/vfs/DeprecatedVirtualFileSystem.fireFileCopied must not be null");
        }
        this.assertWriteAccessAllowed();
        if (!this.myFileListeners.isEmpty()) {
            VirtualFileCopyEvent event = new VirtualFileCopyEvent(requestor, originalFile, createdFile);
            for (VirtualFileListener listener : this.myFileListeners) {
                try {
                    listener.fileCopied(event);
                }
                catch (AbstractMethodError e) {
                    listener.fileCreated(event);
                }
            }
        }
    }

    protected void fireBeforePropertyChange(Object requestor, @NotNull VirtualFile file, @NotNull String propertyName, Object oldValue, Object newValue) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vfs/DeprecatedVirtualFileSystem.fireBeforePropertyChange must not be null");
        }
        if (propertyName == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/vfs/DeprecatedVirtualFileSystem.fireBeforePropertyChange must not be null");
        }
        this.assertWriteAccessAllowed();
        if (!this.myFileListeners.isEmpty()) {
            VirtualFilePropertyEvent event = new VirtualFilePropertyEvent(requestor, file, propertyName, oldValue, newValue);
            for (VirtualFileListener listener : this.myFileListeners) {
                listener.beforePropertyChange(event);
            }
        }
    }

    protected void fireBeforeContentsChange(Object requestor, @NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vfs/DeprecatedVirtualFileSystem.fireBeforeContentsChange must not be null");
        }
        this.assertWriteAccessAllowed();
        if (!this.myFileListeners.isEmpty()) {
            VirtualFileEvent event = new VirtualFileEvent(requestor, file, file.getName(), file.getParent());
            for (VirtualFileListener listener : this.myFileListeners) {
                listener.beforeContentsChange(event);
            }
        }
    }

    protected void fireBeforeFileDeletion(Object requestor, @NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vfs/DeprecatedVirtualFileSystem.fireBeforeFileDeletion must not be null");
        }
        this.assertWriteAccessAllowed();
        if (!this.myFileListeners.isEmpty()) {
            VirtualFileEvent event = new VirtualFileEvent(requestor, file, file.getName(), file.getParent());
            for (VirtualFileListener listener : this.myFileListeners) {
                listener.beforeFileDeletion(event);
            }
        }
    }

    protected void fireBeforeFileMovement(Object requestor, @NotNull VirtualFile file, VirtualFile newParent) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vfs/DeprecatedVirtualFileSystem.fireBeforeFileMovement must not be null");
        }
        this.assertWriteAccessAllowed();
        if (!this.myFileListeners.isEmpty()) {
            VirtualFileMoveEvent event = new VirtualFileMoveEvent(requestor, file, file.getParent(), newParent);
            for (VirtualFileListener listener : this.myFileListeners) {
                listener.beforeFileMovement(event);
            }
        }
    }

    protected void assertWriteAccessAllowed() {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }
}

