/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.openapi.vfs;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.intellij.openapi.vfs.encoding.EncodingRegistry;
import org.jetbrains.jet.internal.com.intellij.util.ArrayUtil;
import org.jetbrains.jet.internal.gnu.trove.THashMap;

public class CharsetToolkit {
    @NonNls
    public static final String UTF8 = "UTF-8";
    public static final Charset UTF8_CHARSET = Charset.forName("UTF-8");
    public static final Charset UTF_16LE_CHARSET = Charset.forName("UTF-16LE");
    public static final Charset UTF_16BE_CHARSET = Charset.forName("UTF-16BE");
    private final byte[] buffer;
    private final Charset defaultCharset;
    private boolean enforce8Bit;
    public static final byte[] UTF8_BOM = new byte[]{-17, -69, -65};
    public static final byte[] UTF16LE_BOM = new byte[]{-1, -2};
    public static final byte[] UTF16BE_BOM = new byte[]{-2, -1};
    @NonNls
    public static final String FILE_ENCODING_PROPERTY = "file.encoding";
    @NonNls
    private static final Map<Charset, byte[]> CHARSET_TO_BOM = new THashMap<Charset, byte[]>(2);

    public CharsetToolkit(@NotNull byte[] buffer) {
        if (buffer == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/CharsetToolkit.<init> must not be null");
        }
        this.enforce8Bit = false;
        this.buffer = buffer;
        this.defaultCharset = CharsetToolkit.getDefaultSystemCharset();
    }

    public CharsetToolkit(@NotNull byte[] buffer, Charset defaultCharset) {
        if (buffer == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/CharsetToolkit.<init> must not be null");
        }
        this.enforce8Bit = false;
        this.buffer = buffer;
        this.defaultCharset = defaultCharset != null ? defaultCharset : CharsetToolkit.getDefaultSystemCharset();
    }

    public void setEnforce8Bit(boolean enforce) {
        this.enforce8Bit = enforce;
    }

    public boolean getEnforce8Bit() {
        return this.enforce8Bit;
    }

    public Charset getDefaultCharset() {
        return this.defaultCharset;
    }

    public Charset guessEncoding(int guess_length, Charset defaultCharset) {
        Charset charset = this.guessFromBOM();
        if (charset != null) {
            return charset;
        }
        GuessedEncoding encoding = this.guessFromContent(guess_length);
        switch (encoding) {
            case SEVEN_BIT: {
                if (this.enforce8Bit) {
                    return defaultCharset;
                }
                return Charset.forName("US-ASCII");
            }
            case INVALID_UTF8: {
                return defaultCharset;
            }
            case VALID_UTF8: {
                return UTF8_CHARSET;
            }
        }
        return null;
    }

    @NotNull
    public static String bytesToString(@NotNull byte[] bytes) {
        if (bytes == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/CharsetToolkit.bytesToString must not be null");
        }
        String string = CharsetToolkit.bytesToString(bytes, EncodingRegistry.getInstance().getDefaultCharset());
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/CharsetToolkit.bytesToString must not return null");
        }
        return string;
    }

    @NotNull
    public static String bytesToString(@NotNull byte[] bytes, @NotNull Charset defaultCharset) {
        if (bytes == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/CharsetToolkit.bytesToString must not be null");
        }
        if (defaultCharset == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vfs/CharsetToolkit.bytesToString must not be null");
        }
        Charset charset = new CharsetToolkit(bytes, defaultCharset).guessEncoding(bytes.length);
        int bomLength = CharsetToolkit.getBOMLength(bytes, charset);
        CharBuffer charBuffer = charset.decode(ByteBuffer.wrap(bytes, bomLength, bytes.length - bomLength));
        String string = charBuffer.toString();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/CharsetToolkit.bytesToString must not return null");
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public GuessedEncoding guessFromContent(int guess_length) {
        GuessedEncoding guessedEncoding;
        boolean highOrderBit = false;
        boolean validU8Char = true;
        int length = Math.min(this.buffer.length, guess_length);
        for (int i = 0; i < length; ++i) {
            byte b5;
            byte b0 = this.buffer[i];
            byte b1 = i + 1 >= length ? (byte)0 : this.buffer[i + 1];
            byte b2 = i + 2 >= length ? (byte)0 : this.buffer[i + 2];
            byte b3 = i + 3 >= length ? (byte)0 : this.buffer[i + 3];
            byte b4 = i + 4 >= length ? (byte)0 : this.buffer[i + 4];
            byte by = b5 = i + 5 >= length ? (byte)0 : this.buffer[i + 5];
            if (b0 < 0) {
                highOrderBit = true;
                if (CharsetToolkit.isTwoBytesSequence(b0)) {
                    if (!CharsetToolkit.isContinuationChar(b1)) {
                        validU8Char = false;
                    } else {
                        ++i;
                    }
                } else if (CharsetToolkit.isThreeBytesSequence(b0)) {
                    if (!CharsetToolkit.isContinuationChar(b1) || !CharsetToolkit.isContinuationChar(b2)) {
                        validU8Char = false;
                    } else {
                        i += 2;
                    }
                } else if (CharsetToolkit.isFourBytesSequence(b0)) {
                    if (!(CharsetToolkit.isContinuationChar(b1) && CharsetToolkit.isContinuationChar(b2) && CharsetToolkit.isContinuationChar(b3))) {
                        validU8Char = false;
                    } else {
                        i += 3;
                    }
                } else if (CharsetToolkit.isFiveBytesSequence(b0)) {
                    if (!(CharsetToolkit.isContinuationChar(b1) && CharsetToolkit.isContinuationChar(b2) && CharsetToolkit.isContinuationChar(b3) && CharsetToolkit.isContinuationChar(b4))) {
                        validU8Char = false;
                    } else {
                        i += 4;
                    }
                } else if (CharsetToolkit.isSixBytesSequence(b0)) {
                    if (!(CharsetToolkit.isContinuationChar(b1) && CharsetToolkit.isContinuationChar(b2) && CharsetToolkit.isContinuationChar(b3) && CharsetToolkit.isContinuationChar(b4) && CharsetToolkit.isContinuationChar(b5))) {
                        validU8Char = false;
                    } else {
                        i += 5;
                    }
                } else {
                    validU8Char = false;
                }
            }
            if (!validU8Char) break;
        }
        if (!highOrderBit) {
            guessedEncoding = GuessedEncoding.SEVEN_BIT;
            if (guessedEncoding == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/CharsetToolkit.guessFromContent must not return null");
            return guessedEncoding;
        }
        if (validU8Char) {
            guessedEncoding = GuessedEncoding.VALID_UTF8;
            if (guessedEncoding == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/CharsetToolkit.guessFromContent must not return null");
            return guessedEncoding;
        }
        guessedEncoding = GuessedEncoding.INVALID_UTF8;
        if (guessedEncoding != null) return guessedEncoding;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/CharsetToolkit.guessFromContent must not return null");
    }

    @Nullable
    public Charset guessFromBOM() {
        return CharsetToolkit.guessFromBOM(this.buffer);
    }

    @Nullable
    public static Charset guessFromBOM(@NotNull byte[] buffer) {
        if (buffer == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/CharsetToolkit.guessFromBOM must not be null");
        }
        if (CharsetToolkit.hasUTF8Bom(buffer)) {
            return UTF8_CHARSET;
        }
        if (CharsetToolkit.hasUTF16LEBom(buffer)) {
            return UTF_16LE_CHARSET;
        }
        if (CharsetToolkit.hasUTF16BEBom(buffer)) {
            return UTF_16BE_CHARSET;
        }
        return null;
    }

    public Charset guessEncoding(int guess_length) {
        return this.guessEncoding(guess_length, this.defaultCharset);
    }

    public static Charset guessEncoding(@NotNull File f, int bufferLength) throws IOException {
        if (f == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/CharsetToolkit.guessEncoding must not be null");
        }
        return CharsetToolkit.guessEncoding(f, bufferLength, EncodingRegistry.getInstance().getDefaultCharset());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Charset guessEncoding(@NotNull File f, int bufferLength, Charset defaultCharset) throws IOException {
        int read;
        if (f == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/CharsetToolkit.guessEncoding must not be null");
        }
        byte[] buffer = new byte[bufferLength];
        FileInputStream fis = new FileInputStream(f);
        try {
            read = fis.read(buffer);
        }
        finally {
            fis.close();
        }
        CharsetToolkit toolkit = new CharsetToolkit(buffer, defaultCharset);
        return toolkit.guessEncoding(read);
    }

    private static boolean isContinuationChar(byte b) {
        return -128 <= b && b <= -65;
    }

    private static boolean isTwoBytesSequence(byte b) {
        return -64 <= b && b <= -33;
    }

    private static boolean isThreeBytesSequence(byte b) {
        return -32 <= b && b <= -17;
    }

    private static boolean isFourBytesSequence(byte b) {
        return -16 <= b && b <= -9;
    }

    private static boolean isFiveBytesSequence(byte b) {
        return -8 <= b && b <= -5;
    }

    private static boolean isSixBytesSequence(byte b) {
        return -4 <= b && b <= -3;
    }

    @Nullable
    public static Charset getDefaultSystemCharset() {
        Charset charset = null;
        try {
            charset = Charset.forName(System.getProperty(FILE_ENCODING_PROPERTY));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return charset;
    }

    public static boolean hasUTF8Bom(@NotNull byte[] bom) {
        if (bom == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/CharsetToolkit.hasUTF8Bom must not be null");
        }
        return ArrayUtil.startsWith(bom, UTF8_BOM);
    }

    public static boolean hasUTF16LEBom(@NotNull byte[] bom) {
        if (bom == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/CharsetToolkit.hasUTF16LEBom must not be null");
        }
        return ArrayUtil.startsWith(bom, UTF16LE_BOM);
    }

    public static boolean hasUTF16BEBom(@NotNull byte[] bom) {
        if (bom == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/CharsetToolkit.hasUTF16BEBom must not be null");
        }
        return ArrayUtil.startsWith(bom, UTF16BE_BOM);
    }

    @NotNull
    public static Charset[] getAvailableCharsets() {
        Collection<Charset> collection = Charset.availableCharsets().values();
        Charset[] charsetArray = collection.toArray(new Charset[collection.size()]);
        if (charsetArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/CharsetToolkit.getAvailableCharsets must not return null");
        }
        return charsetArray;
    }

    @NotNull
    public static byte[] getUtf8Bytes(@NotNull String s) {
        byte[] byArray;
        if (s == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/CharsetToolkit.getUtf8Bytes must not be null");
        }
        try {
            byArray = s.getBytes(UTF8);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF-8 must be supported", e);
        }
        if (byArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/CharsetToolkit.getUtf8Bytes must not return null");
        }
        return byArray;
    }

    public static int getBOMLength(@NotNull byte[] content, Charset charset) {
        if (content == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/CharsetToolkit.getBOMLength must not be null");
        }
        if (charset != null && charset.name().contains(UTF8) && CharsetToolkit.hasUTF8Bom(content)) {
            return UTF8_BOM.length;
        }
        if (CharsetToolkit.hasUTF16LEBom(content)) {
            return UTF16LE_BOM.length;
        }
        if (CharsetToolkit.hasUTF16BEBom(content)) {
            return UTF16BE_BOM.length;
        }
        return 0;
    }

    @Nullable
    public static byte[] getBom(@NotNull Charset charset) {
        if (charset == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/CharsetToolkit.getBom must not be null");
        }
        return CHARSET_TO_BOM.get(charset);
    }

    public static boolean canHaveBom(@NotNull Charset charset, @Nullable byte[] bom) {
        if (charset == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/CharsetToolkit.canHaveBom must not be null");
        }
        return bom != null && charset.equals(UTF8_CHARSET) && Arrays.equals(bom, UTF8_BOM);
    }

    public static Charset forName(String name) {
        Charset charset = null;
        if (name != null) {
            try {
                charset = Charset.forName(name);
            }
            catch (IllegalCharsetNameException illegalCharsetNameException) {
            }
            catch (UnsupportedCharsetException unsupportedCharsetException) {
                // empty catch block
            }
        }
        return charset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static InputStream inputStreamSkippingBOM(@NotNull InputStream stream) throws IOException {
        InputStream inputStream;
        if (stream == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/CharsetToolkit.inputStreamSkippingBOM must not be null");
        }
        assert (stream.markSupported()) : stream;
        stream.mark(3);
        boolean mustReset = true;
        int ret = stream.read();
        if (ret == -1) {
            InputStream inputStream2 = stream;
            inputStream = inputStream2;
            if (inputStream == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/CharsetToolkit.inputStreamSkippingBOM must not return null");
            return inputStream;
        }
        byte b0 = (byte)ret;
        if (b0 != UTF8_BOM[0] && b0 != UTF16LE_BOM[0] && b0 != UTF16BE_BOM[0]) {
            InputStream inputStream3 = stream;
            inputStream = inputStream3;
            if (inputStream == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/CharsetToolkit.inputStreamSkippingBOM must not return null");
            return inputStream;
        }
        ret = stream.read();
        if (ret == -1) {
            InputStream inputStream4 = stream;
            inputStream = inputStream4;
            if (inputStream == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/CharsetToolkit.inputStreamSkippingBOM must not return null");
            return inputStream;
        }
        byte b1 = (byte)ret;
        if (b0 == UTF16LE_BOM[0] && b1 == UTF16LE_BOM[1]) {
            mustReset = false;
            InputStream inputStream5 = stream;
            inputStream = inputStream5;
            if (inputStream == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/CharsetToolkit.inputStreamSkippingBOM must not return null");
            return inputStream;
        }
        if (b0 == UTF16BE_BOM[0] && b1 == UTF16BE_BOM[1]) {
            mustReset = false;
            InputStream inputStream6 = stream;
            inputStream = inputStream6;
            if (inputStream == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/CharsetToolkit.inputStreamSkippingBOM must not return null");
            return inputStream;
        }
        if (b0 != UTF8_BOM[0] || b1 != UTF8_BOM[1]) {
            InputStream inputStream7 = stream;
            inputStream = inputStream7;
            if (inputStream == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/CharsetToolkit.inputStreamSkippingBOM must not return null");
            return inputStream;
        }
        ret = stream.read();
        if (ret == -1) {
            InputStream inputStream8 = stream;
            inputStream = inputStream8;
            if (inputStream == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/CharsetToolkit.inputStreamSkippingBOM must not return null");
            return inputStream;
        }
        byte b2 = (byte)ret;
        if (b2 == UTF8_BOM[2]) {
            mustReset = false;
            InputStream inputStream9 = stream;
            inputStream = inputStream9;
            if (inputStream == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/CharsetToolkit.inputStreamSkippingBOM must not return null");
            return inputStream;
        }
        InputStream inputStream10 = stream;
        inputStream = inputStream10;
        if (inputStream != null) return inputStream;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/CharsetToolkit.inputStreamSkippingBOM must not return null");
        finally {
            if (mustReset) {
                stream.reset();
            }
        }
    }

    static {
        CHARSET_TO_BOM.put(UTF_16LE_CHARSET, UTF16LE_BOM);
        CHARSET_TO_BOM.put(UTF_16BE_CHARSET, UTF16BE_BOM);
    }

    public static enum GuessedEncoding {
        SEVEN_BIT,
        VALID_UTF8,
        INVALID_UTF8;

    }
}

