/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.openapi.util.text;

import java.beans.Introspector;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.google.common.collect.Lists;
import org.jetbrains.jet.internal.com.intellij.CommonBundle;
import org.jetbrains.jet.internal.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.jet.internal.com.intellij.openapi.util.Pair;
import org.jetbrains.jet.internal.com.intellij.openapi.util.TextRange;
import org.jetbrains.jet.internal.com.intellij.openapi.util.text.CharFilter;
import org.jetbrains.jet.internal.com.intellij.openapi.util.text.CharSequenceWithStringHash;
import org.jetbrains.jet.internal.com.intellij.util.ArrayUtil;
import org.jetbrains.jet.internal.com.intellij.util.ExceptionUtil;
import org.jetbrains.jet.internal.com.intellij.util.Function;
import org.jetbrains.jet.internal.com.intellij.util.NotNullFunction;
import org.jetbrains.jet.internal.com.intellij.util.SmartList;
import org.jetbrains.jet.internal.com.intellij.util.StringBuilderSpinAllocator;
import org.jetbrains.jet.internal.com.intellij.util.text.CharArrayCharSequence;
import org.jetbrains.jet.internal.com.intellij.util.text.CharArrayUtil;
import org.jetbrains.jet.internal.com.intellij.util.text.LineReader;

public class StringUtil {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.util.text.StringUtil");
    private static final Pattern EOL_SPLIT_PATTERN = Pattern.compile(" *(\r|\n|\r\n)+ *");
    public static final NotNullFunction<String, String> QUOTER = new NotNullFunction<String, String>(){

        @Override
        @NotNull
        public String fun(String s) {
            String string = "\"" + s + "\"";
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil$1.fun must not return null");
            }
            return string;
        }
    };
    public static final NotNullFunction<String, String> SINGLE_QUOTER = new NotNullFunction<String, String>(){

        @Override
        @NotNull
        public String fun(String s) {
            String string = "'" + s + "'";
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil$2.fun must not return null");
            }
            return string;
        }
    };
    public static Function<String, String> TRIMMER = new Function<String, String>(){

        @Override
        @Nullable
        public String fun(String s) {
            return s == null ? null : s.trim();
        }
    };
    @NonNls
    private static final String[] ourPrepositions = new String[]{"at", "the", "and", "not", "if", "a", "or", "to", "in", "on", "into", "by"};
    @NonNls
    private static final String[] REPLACES_REFS = new String[]{"&lt;", "&gt;", "&amp;", "&#39;", "&quot;"};
    @NonNls
    private static final String[] REPLACES_DISP = new String[]{"<", ">", "&", "'", "\""};

    public static List<String> getWordsInStringLongestFirst(String find) {
        List<String> words = StringUtil.getWordsIn(find);
        Collections.sort(words, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o2.length() - o1.length();
            }
        });
        return words;
    }

    @NotNull
    public static String escapePattern(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.escapePattern must not be null");
        }
        String string = StringUtil.replace(StringUtil.replace(text, "'", "''"), "{", "'{'");
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.escapePattern must not return null");
        }
        return string;
    }

    public static <T> Function<T, String> createToStringFunction(Class<T> cls) {
        return new Function<T, String>(){

            @Override
            public String fun(T o) {
                return o.toString();
            }
        };
    }

    public static String replace(@NonNls @NotNull String text, @NonNls @NotNull String oldS, @NonNls @Nullable String newS) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.replace must not be null");
        }
        if (oldS == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.replace must not be null");
        }
        return StringUtil.replace(text, oldS, newS, false);
    }

    public static String replaceIgnoreCase(@NotNull String text, @NotNull String oldS, @Nullable String newS) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.replaceIgnoreCase must not be null");
        }
        if (oldS == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.replaceIgnoreCase must not be null");
        }
        return StringUtil.replace(text, oldS, newS, true);
    }

    public static void replaceChar(@NotNull char[] buffer, char oldChar, char newChar, int start, int end) {
        if (buffer == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.replaceChar must not be null");
        }
        for (int i = start; i < end; ++i) {
            char c = buffer[i];
            if (c != oldChar) continue;
            buffer[i] = newChar;
        }
    }

    @NotNull
    public static String replaceChar(@NotNull String buffer, char oldChar, char newChar) {
        if (buffer == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.replaceChar must not be null");
        }
        StringBuilder newBuffer = null;
        for (int i = 0; i < buffer.length(); ++i) {
            char c = buffer.charAt(i);
            if (c == oldChar) {
                if (newBuffer == null) {
                    newBuffer = new StringBuilder(buffer.length());
                    newBuffer.append(buffer, 0, i);
                }
                newBuffer.append(newChar);
                continue;
            }
            if (newBuffer == null) continue;
            newBuffer.append(c);
        }
        String string = newBuffer == null ? buffer : newBuffer.toString();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.replaceChar must not return null");
        }
        return string;
    }

    @Nullable
    public static String replace(@NotNull String text, @NotNull String oldS, @Nullable String newS, boolean ignoreCase) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.replace must not be null");
        }
        if (oldS == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.replace must not be null");
        }
        if (text.length() < oldS.length()) {
            return text;
        }
        String text1 = ignoreCase ? text.toLowerCase() : text;
        String oldS1 = ignoreCase ? oldS.toLowerCase() : oldS;
        StringBuilder newText = null;
        int i = 0;
        while (i < text1.length()) {
            int i1 = text1.indexOf(oldS1, i);
            if (i1 < 0) {
                if (i == 0) {
                    return text;
                }
                newText.append(text, i, text.length());
                break;
            }
            if (newS == null) {
                return null;
            }
            if (newText == null) {
                newText = new StringBuilder();
            }
            newText.append(text, i, i1);
            newText.append(newS);
            i = i1 + oldS.length();
        }
        return newText != null ? newText.toString() : "";
    }

    @NotNull
    public static String getShortName(@NotNull String fqName) {
        if (fqName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.getShortName must not be null");
        }
        String string = StringUtil.getShortName(fqName, '.');
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.getShortName must not return null");
        }
        return string;
    }

    @NotNull
    public static String getShortName(@NotNull Class aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.getShortName must not be null");
        }
        String string = StringUtil.getShortName(aClass.getName());
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.getShortName must not return null");
        }
        return string;
    }

    public static int indexOfIgnoreCase(@NotNull String where, @NotNull String what, int fromIndex) {
        if (where == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.indexOfIgnoreCase must not be null");
        }
        if (what == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.indexOfIgnoreCase must not be null");
        }
        int targetCount = what.length();
        int sourceCount = where.length();
        if (fromIndex >= sourceCount) {
            return targetCount == 0 ? sourceCount : -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (targetCount == 0) {
            return fromIndex;
        }
        char first = what.charAt(0);
        int max = sourceCount - targetCount;
        for (int i = fromIndex; i <= max; ++i) {
            if (!StringUtil.charsEqualIgnoreCase(where.charAt(i), first)) {
                while (++i <= max && !StringUtil.charsEqualIgnoreCase(where.charAt(i), first)) {
                }
            }
            if (i > max) continue;
            int j = i + 1;
            int end = j + targetCount - 1;
            int k = 1;
            while (j < end && StringUtil.charsEqualIgnoreCase(where.charAt(j), what.charAt(k))) {
                ++j;
                ++k;
            }
            if (j != end) continue;
            return i;
        }
        return -1;
    }

    public static boolean containsIgnoreCase(@NotNull String where, @NotNull String what) {
        if (where == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.containsIgnoreCase must not be null");
        }
        if (what == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.containsIgnoreCase must not be null");
        }
        return StringUtil.indexOfIgnoreCase(where, what, 0) >= 0;
    }

    public static boolean endsWithIgnoreCase(@NonNls @NotNull String str, @NonNls @NotNull String suffix) {
        int suffixLength;
        if (str == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.endsWithIgnoreCase must not be null");
        }
        if (suffix == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.endsWithIgnoreCase must not be null");
        }
        int stringLength = str.length();
        return stringLength >= (suffixLength = suffix.length()) && str.regionMatches(true, stringLength - suffixLength, suffix, 0, suffixLength);
    }

    public static boolean startsWithIgnoreCase(@NonNls @NotNull String str, @NonNls @NotNull String prefix) {
        int prefixLength;
        if (str == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.startsWithIgnoreCase must not be null");
        }
        if (prefix == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.startsWithIgnoreCase must not be null");
        }
        int stringLength = str.length();
        return stringLength >= (prefixLength = prefix.length()) && str.regionMatches(true, 0, prefix, 0, prefixLength);
    }

    public static boolean charsEqualIgnoreCase(char a, char b) {
        return a == b || StringUtil.toUpperCase(a) == StringUtil.toUpperCase(b) || StringUtil.toLowerCase(a) == StringUtil.toLowerCase(b);
    }

    public static char toUpperCase(char a) {
        if (a < 'a') {
            return a;
        }
        if (a >= 'a' && a <= 'z') {
            return (char)(a + -32);
        }
        return Character.toUpperCase(a);
    }

    public static char toLowerCase(char a) {
        if (a < 'A' || a >= 'a' && a <= 'z') {
            return a;
        }
        if (a >= 'A' && a <= 'Z') {
            return (char)(a + 32);
        }
        return Character.toLowerCase(a);
    }

    public static String stripHtml(String html, boolean convertBreaks) {
        if (convertBreaks) {
            html = html.replaceAll("<br/?>", "\n\n");
        }
        return html.replaceAll("<(.|\n)*?>", "");
    }

    @Nullable
    public static String toLowerCase(@Nullable String str) {
        return str == null ? null : str.toLowerCase();
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static String getShortName(@NotNull String fqName, char separator) {
        String string;
        if (fqName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.getShortName must not be null");
        }
        int lastPointIdx = fqName.lastIndexOf(separator);
        if (lastPointIdx >= 0) {
            string = fqName.substring(lastPointIdx + 1);
            if (string == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.getShortName must not return null");
            return string;
        }
        string = fqName;
        if (string != null) return string;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.getShortName must not return null");
    }

    @NotNull
    public static String getPackageName(@NotNull String fqName) {
        if (fqName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.getPackageName must not be null");
        }
        String string = StringUtil.getPackageName(fqName, '.');
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.getPackageName must not return null");
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public static String getPackageName(@NotNull String fqName, char separator) {
        if (fqName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.getPackageName must not be null");
        }
        int lastPointIdx = fqName.lastIndexOf(separator);
        if (lastPointIdx < 0) return "";
        String string = fqName.substring(0, lastPointIdx);
        String string2 = string;
        if (string != null) return string2;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.getPackageName must not return null");
    }

    @NotNull
    public static String convertLineSeparators(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.convertLineSeparators must not be null");
        }
        String string = StringUtil.convertLineSeparators(text, false);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.convertLineSeparators must not return null");
        }
        return string;
    }

    @NotNull
    public static String convertLineSeparators(@NotNull String text, boolean keepCarriageReturn) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.convertLineSeparators must not be null");
        }
        String string = StringUtil.convertLineSeparators(text, "\n", null, keepCarriageReturn);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.convertLineSeparators must not return null");
        }
        return string;
    }

    @NotNull
    public static String convertLineSeparators(@NotNull String text, @NotNull String newSeparator) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.convertLineSeparators must not be null");
        }
        if (newSeparator == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.convertLineSeparators must not be null");
        }
        String string = StringUtil.convertLineSeparators(text, newSeparator, null);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.convertLineSeparators must not return null");
        }
        return string;
    }

    @NotNull
    public static String convertLineSeparators(@NotNull String text, @NotNull String newSeparator, @Nullable int[] offsetsToKeep) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.convertLineSeparators must not be null");
        }
        if (newSeparator == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.convertLineSeparators must not be null");
        }
        String string = StringUtil.convertLineSeparators(text, newSeparator, offsetsToKeep, false);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.convertLineSeparators must not return null");
        }
        return string;
    }

    @NotNull
    public static String convertLineSeparators(@NotNull String text, @NotNull String newSeparator, @Nullable int[] offsetsToKeep, boolean keepCarriageReturn) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.convertLineSeparators must not be null");
        }
        if (newSeparator == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.convertLineSeparators must not be null");
        }
        StringBuilder buffer = null;
        int intactLength = 0;
        boolean newSeparatorIsSlashN = "\n".equals(newSeparator);
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == '\n') {
                if (!newSeparatorIsSlashN) {
                    if (buffer == null) {
                        buffer = new StringBuilder(text.length());
                        buffer.append(text, 0, intactLength);
                    }
                    buffer.append(newSeparator);
                    StringUtil.shiftOffsets(offsetsToKeep, buffer.length(), 1, newSeparator.length());
                    continue;
                }
                if (buffer == null) {
                    ++intactLength;
                    continue;
                }
                buffer.append(c);
                continue;
            }
            if (c == '\r') {
                boolean followedByLineFeed;
                boolean bl = followedByLineFeed = i < text.length() - 1 && text.charAt(i + 1) == '\n';
                if (!followedByLineFeed && keepCarriageReturn) {
                    if (buffer == null) {
                        ++intactLength;
                        continue;
                    }
                    buffer.append(c);
                    continue;
                }
                if (buffer == null) {
                    buffer = new StringBuilder(text.length());
                    buffer.append(text, 0, intactLength);
                }
                buffer.append(newSeparator);
                if (followedByLineFeed) {
                    ++i;
                    StringUtil.shiftOffsets(offsetsToKeep, buffer.length(), 2, newSeparator.length());
                    continue;
                }
                StringUtil.shiftOffsets(offsetsToKeep, buffer.length(), 1, newSeparator.length());
                continue;
            }
            if (buffer == null) {
                ++intactLength;
                continue;
            }
            buffer.append(c);
        }
        String string = buffer == null ? text : buffer.toString();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.convertLineSeparators must not return null");
        }
        return string;
    }

    private static void shiftOffsets(int[] offsets, int changeOffset, int oldLength, int newLength) {
        if (offsets == null) {
            return;
        }
        int shift = newLength - oldLength;
        if (shift == 0) {
            return;
        }
        for (int i = 0; i < offsets.length; ++i) {
            int offset = offsets[i];
            if (offset < changeOffset + oldLength) continue;
            int n = i;
            offsets[n] = offsets[n] + shift;
        }
    }

    public static int getLineBreakCount(@NotNull CharSequence text) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.getLineBreakCount must not be null");
        }
        int count = 0;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == '\n') {
                ++count;
                continue;
            }
            if (c != '\r') continue;
            if (i + 1 < text.length() && text.charAt(i + 1) == '\n') {
                ++i;
                ++count;
                continue;
            }
            ++count;
        }
        return count;
    }

    public static boolean containsLineBreak(@NotNull CharSequence text) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.containsLineBreak must not be null");
        }
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (!StringUtil.isLineBreak(c)) continue;
            return true;
        }
        return false;
    }

    public static boolean isLineBreak(char c) {
        return c == '\n' || c == '\r';
    }

    public static boolean endsWithLineBreak(@NotNull CharSequence text) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.endsWithLineBreak must not be null");
        }
        int len = text.length();
        return len > 0 && StringUtil.isLineBreak(text.charAt(len - 1));
    }

    public static int lineColToOffset(@NotNull CharSequence text, int line, int col) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.lineColToOffset must not be null");
        }
        int curLine = 0;
        int offset = 0;
        while (line != curLine) {
            if (offset == text.length()) {
                return -1;
            }
            char c = text.charAt(offset);
            if (c == '\n') {
                ++curLine;
            } else if (c == '\r') {
                ++curLine;
                if (offset < text.length() - 1 && text.charAt(offset + 1) == '\n') {
                    ++offset;
                }
            }
            ++offset;
        }
        return offset + col;
    }

    public static int offsetToLineNumber(@NotNull CharSequence text, int offset) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.offsetToLineNumber must not be null");
        }
        int curLine = 0;
        for (int curOffset = 0; curOffset < offset; ++curOffset) {
            if (curOffset == text.length()) {
                return -1;
            }
            char c = text.charAt(curOffset);
            if (c == '\n') {
                ++curLine;
                continue;
            }
            if (c != '\r') continue;
            ++curLine;
            if (curOffset >= text.length() - 1 || text.charAt(curOffset + 1) != '\n') continue;
            ++curOffset;
        }
        return curLine;
    }

    public static int difference(@NotNull String s1, @NotNull String s2) {
        int i;
        if (s1 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.difference must not be null");
        }
        if (s2 == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.difference must not be null");
        }
        int[][] a = new int[s1.length()][s2.length()];
        for (i = 0; i < s1.length(); ++i) {
            a[i][0] = i;
        }
        for (int j = 0; j < s2.length(); ++j) {
            a[0][j] = j;
        }
        for (i = 1; i < s1.length(); ++i) {
            for (int j = 1; j < s2.length(); ++j) {
                a[i][j] = Math.min(Math.min(a[i - 1][j - 1] + (s1.charAt(i) == s2.charAt(j) ? 0 : 1), a[i - 1][j] + 1), a[i][j - 1] + 1);
            }
        }
        return a[s1.length() - 1][s2.length() - 1];
    }

    @NotNull
    public static String wordsToBeginFromUpperCase(@NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.wordsToBeginFromUpperCase must not be null");
        }
        String string = StringUtil.toTitleCase(s, ourPrepositions);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.wordsToBeginFromUpperCase must not return null");
        }
        return string;
    }

    @NotNull
    public static String toTitleCase(@NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.toTitleCase must not be null");
        }
        String string = StringUtil.toTitleCase(s, ArrayUtil.EMPTY_STRING_ARRAY);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.toTitleCase must not return null");
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private static String toTitleCase(@NotNull String s, @NotNull String[] prepositions) {
        if (s == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.toTitleCase must not be null");
        }
        if (prepositions == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.toTitleCase must not be null");
        }
        StringBuilder buffer = null;
        int i = 0;
        while (true) {
            block12: {
                int j;
                char currChar;
                block13: {
                    String string;
                    block11: {
                        if (i >= s.length()) break block11;
                        char prevChar = i == 0 ? (char)' ' : (char)s.charAt(i - 1);
                        currChar = s.charAt(i);
                        if (Character.isLetterOrDigit(prevChar) || prevChar == 39 || !Character.isLetterOrDigit(currChar) || Character.isUpperCase(currChar)) break block12;
                        break block13;
                    }
                    if (buffer == null) {
                        string = s;
                        if (string == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.toTitleCase must not return null");
                        return string;
                    }
                    string = buffer.toString();
                    if (string != null) return string;
                    throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.toTitleCase must not return null");
                }
                for (j = i; j < s.length() && Character.isLetterOrDigit(s.charAt(j)); ++j) {
                }
                if (!StringUtil.isPreposition(s, i, j - 1, prepositions)) {
                    if (buffer == null) {
                        buffer = new StringBuilder(s);
                    }
                    buffer.setCharAt(i, StringUtil.toUpperCase(currChar));
                }
            }
            ++i;
        }
    }

    public static boolean isPreposition(@NotNull String s, int firstChar, int lastChar) {
        if (s == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.isPreposition must not be null");
        }
        return StringUtil.isPreposition(s, firstChar, lastChar, ourPrepositions);
    }

    public static boolean isPreposition(@NotNull String s, int firstChar, int lastChar, @NotNull String[] prepositions) {
        if (s == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.isPreposition must not be null");
        }
        if (prepositions == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.isPreposition must not be null");
        }
        for (String preposition : prepositions) {
            boolean found = false;
            if (lastChar - firstChar + 1 == preposition.length()) {
                found = true;
                for (int j = 0; j < preposition.length(); ++j) {
                    if (StringUtil.toLowerCase(s.charAt(firstChar + j)) == preposition.charAt(j)) continue;
                    found = false;
                }
            }
            if (!found) continue;
            return true;
        }
        return false;
    }

    public static NotNullFunction<String, String> escaper(final boolean escapeSlash, final @Nullable String additionalChars) {
        return new NotNullFunction<String, String>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NotNull
            public String fun(String dom) {
                StringBuilder builder = StringBuilderSpinAllocator.alloc();
                StringUtil.escapeStringCharacters(dom.length(), dom, additionalChars, escapeSlash, builder);
                String string = builder.toString();
                String string2 = string;
                if (string2 == null) {
                    throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil$6.fun must not return null");
                }
                return string2;
                finally {
                    StringBuilderSpinAllocator.dispose(builder);
                }
            }
        };
    }

    public static void escapeStringCharacters(int length, @NotNull String str, @NotNull @NonNls StringBuilder buffer) {
        if (str == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.escapeStringCharacters must not be null");
        }
        if (buffer == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.escapeStringCharacters must not be null");
        }
        StringUtil.escapeStringCharacters(length, str, "\"", buffer);
    }

    @NotNull
    public static StringBuilder escapeStringCharacters(int length, @NotNull String str, @Nullable String additionalChars, @NotNull @NonNls StringBuilder buffer) {
        if (str == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.escapeStringCharacters must not be null");
        }
        if (buffer == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.escapeStringCharacters must not be null");
        }
        StringBuilder stringBuilder = StringUtil.escapeStringCharacters(length, str, additionalChars, true, buffer);
        if (stringBuilder == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.escapeStringCharacters must not return null");
        }
        return stringBuilder;
    }

    @NotNull
    public static StringBuilder escapeStringCharacters(int length, @NotNull String str, @Nullable String additionalChars, boolean escapeSlash, @NotNull @NonNls StringBuilder buffer) {
        if (str == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.escapeStringCharacters must not be null");
        }
        if (buffer == null) {
            throw new IllegalArgumentException("Argument 4 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.escapeStringCharacters must not be null");
        }
        char prev = '\u0000';
        for (int idx = 0; idx < length; ++idx) {
            char ch = str.charAt(idx);
            switch (ch) {
                case '\b': {
                    buffer.append("\\b");
                    break;
                }
                case '\t': {
                    buffer.append("\\t");
                    break;
                }
                case '\n': {
                    buffer.append("\\n");
                    break;
                }
                case '\f': {
                    buffer.append("\\f");
                    break;
                }
                case '\r': {
                    buffer.append("\\r");
                    break;
                }
                default: {
                    if (escapeSlash && ch == '\\') {
                        buffer.append("\\\\");
                        break;
                    }
                    if (additionalChars != null && additionalChars.indexOf(ch) > -1 && (escapeSlash || prev != '\\')) {
                        buffer.append("\\").append(ch);
                        break;
                    }
                    if (Character.isISOControl(ch)) {
                        String hexCode = Integer.toHexString(ch).toUpperCase();
                        buffer.append("\\u");
                        int paddingCount = 4 - hexCode.length();
                        while (paddingCount-- > 0) {
                            buffer.append(0);
                        }
                        buffer.append(hexCode);
                        break;
                    }
                    buffer.append(ch);
                }
            }
            prev = ch;
        }
        StringBuilder stringBuilder = buffer;
        if (stringBuilder == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.escapeStringCharacters must not return null");
        }
        return stringBuilder;
    }

    @NotNull
    public static String escapeStringCharacters(@NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.escapeStringCharacters must not be null");
        }
        StringBuilder buffer = new StringBuilder();
        StringUtil.escapeStringCharacters(s.length(), s, buffer);
        String string = buffer.toString();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.escapeStringCharacters must not return null");
        }
        return string;
    }

    @NotNull
    public static String unescapeStringCharacters(@NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.unescapeStringCharacters must not be null");
        }
        StringBuilder buffer = new StringBuilder();
        StringUtil.unescapeStringCharacters(s.length(), s, buffer);
        String string = buffer.toString();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.unescapeStringCharacters must not return null");
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static String unquoteString(@NotNull String s) {
        String string;
        char c;
        if (s == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.unquoteString must not be null");
        }
        if (s.length() <= 1 || (c = s.charAt(0)) != '\"' && c != '\'' || s.charAt(s.length() - 1) != c) {
            string = s;
            if (string == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.unquoteString must not return null");
            return string;
        }
        string = s.substring(1, s.length() - 1);
        if (string != null) return string;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.unquoteString must not return null");
    }

    public static String quoteReplacement(String s) {
        boolean needReplacements = false;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c != '\\' && c != '$') continue;
            needReplacements = true;
            break;
        }
        if (!needReplacements) {
            return s;
        }
        StringBuilder sb = new StringBuilder(s.length() * 6 / 5);
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\\') {
                sb.append('\\');
                sb.append('\\');
                continue;
            }
            if (c == '$') {
                sb.append('\\');
                sb.append('$');
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private static void unescapeStringCharacters(int length, @NotNull String s, @NotNull StringBuilder buffer) {
        if (s == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.unescapeStringCharacters must not be null");
        }
        if (buffer == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.unescapeStringCharacters must not be null");
        }
        boolean escaped = false;
        for (int idx = 0; idx < length; ++idx) {
            char ch = s.charAt(idx);
            if (!escaped) {
                if (ch == '\\') {
                    escaped = true;
                    continue;
                }
                buffer.append(ch);
                continue;
            }
            switch (ch) {
                case 'n': {
                    buffer.append('\n');
                    break;
                }
                case 'r': {
                    buffer.append('\r');
                    break;
                }
                case 'b': {
                    buffer.append('\b');
                    break;
                }
                case 't': {
                    buffer.append('\t');
                    break;
                }
                case 'f': {
                    buffer.append('\f');
                    break;
                }
                case '\'': {
                    buffer.append('\'');
                    break;
                }
                case '\"': {
                    buffer.append('\"');
                    break;
                }
                case '\\': {
                    buffer.append('\\');
                    break;
                }
                case 'u': {
                    if (idx + 4 < length) {
                        try {
                            int code = Integer.valueOf(s.substring(idx + 1, idx + 5), 16);
                            idx += 4;
                            buffer.append((char)code);
                        }
                        catch (NumberFormatException e) {
                            buffer.append("\\u");
                        }
                        break;
                    }
                    buffer.append("\\u");
                    break;
                }
                default: {
                    buffer.append(ch);
                }
            }
            escaped = false;
        }
        if (escaped) {
            buffer.append('\\');
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public static String pluralize(@NotNull String suggestion) {
        String string;
        if (suggestion == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.pluralize must not be null");
        }
        if (suggestion.endsWith("Child") || suggestion.endsWith("child")) {
            String string2 = suggestion + "ren";
            string = string2;
            if (string2 != null) return string;
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.pluralize must not return null");
        }
        if (suggestion.equals("this")) {
            return "these";
        }
        if (suggestion.equals("This")) {
            return "These";
        }
        if (StringUtil.endsWithIgnoreCase(suggestion, "s") || StringUtil.endsWithIgnoreCase(suggestion, "x") || StringUtil.endsWithIgnoreCase(suggestion, "ch")) {
            String string3 = suggestion + "es";
            string = string3;
            if (string3 == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.pluralize must not return null");
            return string;
        }
        int len = suggestion.length();
        if (StringUtil.endsWithIgnoreCase(suggestion, "y") && len > 1 && !StringUtil.isVowel(StringUtil.toLowerCase(suggestion.charAt(len - 2)))) {
            String string4 = suggestion.substring(0, len - 1) + "ies";
            string = string4;
            if (string4 == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.pluralize must not return null");
            return string;
        }
        String string5 = suggestion + "s";
        string = string5;
        if (string5 == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.pluralize must not return null");
        return string;
    }

    @NotNull
    public static String capitalizeWords(@NotNull String text, boolean allWords) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.capitalizeWords must not be null");
        }
        String string = StringUtil.capitalizeWords(text, " \t\n\r\f", allWords, false);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.capitalizeWords must not return null");
        }
        return string;
    }

    @NotNull
    public static String capitalizeWords(@NotNull String text, @NotNull String tokenizerDelim, boolean allWords, boolean leaveOriginalDelims) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.capitalizeWords must not be null");
        }
        if (tokenizerDelim == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.capitalizeWords must not be null");
        }
        StringTokenizer tokenizer = new StringTokenizer(text, tokenizerDelim, leaveOriginalDelims);
        StringBuilder out = new StringBuilder();
        boolean toCapitalize = true;
        while (tokenizer.hasMoreTokens()) {
            String word = tokenizer.nextToken();
            if (!leaveOriginalDelims && out.length() > 0) {
                out.append(' ');
            }
            out.append(toCapitalize ? StringUtil.capitalize(word) : word);
            if (allWords) continue;
            toCapitalize = false;
        }
        String string = out.toString();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.capitalizeWords must not return null");
        }
        return string;
    }

    public static String decapitalize(String s) {
        return Introspector.decapitalize(s);
    }

    public static boolean isVowel(char c) {
        return "aeiouy".indexOf(c) >= 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static String capitalize(@NotNull String s) {
        String string;
        if (s == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.capitalize must not be null");
        }
        if (s.length() == 0) {
            string = s;
            if (string == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.capitalize must not return null");
            return string;
        }
        if (s.length() == 1) {
            string = s.toUpperCase();
            if (string == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.capitalize must not return null");
            return string;
        }
        if (Character.isUpperCase(s.charAt(0))) {
            string = s;
            if (string == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.capitalize must not return null");
            return string;
        }
        string = StringUtil.toUpperCase(s.charAt(0)) + s.substring(1);
        if (string != null) return string;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.capitalize must not return null");
    }

    public static boolean isCapitalized(@Nullable String s) {
        return s != null && s.length() > 0 && Character.isUpperCase(s.charAt(0));
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static String capitalizeWithJavaBeanConvention(@NotNull String s) {
        String string;
        if (s == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.capitalizeWithJavaBeanConvention must not be null");
        }
        if (s.length() > 1 && Character.isUpperCase(s.charAt(1))) {
            string = s;
            if (string == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.capitalizeWithJavaBeanConvention must not return null");
            return string;
        }
        string = StringUtil.capitalize(s);
        if (string != null) return string;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.capitalizeWithJavaBeanConvention must not return null");
    }

    public static int stringHashCode(CharSequence chars) {
        if (chars instanceof String) {
            return chars.hashCode();
        }
        if (chars instanceof CharSequenceWithStringHash) {
            return chars.hashCode();
        }
        if (chars instanceof CharArrayCharSequence) {
            return chars.hashCode();
        }
        return StringUtil.stringHashCode(chars, 0, chars.length());
    }

    public static int stringHashCode(CharSequence chars, int from, int to) {
        int h = 0;
        for (int off = from; off < to; ++off) {
            h = 31 * h + chars.charAt(off);
        }
        return h;
    }

    public static int stringHashCode(char[] chars, int from, int to) {
        int h = 0;
        for (int off = from; off < to; ++off) {
            h = 31 * h + chars[off];
        }
        return h;
    }

    public static int stringHashCodeInsensitive(char[] chars, int from, int to) {
        int h = 0;
        for (int off = from; off < to; ++off) {
            h = 31 * h + StringUtil.toLowerCase(chars[off]);
        }
        return h;
    }

    public static int stringHashCodeInsensitive(CharSequence chars, int from, int to) {
        int h = 0;
        for (int off = from; off < to; ++off) {
            h = 31 * h + StringUtil.toLowerCase(chars.charAt(off));
        }
        return h;
    }

    public static int stringHashCodeInsensitive(@NotNull CharSequence chars) {
        if (chars == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.stringHashCodeInsensitive must not be null");
        }
        return StringUtil.stringHashCodeInsensitive(chars, 0, chars.length());
    }

    public static boolean startsWithConcatenationOf(String testee, String firstPrefix, String secondPrefix) {
        int l1 = firstPrefix.length();
        int l2 = secondPrefix.length();
        if (testee.length() < l1 + l2) {
            return false;
        }
        return testee.startsWith(firstPrefix) && testee.regionMatches(l1, secondPrefix, 0, l2);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static String trimEnd(@NotNull String s, @NonNls @NotNull String suffix) {
        String string;
        if (s == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.trimEnd must not be null");
        }
        if (suffix == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.trimEnd must not be null");
        }
        if (s.endsWith(suffix)) {
            string = s.substring(0, s.length() - suffix.length());
            if (string == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.trimEnd must not return null");
            return string;
        }
        string = s;
        if (string != null) return string;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.trimEnd must not return null");
    }

    public static String trimLog(String text, int limit) {
        if (limit > 5 && text.length() > limit) {
            return text.substring(0, limit - 5) + " ...\n";
        }
        return text;
    }

    @NotNull
    public static String trimLeading(@NotNull String string) {
        int index;
        if (string == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.trimLeading must not be null");
        }
        for (index = 0; index < string.length() && Character.isWhitespace(string.charAt(index)); ++index) {
        }
        String string2 = string.substring(index);
        if (string2 == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.trimLeading must not return null");
        }
        return string2;
    }

    @NotNull
    public static String trimTrailing(@NotNull String string) {
        int index;
        if (string == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.trimTrailing must not be null");
        }
        for (index = string.length() - 1; index >= 0 && Character.isWhitespace(string.charAt(index)); --index) {
        }
        String string2 = string.substring(0, index + 1);
        if (string2 == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.trimTrailing must not return null");
        }
        return string2;
    }

    public static boolean startsWithChar(@Nullable CharSequence s, char prefix) {
        return s != null && s.length() != 0 && s.charAt(0) == prefix;
    }

    public static boolean endsWithChar(@Nullable CharSequence s, char suffix) {
        return s != null && s.length() != 0 && s.charAt(s.length() - 1) == suffix;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static String trimStart(@NotNull String s, @NonNls @NotNull String prefix) {
        String string;
        if (s == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.trimStart must not be null");
        }
        if (prefix == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.trimStart must not be null");
        }
        if (s.startsWith(prefix)) {
            string = s.substring(prefix.length());
            if (string == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.trimStart must not return null");
            return string;
        }
        string = s;
        if (string != null) return string;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.trimStart must not return null");
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static String pluralize(@NotNull String base, int n) {
        String string;
        if (base == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.pluralize must not be null");
        }
        if (n == 1) {
            string = base;
            if (string == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.pluralize must not return null");
            return string;
        }
        string = StringUtil.pluralize(base);
        if (string != null) return string;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.pluralize must not return null");
    }

    public static void repeatSymbol(@NotNull Appendable buffer, char symbol, int times) {
        if (buffer == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.repeatSymbol must not be null");
        }
        assert (times >= 0) : times;
        try {
            for (int i = 0; i < times; ++i) {
                buffer.append(symbol);
            }
        }
        catch (IOException e) {
            LOG.error(e);
        }
    }

    public static boolean isNotEmpty(@Nullable String s) {
        return s != null && s.length() > 0;
    }

    public static boolean isEmpty(@Nullable String s) {
        return s == null || s.length() == 0;
    }

    public static boolean isEmpty(@Nullable CharSequence cs) {
        return cs == null || cs.length() == 0;
    }

    public static int length(@Nullable CharSequence cs) {
        return cs == null ? 0 : cs.length();
    }

    @NotNull
    public static String notNullize(String s) {
        String string = StringUtil.notNullize(s, "");
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.notNullize must not return null");
        }
        return string;
    }

    @NotNull
    public static String notNullize(String s, @NotNull String defaultValue) {
        if (defaultValue == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.notNullize must not be null");
        }
        String string = s == null ? defaultValue : s;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.notNullize must not return null");
        }
        return string;
    }

    @Nullable
    public static String nullize(@Nullable String s) {
        return StringUtil.nullize(s, false);
    }

    @Nullable
    public static String nullize(@Nullable String s, boolean nullizeSpaces) {
        if (nullizeSpaces ? StringUtil.isEmpty(s) : StringUtil.isEmptyOrSpaces(s)) {
            return null;
        }
        return s;
    }

    public static boolean isEmptyOrSpaces(@Nullable String s) {
        return s == null || s.trim().length() == 0;
    }

    public static boolean isWhiteSpace(char c) {
        return c == '\n' || c == '\t' || c == ' ';
    }

    @NotNull
    public static String getThrowableText(@NotNull Throwable aThrowable) {
        if (aThrowable == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.getThrowableText must not be null");
        }
        String string = ExceptionUtil.getThrowableText(aThrowable);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.getThrowableText must not return null");
        }
        return string;
    }

    @NotNull
    public static String getThrowableText(@NotNull Throwable aThrowable, @NonNls @NotNull String stackFrameSkipPattern) {
        if (aThrowable == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.getThrowableText must not be null");
        }
        if (stackFrameSkipPattern == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.getThrowableText must not be null");
        }
        String string = ExceptionUtil.getThrowableText(aThrowable, stackFrameSkipPattern);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.getThrowableText must not return null");
        }
        return string;
    }

    @Nullable
    public static String getMessage(@NotNull Throwable e) {
        if (e == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.getMessage must not be null");
        }
        return ExceptionUtil.getMessage(e);
    }

    @NotNull
    public static String repeatSymbol(char aChar, int count) {
        char[] buffer = new char[count];
        Arrays.fill(buffer, aChar);
        String string = new String(buffer);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.repeatSymbol must not return null");
        }
        return string;
    }

    @NotNull
    public static String repeat(String s, int count) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            sb.append(s);
        }
        String string = sb.toString();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.repeat must not return null");
        }
        return string;
    }

    @NotNull
    public static List<String> splitHonorQuotes(@NotNull String s, char separator) {
        if (s == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.splitHonorQuotes must not be null");
        }
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder builder = new StringBuilder();
        boolean inQuotes = false;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == separator && !inQuotes) {
                if (builder.length() <= 0) continue;
                result.add(builder.toString());
                builder.setLength(0);
                continue;
            }
            if (!(c != '\"' && c != '\'' || i > 0 && s.charAt(i - 1) == '\\')) {
                inQuotes = !inQuotes;
            }
            builder.append(c);
        }
        if (builder.length() > 0) {
            result.add(builder.toString());
        }
        ArrayList<String> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.splitHonorQuotes must not return null");
        }
        return arrayList;
    }

    @NotNull
    public static List<String> split(@NotNull String s, @NotNull String separator) {
        if (s == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.split must not be null");
        }
        if (separator == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.split must not be null");
        }
        List<String> list = StringUtil.split(s, separator, true);
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.split must not return null");
        }
        return list;
    }

    @NotNull
    public static List<String> split(@NotNull String s, @NotNull String separator, boolean excludeSeparator) {
        if (s == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.split must not be null");
        }
        if (separator == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.split must not be null");
        }
        List<String> list = StringUtil.split(s, separator, excludeSeparator, true);
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.split must not return null");
        }
        return list;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static List<String> split(@NotNull String s, @NotNull String separator, boolean excludeSeparator, boolean excludeEmptyStrings) {
        ArrayList<String> result;
        List<String> list;
        block17: {
            int pos;
            block16: {
                if (s == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.split must not be null");
                }
                if (separator == null) {
                    throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.split must not be null");
                }
                if (separator.length() == 0) {
                    list = Collections.singletonList(s);
                    if (list == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.split must not return null");
                    return list;
                }
                result = new ArrayList<String>();
                pos = 0;
                while (true) {
                    int index;
                    if ((index = s.indexOf(separator, pos)) == -1) {
                        if (pos >= s.length()) {
                            break;
                        }
                        break block16;
                    }
                    int nextPos = index + separator.length();
                    String token = s.substring(pos, excludeSeparator ? index : nextPos);
                    if (token.length() != 0 || !excludeEmptyStrings) {
                        result.add(token);
                    }
                    pos = nextPos;
                }
                if (excludeEmptyStrings || pos != s.length()) break block17;
            }
            result.add(s.substring(pos, s.length()));
        }
        if ((list = result) != null) return list;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.split must not return null");
    }

    @NotNull
    public static Iterable<String> tokenize(@NotNull String s, @NotNull String separators) {
        if (s == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.tokenize must not be null");
        }
        if (separators == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.tokenize must not be null");
        }
        final org.jetbrains.jet.internal.com.intellij.util.text.StringTokenizer tokenizer = new org.jetbrains.jet.internal.com.intellij.util.text.StringTokenizer(s, separators);
        Iterable<String> iterable = new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return new Iterator<String>(){

                    @Override
                    public boolean hasNext() {
                        return tokenizer.hasMoreTokens();
                    }

                    @Override
                    public String next() {
                        return tokenizer.nextToken();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
        if (iterable == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.tokenize must not return null");
        }
        return iterable;
    }

    @NotNull
    public static Iterable<String> tokenize(final StringTokenizer tokenizer) {
        Iterable<String> iterable = new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return new Iterator<String>(){

                    @Override
                    public boolean hasNext() {
                        return tokenizer.hasMoreTokens();
                    }

                    @Override
                    public String next() {
                        return tokenizer.nextToken();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
        if (iterable == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.tokenize must not return null");
        }
        return iterable;
    }

    @NotNull
    public static List<String> getWordsIn(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.getWordsIn must not be null");
        }
        SmartList<String> result = new SmartList<String>();
        int start = -1;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            boolean isIdentifierPart = Character.isJavaIdentifierPart(c);
            if (isIdentifierPart && start == -1) {
                start = i;
            }
            if (isIdentifierPart && i == text.length() - 1 && start != -1) {
                result.add(text.substring(start, i + 1));
                continue;
            }
            if (isIdentifierPart || start == -1) continue;
            result.add(text.substring(start, i));
            start = -1;
        }
        SmartList<String> smartList = result;
        if (smartList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.getWordsIn must not return null");
        }
        return smartList;
    }

    @NotNull
    public static List<TextRange> getWordIndicesIn(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.getWordIndicesIn must not be null");
        }
        SmartList<TextRange> result = new SmartList<TextRange>();
        int start = -1;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            boolean isIdentifierPart = Character.isJavaIdentifierPart(c);
            if (isIdentifierPart && start == -1) {
                start = i;
            }
            if (isIdentifierPart && i == text.length() - 1 && start != -1) {
                result.add(new TextRange(start, i + 1));
                continue;
            }
            if (isIdentifierPart || start == -1) continue;
            result.add(new TextRange(start, i));
            start = -1;
        }
        SmartList<TextRange> smartList = result;
        if (smartList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.getWordIndicesIn must not return null");
        }
        return smartList;
    }

    @NotNull
    public static String join(@NotNull String[] strings, @NotNull String separator) {
        if (strings == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.join must not be null");
        }
        if (separator == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.join must not be null");
        }
        String string = StringUtil.join(strings, 0, strings.length, separator);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.join must not return null");
        }
        return string;
    }

    @NotNull
    public static String join(@NotNull String[] strings, int startIndex, int endIndex, @NotNull String separator) {
        if (strings == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.join must not be null");
        }
        if (separator == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.join must not be null");
        }
        StringBuilder result = new StringBuilder();
        for (int i = startIndex; i < endIndex; ++i) {
            if (i > startIndex) {
                result.append(separator);
            }
            result.append(strings[i]);
        }
        String string = result.toString();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.join must not return null");
        }
        return string;
    }

    @NotNull
    public static String[] zip(@NotNull String[] strings1, @NotNull String[] strings2, String separator) {
        if (strings1 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.zip must not be null");
        }
        if (strings2 == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.zip must not be null");
        }
        if (strings1.length != strings2.length) {
            throw new IllegalArgumentException();
        }
        String[] result = ArrayUtil.newStringArray(strings1.length);
        for (int i = 0; i < result.length; ++i) {
            result[i] = strings1[i] + separator + strings2[i];
        }
        if (result == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.zip must not return null");
        }
        return result;
    }

    @NotNull
    public static String[] surround(@NotNull String[] strings1, String prefix, String suffix) {
        if (strings1 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.surround must not be null");
        }
        String[] result = ArrayUtil.newStringArray(strings1.length);
        for (int i = 0; i < result.length; ++i) {
            result[i] = prefix + strings1[i] + suffix;
        }
        if (result == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.surround must not return null");
        }
        return result;
    }

    @NotNull
    public static <T> String join(@NotNull T[] items, @NotNull Function<T, String> f, @NotNull @NonNls String separator) {
        if (items == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.join must not be null");
        }
        if (f == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.join must not be null");
        }
        if (separator == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.join must not be null");
        }
        String string = StringUtil.join(Arrays.asList(items), f, separator);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.join must not return null");
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public static <T> String join(@NotNull Collection<T> items, @NotNull Function<T, String> f, @NotNull @NonNls String separator) {
        if (items == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.join must not be null");
        }
        if (f == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.join must not be null");
        }
        if (separator == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.join must not be null");
        }
        if (items.isEmpty()) {
            return "";
        }
        String string = StringUtil.join(items, f, separator);
        String string2 = string;
        if (string == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.join must not return null");
        return string2;
    }

    @NotNull
    public static <T> String join(@NotNull Iterable<T> items, @NotNull Function<T, String> f, @NotNull @NonNls String separator) {
        if (items == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.join must not be null");
        }
        if (f == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.join must not be null");
        }
        if (separator == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.join must not be null");
        }
        StringBuilder result = new StringBuilder();
        for (T item : items) {
            String string = f.fun(item);
            if (string == null || string.length() == 0) continue;
            if (result.length() != 0) {
                result.append(separator);
            }
            result.append(string);
        }
        String string = result.toString();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.join must not return null");
        }
        return string;
    }

    @NotNull
    public static String join(@NotNull Collection<? extends String> strings, @NotNull String separator) {
        if (strings == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.join must not be null");
        }
        if (separator == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.join must not be null");
        }
        StringBuilder result = new StringBuilder();
        for (String string : strings) {
            if (string == null || string.length() == 0) continue;
            if (result.length() != 0) {
                result.append(separator);
            }
            result.append(string);
        }
        String string = result.toString();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.join must not return null");
        }
        return string;
    }

    @NotNull
    public static String join(@NotNull int[] strings, @NotNull String separator) {
        if (strings == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.join must not be null");
        }
        if (separator == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.join must not be null");
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < strings.length; ++i) {
            if (i > 0) {
                result.append(separator);
            }
            result.append(strings[i]);
        }
        String string = result.toString();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.join must not return null");
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public static String join(String ... strings) {
        if (strings == null) return "";
        if (strings.length == 0) {
            return "";
        }
        StringBuilder builder = StringBuilderSpinAllocator.alloc();
        for (String string : strings) {
            builder.append(string);
        }
        String string = builder.toString();
        String string2 = string;
        String string3 = string2;
        if (string2 == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.join must not return null");
        return string3;
        finally {
            StringBuilderSpinAllocator.dispose(builder);
        }
    }

    @NotNull
    public static String stripQuotesAroundValue(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.stripQuotesAroundValue must not be null");
        }
        if (StringUtil.startsWithChar(text, '\"') || StringUtil.startsWithChar(text, '\'')) {
            text = text.substring(1);
        }
        if (StringUtil.endsWithChar(text, '\"') || StringUtil.endsWithChar(text, '\'')) {
            text = text.substring(0, text.length() - 1);
        }
        String string = text;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.stripQuotesAroundValue must not return null");
        }
        return string;
    }

    public static boolean isQuotedString(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.isQuotedString must not be null");
        }
        return StringUtil.startsWithChar(text, '\"') && StringUtil.endsWithChar(text, '\"') || StringUtil.startsWithChar(text, '\'') && StringUtil.endsWithChar(text, '\'');
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static String formatFileSize(long fileSize) {
        String string;
        if (fileSize < 1024L) {
            string = CommonBundle.message("format.file.size.bytes", fileSize);
            if (string == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.formatFileSize must not return null");
            return string;
        }
        if (fileSize < 0x100000L) {
            long kbytes = fileSize * 100L / 1024L;
            String kbs = kbytes / 100L + "." + StringUtil.formatMinor(kbytes % 100L);
            string = CommonBundle.message("format.file.size.kbytes", kbs);
            if (string == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.formatFileSize must not return null");
            return string;
        }
        long mbytes = fileSize * 100L / 1024L / 1024L;
        String size = mbytes / 100L + "." + StringUtil.formatMinor(mbytes % 100L);
        string = CommonBundle.message("format.file.size.mbytes", size);
        if (string != null) return string;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.formatFileSize must not return null");
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private static String formatMinor(long number) {
        String string;
        if (number > 0L && number <= 9L) {
            string = "0" + number;
            if (string == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.formatMinor must not return null");
            return string;
        }
        string = String.valueOf(number);
        if (string != null) return string;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.formatMinor must not return null");
    }

    @Nullable
    public static String unpluralize(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.unpluralize must not be null");
        }
        if (name.endsWith("sses") || name.endsWith("shes") || name.endsWith("ches") || name.endsWith("xes")) {
            return name.substring(0, name.length() - 2);
        }
        if (name.endsWith("ses")) {
            return name.substring(0, name.length() - 1);
        }
        if (name.endsWith("ies")) {
            if (name.endsWith("cookies") || name.endsWith("Cookies")) {
                return name.substring(0, name.length() - "ookies".length()) + "ookie";
            }
            return name.substring(0, name.length() - 3) + "y";
        }
        if (name.endsWith("leaves") || name.endsWith("Leaves")) {
            return name.substring(0, name.length() - "eaves".length()) + "eaf";
        }
        String result = StringUtil.stripEnding(name, "s");
        if (result != null) {
            return result;
        }
        if (name.endsWith("children")) {
            return name.substring(0, name.length() - "children".length()) + "child";
        }
        if (name.endsWith("Children") && name.length() > "Children".length()) {
            return name.substring(0, name.length() - "Children".length()) + "Child";
        }
        return null;
    }

    @Nullable
    private static String stripEnding(@NotNull String name, @NotNull String ending) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.stripEnding must not be null");
        }
        if (ending == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.stripEnding must not be null");
        }
        if (name.endsWith(ending)) {
            if (name.equals(ending)) {
                return name;
            }
            return name.substring(0, name.length() - 1);
        }
        return null;
    }

    public static boolean containsAlphaCharacters(@NotNull String value) {
        if (value == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.containsAlphaCharacters must not be null");
        }
        for (int i = 0; i < value.length(); ++i) {
            if (!Character.isLetter(value.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean containsAnyChar(@NotNull String value, @NotNull String chars) {
        if (value == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.containsAnyChar must not be null");
        }
        if (chars == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.containsAnyChar must not be null");
        }
        for (int i = 0; i < chars.length(); ++i) {
            if (!StringUtil.containsChar(value, chars.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean containsChar(String value, char ch) {
        return value.indexOf(ch) >= 0;
    }

    @Nullable
    public static String firstLetterToUpperCase(@Nullable String displayString) {
        if (displayString == null || displayString.length() == 0) {
            return displayString;
        }
        char firstChar = displayString.charAt(0);
        char uppedFirstChar = StringUtil.toUpperCase(firstChar);
        if (uppedFirstChar == firstChar) {
            return displayString;
        }
        char[] buffer = displayString.toCharArray();
        buffer[0] = uppedFirstChar;
        return new String(buffer);
    }

    @NotNull
    public static String strip(@NotNull String s, @NotNull CharFilter filter) {
        if (s == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.strip must not be null");
        }
        if (filter == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.strip must not be null");
        }
        StringBuilder result = new StringBuilder(s.length());
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (!filter.accept(ch)) continue;
            result.append(ch);
        }
        String string = result.toString();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.strip must not return null");
        }
        return string;
    }

    public static List<String> findMatches(String s, Pattern pattern) {
        return StringUtil.findMatches(s, pattern, 1);
    }

    public static List<String> findMatches(String s, Pattern pattern, int groupIndex) {
        SmartList<String> result = new SmartList<String>();
        Matcher m = pattern.matcher(s);
        while (m.find()) {
            String group = m.group(groupIndex);
            if (group == null) continue;
            result.add(group);
        }
        return result;
    }

    public static int findFirst(@NotNull String s, @NotNull CharFilter filter) {
        if (s == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.findFirst must not be null");
        }
        if (filter == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.findFirst must not be null");
        }
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (!filter.accept(ch)) continue;
            return i;
        }
        return -1;
    }

    @NotNull
    public static String replaceSubstring(@NotNull String string, @NotNull TextRange range, @NotNull String replacement) {
        if (string == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.replaceSubstring must not be null");
        }
        if (range == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.replaceSubstring must not be null");
        }
        if (replacement == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.replaceSubstring must not be null");
        }
        String string2 = range.replace(string, replacement);
        if (string2 == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.replaceSubstring must not return null");
        }
        return string2;
    }

    public static boolean startsWithWhitespace(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.startsWithWhitespace must not be null");
        }
        return !text.isEmpty() && Character.isWhitespace(text.charAt(0));
    }

    public static boolean startsWith(@NotNull CharSequence text, @NotNull CharSequence prefix) {
        int l2;
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.startsWith must not be null");
        }
        if (prefix == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.startsWith must not be null");
        }
        int l1 = text.length();
        if (l1 < (l2 = prefix.length())) {
            return false;
        }
        for (int i = 0; i < l2; ++i) {
            if (text.charAt(i) == prefix.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public static boolean startsWith(@NotNull CharSequence text, int startIndex, @NotNull CharSequence prefix) {
        int l2;
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.startsWith must not be null");
        }
        if (prefix == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.startsWith must not be null");
        }
        int l1 = text.length() - startIndex;
        if (l1 < (l2 = prefix.length())) {
            return false;
        }
        for (int i = 0; i < l2; ++i) {
            if (text.charAt(i + startIndex) == prefix.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public static boolean endsWith(@NotNull CharSequence text, @NotNull CharSequence suffix) {
        int l2;
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.endsWith must not be null");
        }
        if (suffix == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.endsWith must not be null");
        }
        int l1 = text.length();
        if (l1 < (l2 = suffix.length())) {
            return false;
        }
        for (int i = l1 - 1; i >= l1 - l2; --i) {
            if (text.charAt(i) == suffix.charAt(i + l2 - l1)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public static String commonPrefix(@NotNull String s1, @NotNull String s2) {
        if (s1 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.commonPrefix must not be null");
        }
        if (s2 == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.commonPrefix must not be null");
        }
        String string = s1.substring(0, StringUtil.commonPrefixLength(s1, s2));
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.commonPrefix must not return null");
        }
        return string;
    }

    public static int commonPrefixLength(@NotNull CharSequence s1, @NotNull CharSequence s2) {
        int i;
        if (s1 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.commonPrefixLength must not be null");
        }
        if (s2 == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.commonPrefixLength must not be null");
        }
        int minLength = Math.min(s1.length(), s2.length());
        for (i = 0; i < minLength && s1.charAt(i) == s2.charAt(i); ++i) {
        }
        return i;
    }

    @NotNull
    public static String commonSuffix(@NotNull String s1, @NotNull String s2) {
        if (s1 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.commonSuffix must not be null");
        }
        if (s2 == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.commonSuffix must not be null");
        }
        String string = s1.substring(s1.length() - StringUtil.commonSuffixLength(s1, s2));
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.commonSuffix must not return null");
        }
        return string;
    }

    public static int commonSuffixLength(@NotNull CharSequence s1, @NotNull CharSequence s2) {
        int i;
        if (s1 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.commonSuffixLength must not be null");
        }
        if (s2 == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.commonSuffixLength must not be null");
        }
        int s1Length = s1.length();
        int s2Length = s2.length();
        if (s1Length == 0 || s2Length == 0) {
            return 0;
        }
        for (i = 0; i < s1Length && i < s2Length && s1.charAt(s1Length - i - 1) == s2.charAt(s2Length - i - 1); ++i) {
        }
        return i;
    }

    public static boolean contains(CharSequence s, int start, int end, char c) {
        return StringUtil.indexOf(s, c, start, end) >= 0;
    }

    public static boolean containsWhitespaces(@Nullable CharSequence s) {
        if (s == null) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            if (!Character.isWhitespace(s.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static int indexOf(@NotNull CharSequence s, char c) {
        if (s == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.indexOf must not be null");
        }
        return StringUtil.indexOf(s, c, 0, s.length());
    }

    public static int indexOf(@NotNull CharSequence s, char c, int start) {
        if (s == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.indexOf must not be null");
        }
        return StringUtil.indexOf(s, c, start, s.length());
    }

    public static int indexOf(@NotNull CharSequence s, char c, int start, int end) {
        if (s == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.indexOf must not be null");
        }
        for (int i = start; i < end; ++i) {
            if (s.charAt(i) != c) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(@NotNull CharSequence s, char c, int start, int end, boolean caseSensitive) {
        if (s == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.indexOf must not be null");
        }
        for (int i = start; i < end; ++i) {
            if (!StringUtil.charsMatch(s.charAt(i), c, !caseSensitive)) continue;
            return i;
        }
        return -1;
    }

    public static int indexOfSubstringEnd(@NotNull String text, @NotNull String subString) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.indexOfSubstringEnd must not be null");
        }
        if (subString == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.indexOfSubstringEnd must not be null");
        }
        int i = text.indexOf(subString);
        if (i == -1) {
            return -1;
        }
        return i + subString.length();
    }

    public static int indexOfAny(String s, String chars) {
        return StringUtil.indexOfAny(s, chars, 0, s.length());
    }

    public static int indexOfAny(String s, String chars, int start, int end) {
        for (int i = start; i < end; ++i) {
            if (!StringUtil.containsChar(chars, s.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    @Nullable
    public static String substringAfter(@NotNull String text, @NotNull String subString) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.substringAfter must not be null");
        }
        if (subString == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.substringAfter must not be null");
        }
        int i = text.indexOf(subString);
        if (i == -1) {
            return null;
        }
        return text.substring(i + subString.length());
    }

    public static int lastIndexOf(@NotNull CharSequence s, char c, int start, int end) {
        if (s == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.lastIndexOf must not be null");
        }
        for (int i = end - 1; i >= start; --i) {
            if (s.charAt(i) != c) continue;
            return i;
        }
        return -1;
    }

    @NotNull
    public static String first(@NotNull String text, int maxLength, boolean appendEllipsis) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.first must not be null");
        }
        String string = text.length() > maxLength ? text.substring(0, maxLength) + (appendEllipsis ? "..." : "") : text;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.first must not return null");
        }
        return string;
    }

    @NotNull
    public static CharSequence first(@NotNull CharSequence text, int length, boolean appendEllipsis) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.first must not be null");
        }
        CharSequence charSequence = text.length() > length ? text.subSequence(0, length) + (appendEllipsis ? "..." : "") : text;
        if (charSequence == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.first must not return null");
        }
        return charSequence;
    }

    @NotNull
    public static CharSequence last(@NotNull CharSequence text, int length, boolean prependEllipsis) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.last must not be null");
        }
        CharSequence charSequence = text.length() > length ? (prependEllipsis ? "..." : "") + text.subSequence(text.length() - length, text.length()) : text;
        if (charSequence == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.last must not return null");
        }
        return charSequence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static String escapeQuotes(@NotNull String str) {
        if (str == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.escapeQuotes must not be null");
        }
        StringBuilder buf = StringBuilderSpinAllocator.alloc();
        buf.append(str);
        StringUtil.escapeQuotes(buf);
        String string = buf.toString();
        String string2 = string;
        if (string2 == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.escapeQuotes must not return null");
        }
        return string2;
        finally {
            StringBuilderSpinAllocator.dispose(buf);
        }
    }

    public static void escapeQuotes(@NotNull StringBuilder buf) {
        if (buf == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.escapeQuotes must not be null");
        }
        int idx = 0;
        while ((idx = StringUtil.indexOf(buf, '\"', idx)) >= 0) {
            buf.insert(idx, '\\');
            idx += 2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static String escapeSlashes(@NotNull String str) {
        if (str == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.escapeSlashes must not be null");
        }
        StringBuilder buf = StringBuilderSpinAllocator.alloc();
        buf.append(str);
        StringUtil.escapeSlashes(buf);
        String string = buf.toString();
        String string2 = string;
        if (string2 == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.escapeSlashes must not return null");
        }
        return string2;
        finally {
            StringBuilderSpinAllocator.dispose(buf);
        }
    }

    public static void escapeSlashes(@NotNull StringBuilder buf) {
        if (buf == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.escapeSlashes must not be null");
        }
        int idx = 0;
        while ((idx = StringUtil.indexOf(buf, '/', idx)) >= 0) {
            buf.insert(idx, "\\");
            idx += 2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String unescapeSlashes(@NotNull String str) {
        if (str == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.unescapeSlashes must not be null");
        }
        StringBuilder buf = StringBuilderSpinAllocator.alloc();
        try {
            StringUtil.unescapeSlashes(buf, str);
            String string = buf.toString();
            return string;
        }
        finally {
            StringBuilderSpinAllocator.dispose(buf);
        }
    }

    private static void unescapeSlashes(StringBuilder buf, String str) {
        int length = str.length();
        int last = length - 1;
        for (int i = 0; i < length; ++i) {
            char ch = str.charAt(i);
            if (ch == '\\' && i != last && (ch = str.charAt(++i)) != '/') {
                buf.append('\\');
            }
            buf.append(ch);
        }
    }

    public static void quote(@NotNull StringBuilder builder) {
        if (builder == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.quote must not be null");
        }
        StringUtil.quote(builder, '\"');
    }

    public static void quote(@NotNull StringBuilder builder, char quotingChar) {
        if (builder == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.quote must not be null");
        }
        builder.insert(0, quotingChar);
        builder.append(quotingChar);
    }

    @Nullable
    public static String unescapeXml(@Nullable String text) {
        if (text == null) {
            return null;
        }
        return StringUtil.replace(text, REPLACES_REFS, REPLACES_DISP);
    }

    @Nullable
    public static String escapeXml(@Nullable String text) {
        if (text == null) {
            return null;
        }
        return StringUtil.replace(text, REPLACES_DISP, REPLACES_REFS);
    }

    @NotNull
    public static String escapeToRegexp(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.escapeToRegexp must not be null");
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == ' ' || Character.isLetter(c) || Character.isDigit(c) || c == '_') {
                result.append(c);
                continue;
            }
            if (c == '\n') {
                result.append("\\n");
                continue;
            }
            result.append('\\').append(c);
        }
        String string = result.toString();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.escapeToRegexp must not return null");
        }
        return string;
    }

    @NotNull
    public static String replace(@NotNull String text, @NotNull String[] from, @NotNull String[] to) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.replace must not be null");
        }
        if (from == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.replace must not be null");
        }
        if (to == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.replace must not be null");
        }
        StringBuilder result = new StringBuilder(text.length());
        block0: for (int i = 0; i < text.length(); ++i) {
            for (int j = 0; j < from.length; ++j) {
                String toReplace = from[j];
                String replaceWith = to[j];
                int len = toReplace.length();
                if (!text.regionMatches(i, toReplace, 0, len)) continue;
                result.append(replaceWith);
                i += len - 1;
                continue block0;
            }
            result.append(text.charAt(i));
        }
        String string = result.toString();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.replace must not return null");
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static String[] filterEmptyStrings(@NotNull String[] strings) {
        String[] stringArray;
        if (strings == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.filterEmptyStrings must not be null");
        }
        int emptyCount = 0;
        for (String string : strings) {
            if (string != null && string.length() != 0) continue;
            ++emptyCount;
        }
        if (emptyCount == 0) {
            stringArray = strings;
            if (strings == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.filterEmptyStrings must not return null");
            return stringArray;
        }
        String[] result = ArrayUtil.newStringArray(strings.length - emptyCount);
        int count = 0;
        for (String string : strings) {
            if (string == null || string.length() == 0) continue;
            result[count++] = string;
        }
        stringArray = result;
        if (result != null) return stringArray;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.filterEmptyStrings must not return null");
    }

    public static int countNewLines(@NotNull CharSequence text) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.countNewLines must not be null");
        }
        return StringUtil.countChars(text, '\n');
    }

    public static int countChars(@NotNull CharSequence text, char c) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.countChars must not be null");
        }
        int count = 0;
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            if (ch != c) continue;
            ++count;
        }
        return count;
    }

    @NotNull
    public static String capitalsOnly(@NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.capitalsOnly must not be null");
        }
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            if (!Character.isUpperCase(s.charAt(i))) continue;
            b.append(s.charAt(i));
        }
        String string = b.toString();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.capitalsOnly must not return null");
        }
        return string;
    }

    @Nullable
    public static String joinOrNull(String ... args) {
        if (args == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.joinOrNull must not be null");
        }
        StringBuilder r = new StringBuilder();
        for (String arg : args) {
            if (arg == null) {
                return null;
            }
            r.append(arg);
        }
        return r.toString();
    }

    @Nullable
    public static String getPropertyName(@NonNls @NotNull String methodName) {
        if (methodName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.getPropertyName must not be null");
        }
        if (methodName.startsWith("get")) {
            return Introspector.decapitalize(methodName.substring(3));
        }
        if (methodName.startsWith("is")) {
            return Introspector.decapitalize(methodName.substring(2));
        }
        if (methodName.startsWith("set")) {
            return Introspector.decapitalize(methodName.substring(3));
        }
        return null;
    }

    public static boolean isJavaIdentifierStart(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || Character.isJavaIdentifierStart(c);
    }

    public static boolean isJavaIdentifierPart(char c) {
        return c >= '0' && c <= '9' || StringUtil.isJavaIdentifierStart(c);
    }

    public static boolean isJavaIdentifier(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.isJavaIdentifier must not be null");
        }
        int len = text.length();
        if (len == 0) {
            return false;
        }
        if (!StringUtil.isJavaIdentifierStart(text.charAt(0))) {
            return false;
        }
        for (int i = 1; i < len; ++i) {
            if (StringUtil.isJavaIdentifierPart(text.charAt(i))) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static String shiftIndentInside(@NotNull String initial, int i, boolean shiftEmptyLines) throws IOException {
        if (initial == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.shiftIndentInside must not be null");
        }
        StringBuilder result = new StringBuilder(initial.length());
        LineReader reader = new LineReader(new ByteArrayInputStream(initial.getBytes()));
        boolean first = true;
        for (byte[] line : reader.readLines()) {
            try {
                if (!first) {
                    result.append('\n');
                }
                if (line.length > 0 || shiftEmptyLines) {
                    StringUtil.repeatSymbol(result, ' ', i);
                }
                result.append(new String(line));
            }
            finally {
                first = false;
            }
        }
        String string = result.toString();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.shiftIndentInside must not return null");
        }
        return string;
    }

    @NotNull
    public static String escapeProperty(@NotNull String input, boolean isKey) {
        if (input == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.escapeProperty must not be null");
        }
        StringBuilder escaped = new StringBuilder();
        block8: for (int i = 0; i < input.length(); ++i) {
            char ch = input.charAt(i);
            switch (ch) {
                case ' ': {
                    if (isKey && i == 0) {
                        escaped.append('\\');
                    }
                    escaped.append(' ');
                    continue block8;
                }
                case '\t': {
                    escaped.append("\\t");
                    continue block8;
                }
                case '\r': {
                    escaped.append("\\r");
                    continue block8;
                }
                case '\n': {
                    escaped.append("\\n");
                    continue block8;
                }
                case '\f': {
                    escaped.append("\\f");
                    continue block8;
                }
                case '!': 
                case '#': 
                case ':': 
                case '=': 
                case '\\': {
                    escaped.append('\\');
                    escaped.append(ch);
                    continue block8;
                }
                default: {
                    if ('\u0014' < ch && ch < '\u007f') {
                        escaped.append(ch);
                        continue block8;
                    }
                    escaped.append("\\u");
                    escaped.append(Character.forDigit(ch >> 12 & 0xF, 16));
                    escaped.append(Character.forDigit(ch >> 8 & 0xF, 16));
                    escaped.append(Character.forDigit(ch >> 4 & 0xF, 16));
                    escaped.append(Character.forDigit(ch & 0xF, 16));
                }
            }
        }
        String string = escaped.toString();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.escapeProperty must not return null");
        }
        return string;
    }

    public static String getQualifiedName(String packageName, String className) {
        if (packageName == null || packageName.length() == 0) {
            return className;
        }
        return packageName + '.' + className;
    }

    public static int compareVersionNumbers(@Nullable String v1, @Nullable String v2) {
        int idx;
        if (v1 == null && v2 == null) {
            return 0;
        }
        if (v1 == null) {
            return -1;
        }
        if (v2 == null) {
            return 1;
        }
        String[] part1 = v1.split("[\\.\\_\\-]");
        String[] part2 = v2.split("[\\.\\_\\-]");
        for (idx = 0; idx < part1.length && idx < part2.length; ++idx) {
            String p1 = part1[idx];
            String p2 = part2[idx];
            int cmp = p1.matches("\\d+") && p2.matches("\\d+") ? new Integer(p1).compareTo(new Integer(p2)) : part1[idx].compareTo(part2[idx]);
            if (cmp == 0) continue;
            return cmp;
        }
        if (part1.length == part2.length) {
            return 0;
        }
        if (part1.length > idx) {
            return 1;
        }
        return -1;
    }

    public static int parseInt(String string, int defaultValue) {
        try {
            return Integer.parseInt(string);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static double parseDouble(String string, double defaultValue) {
        try {
            return Double.parseDouble(string);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static int getOccurenceCount(@NotNull String text, char c) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.getOccurenceCount must not be null");
        }
        int res = 0;
        for (int i = 0; i < text.length() && (i = text.indexOf(c, i)) >= 0; ++i) {
            ++res;
        }
        return res;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static String fixVariableNameDerivedFromPropertyName(@NotNull String name) {
        String string;
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.fixVariableNameDerivedFromPropertyName must not be null");
        }
        char c = name.charAt(0);
        if (StringUtil.isVowel(c)) {
            string = "an" + Character.toUpperCase(c) + name.substring(1);
            if (string == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.fixVariableNameDerivedFromPropertyName must not return null");
            return string;
        }
        string = "a" + Character.toUpperCase(c) + name.substring(1);
        if (string != null) return string;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.fixVariableNameDerivedFromPropertyName must not return null");
    }

    public static String sanitizeJavaIdentifier(String name) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < name.length(); ++i) {
            char ch = name.charAt(i);
            if (!Character.isLetterOrDigit(ch)) continue;
            result.append(ch);
        }
        return result.toString();
    }

    public static void assertValidSeparators(@NotNull CharSequence s) {
        int i;
        if (s == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.assertValidSeparators must not be null");
        }
        char[] chars = CharArrayUtil.fromSequenceWithoutCopying(s);
        int slashRIndex = -1;
        if (chars != null) {
            int len = s.length();
            for (i = 0; i < len; ++i) {
                if (chars[i] != '\r') continue;
                slashRIndex = i;
                break;
            }
        } else {
            int len = s.length();
            for (i = 0; i < len; ++i) {
                if (s.charAt(i) != '\r') continue;
                slashRIndex = i;
                break;
            }
        }
        if (slashRIndex != -1) {
            String context = String.valueOf(StringUtil.last(s.subSequence(0, slashRIndex), 10, true)) + StringUtil.first(s.subSequence(slashRIndex, s.length()), 10, true);
            context = StringUtil.escapeStringCharacters(context);
            LOG.error("Wrong line separators: '" + context + "' at offset " + slashRIndex);
        }
    }

    @NotNull
    public static String tail(@NotNull String s, int idx) {
        if (s == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.tail must not be null");
        }
        String string = idx >= s.length() ? "" : s.substring(idx, s.length());
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.tail must not return null");
        }
        return string;
    }

    public static String[] splitByLines(String string) {
        return EOL_SPLIT_PATTERN.split(string);
    }

    public static List<Pair<String, Integer>> getWordsWithOffset(String s) {
        ArrayList<Pair<String, Integer>> res = Lists.newArrayList();
        s = s + " ";
        StringBuilder name = new StringBuilder();
        int startInd = -1;
        for (int i = 0; i < s.length(); ++i) {
            if (Character.isWhitespace(s.charAt(i))) {
                if (name.length() <= 0) continue;
                res.add(Pair.create(name.toString(), startInd));
                name.setLength(0);
                startInd = -1;
                continue;
            }
            if (startInd == -1) {
                startInd = i;
            }
            name.append(s.charAt(i));
        }
        return res;
    }

    public static int naturalCompare(String string1, String string2) {
        return StringUtil.naturalCompare(string1, string2, false);
    }

    private static int naturalCompare(String string1, String string2, boolean caseSensitive) {
        int string1Length = string1.length();
        int string2Length = string2.length();
        int i = 0;
        for (int j = 0; i < string1Length && j < string2Length; ++i, ++j) {
            int diff2;
            int diff1;
            char ch1 = string1.charAt(i);
            char ch2 = string2.charAt(j);
            if ((StringUtil.isDigit(ch1) || ch1 == ' ') && (StringUtil.isDigit(ch2) || ch2 == ' ')) {
                int lengthDiff;
                int startNum1 = i;
                while ((ch1 == ' ' || ch1 == '0') && ++startNum1 < string1Length) {
                    ch1 = string1.charAt(startNum1);
                }
                int startNum2 = j;
                while ((ch2 == ' ' || ch2 == '0') && ++startNum2 < string2Length) {
                    ch2 = string2.charAt(startNum2);
                }
                j = startNum2;
                for (i = startNum1; i < string1Length && StringUtil.isDigit(string1.charAt(i)); ++i) {
                }
                while (j < string2Length && StringUtil.isDigit(string2.charAt(j))) {
                    ++j;
                }
                String digits1 = string1.substring(startNum1, i);
                String digits2 = string2.substring(startNum2, j);
                if (digits1.length() != digits2.length()) {
                    return digits1.length() - digits2.length();
                }
                int numberDiff = digits1.compareTo(digits2);
                if (numberDiff != 0) {
                    return numberDiff;
                }
                if ((lengthDiff = --i - startNum1 - (--j - startNum2)) != 0) {
                    return lengthDiff;
                }
                while (startNum1 < i) {
                    int diff = string1.charAt(startNum1) - string2.charAt(startNum2);
                    if (diff != 0) {
                        return diff;
                    }
                    ++startNum1;
                    ++startNum2;
                }
                continue;
            }
            if (caseSensitive) {
                return ch1 - ch2;
            }
            if (ch1 == ch2 || (diff1 = Character.toUpperCase(ch1) - Character.toUpperCase(ch2)) == 0 || (diff2 = Character.toLowerCase(ch1) - Character.toLowerCase(ch2)) == 0) continue;
            return diff2;
        }
        if (!caseSensitive && string1Length == string2Length) {
            return StringUtil.naturalCompare(string1, string2, true);
        }
        return string1Length - string2Length;
    }

    private static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    public static int compare(@Nullable String s1, @Nullable String s2, boolean ignoreCase) {
        if (s1 == s2) {
            return 0;
        }
        if (s1 == null) {
            return -1;
        }
        if (s2 == null) {
            return 1;
        }
        return ignoreCase ? s1.compareToIgnoreCase(s2) : s1.compareTo(s2);
    }

    public static int comparePairs(@Nullable String s1, @Nullable String t1, @Nullable String s2, @Nullable String t2, boolean ignoreCase) {
        int compare = StringUtil.compare(s1, s2, ignoreCase);
        return compare != 0 ? compare : StringUtil.compare(t1, t2, ignoreCase);
    }

    public static int hashCode(@NotNull CharSequence s) {
        if (s == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.hashCode must not be null");
        }
        return StringUtil.stringHashCode(s);
    }

    public static boolean equals(@Nullable CharSequence s1, @Nullable CharSequence s2) {
        if (s1 == null ^ s2 == null) {
            return false;
        }
        if (s1 == null) {
            return true;
        }
        if (s1.length() != s2.length()) {
            return false;
        }
        for (int i = 0; i < s1.length(); ++i) {
            if (s1.charAt(i) == s2.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public static boolean equalsIgnoreCase(@Nullable CharSequence s1, @Nullable CharSequence s2) {
        if (s1 == null ^ s2 == null) {
            return false;
        }
        if (s1 == null) {
            return true;
        }
        if (s1.length() != s2.length()) {
            return false;
        }
        for (int i = 0; i < s1.length(); ++i) {
            if (StringUtil.charsMatch(s1.charAt(i), s2.charAt(i), true)) continue;
            return false;
        }
        return true;
    }

    public static boolean charsMatch(char c1, char c2, boolean ignoreCase) {
        if (c1 == c2) {
            return true;
        }
        if (ignoreCase) {
            char u2;
            char u1 = Character.toUpperCase(c1);
            if (u1 == (u2 = Character.toUpperCase(c2))) {
                return true;
            }
            if (Character.toLowerCase(u1) == Character.toLowerCase(u2)) {
                return true;
            }
        }
        return false;
    }

    public static String formatLinks(String message) {
        Pattern linkPattern = Pattern.compile("http://[a-zA-Z0-9\\./\\-\\+]+");
        StringBuffer result = new StringBuffer();
        Matcher m = linkPattern.matcher(message);
        while (m.find()) {
            m.appendReplacement(result, "<a href=\"" + m.group() + "\">" + m.group() + "</a>");
        }
        m.appendTail(result);
        return result.toString();
    }

    public static boolean isHexDigit(char c) {
        return '0' <= c && c <= '9' || 'a' <= c && c <= 'f' || 'A' <= c && c <= 'F';
    }

    public static boolean isOctalDigit(char c) {
        return '0' <= c && c <= '7';
    }

    @NotNull
    public static String shortenTextWithEllipsis(String text, int max_length, int suffix_length) {
        int prefix_length = max_length - suffix_length - 3;
        assert (prefix_length > 0);
        StringBuilder buffer = new StringBuilder();
        int textLength = text.length();
        if (textLength > max_length) {
            StringBuilder shorterText = new StringBuilder();
            shorterText.append(text.substring(0, prefix_length));
            shorterText.append("...");
            shorterText.append(text.substring(textLength - suffix_length));
            buffer.append(shorterText.toString());
        } else {
            buffer.append(text);
        }
        String string = buffer.toString();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.shortenTextWithEllipsis must not return null");
        }
        return string;
    }
}

