/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.openapi.util.registry;

import java.awt.Color;
import java.util.MissingResourceException;
import java.util.concurrent.CopyOnWriteArraySet;
import org.jetbrains.jet.internal.com.intellij.openapi.Disposable;
import org.jetbrains.jet.internal.com.intellij.openapi.util.Disposer;
import org.jetbrains.jet.internal.com.intellij.openapi.util.registry.Registry;
import org.jetbrains.jet.internal.com.intellij.openapi.util.registry.RegistryValueListener;

public class RegistryValue {
    private final Registry myRegistry;
    private final String myKey;
    private final CopyOnWriteArraySet<RegistryValueListener> myListeners = new CopyOnWriteArraySet();
    private boolean myChangedSinceStart;
    private String myStringCachedValue;
    private Integer myIntCachedValue;
    private Double myDoubleCachedValue;
    private Boolean myBooleanCachedValue;

    RegistryValue(Registry registry, String key) {
        this.myRegistry = registry;
        this.myKey = key;
    }

    public String getKey() {
        return this.myKey;
    }

    public String asString() {
        String value = this.get(this.myKey, null, true);
        assert (value != null) : this.myKey;
        return value;
    }

    public boolean asBoolean() {
        if (this.myBooleanCachedValue == null) {
            this.myBooleanCachedValue = Boolean.valueOf(this.get(this.myKey, "false", true));
        }
        return this.myBooleanCachedValue;
    }

    public int asInteger() {
        if (this.myIntCachedValue == null) {
            this.myIntCachedValue = Integer.valueOf(this.get(this.myKey, "0", true));
        }
        return this.myIntCachedValue;
    }

    public double asDouble() {
        if (this.myDoubleCachedValue == null) {
            this.myDoubleCachedValue = Double.valueOf(this.get(this.myKey, "0.0", true));
        }
        return this.myDoubleCachedValue;
    }

    public Color asColor(Color defaultValue) {
        String[] rgb;
        String s = this.get(this.myKey, null, true);
        if (s != null && (rgb = s.split(",")).length == 3) {
            try {
                return new Color(Integer.parseInt(rgb[0]), Integer.parseInt(rgb[1]), Integer.parseInt(rgb[2]));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public String getDescription() {
        return this.get(this.myKey + ".description", "", false);
    }

    public boolean isRestartRequired() {
        return Boolean.valueOf(this.get(this.myKey + ".restartRequired", "false", false));
    }

    public boolean isChangedFromDefault() {
        return !this.getBundleValue(this.myKey, true).equals(this.asString());
    }

    private String get(String key, String defaultValue, boolean isValue) {
        if (isValue) {
            if (this.myStringCachedValue == null) {
                this.myStringCachedValue = this._get(key, defaultValue, isValue);
            }
            return this.myStringCachedValue;
        }
        return this._get(key, defaultValue, isValue);
    }

    private String _get(String key, String defaultValue, boolean mustExistInBundle) {
        String userValue = this.myRegistry.getUserProperties().get(key);
        if (userValue == null) {
            String systemProperty = System.getProperty(key);
            if (systemProperty != null) {
                return systemProperty;
            }
            String bundleValue = this.getBundleValue(key, mustExistInBundle);
            if (bundleValue != null) {
                return bundleValue;
            }
            return defaultValue;
        }
        return userValue;
    }

    private String getBundleValue(String key, boolean mustExist) {
        try {
            RegistryValue registryValue = this;
            return registryValue.myRegistry.getBundle().getString(key);
        }
        catch (MissingResourceException e) {
            if (mustExist) {
                throw e;
            }
            return null;
        }
    }

    public void setValue(boolean value) {
        this.setValue(Boolean.valueOf(value).toString());
    }

    public void setValue(int value) {
        this.setValue(Integer.valueOf(value).toString());
    }

    public void setValue(String value) {
        this.resetCache();
        for (RegistryValueListener each : this.myListeners) {
            each.beforeValueChanged(this);
        }
        this.myRegistry.getUserProperties().put(this.myKey, value);
        for (RegistryValueListener each : this.myListeners) {
            each.afterValueChanged(this);
        }
        if (!this.isChangedFromDefault()) {
            this.myRegistry.getUserProperties().remove(this.myKey);
        }
        this.myChangedSinceStart = true;
    }

    public boolean isChangedSinceAppStart() {
        return this.myChangedSinceStart;
    }

    public void resetToDefault() {
        this.setValue(this.getBundleValue(this.myKey, true));
    }

    public void addListener(final RegistryValueListener listener, Disposable parent) {
        this.myListeners.add(listener);
        Disposer.register(parent, new Disposable(){

            @Override
            public void dispose() {
                RegistryValue.this.myListeners.remove(listener);
            }
        });
    }

    public String toString() {
        return this.myKey + "=" + this.asString();
    }

    void resetCache() {
        this.myStringCachedValue = null;
        this.myIntCachedValue = null;
        this.myBooleanCachedValue = null;
    }

    public boolean isBoolean() {
        return "true".equals(this.myStringCachedValue) || "false".equals(this.myStringCachedValue);
    }
}

