/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.openapi.util.objectTree;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.jet.internal.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.jet.internal.com.intellij.openapi.progress.ProcessCanceledException;
import org.jetbrains.jet.internal.com.intellij.openapi.util.Disposer;
import org.jetbrains.jet.internal.com.intellij.openapi.util.objectTree.ObjectTree;
import org.jetbrains.jet.internal.com.intellij.openapi.util.objectTree.ObjectTreeAction;

public final class ObjectNode<T> {
    private static final ObjectNode[] EMPTY_ARRAY = new ObjectNode[0];
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.util.objectTree.ObjectNode");
    private final ObjectTree<T> myTree;
    private ObjectNode<T> myParent;
    private final T myObject;
    private LinkedHashSet<ObjectNode<T>> myChildren;
    private final Throwable myTrace;
    private final long myOwnModification;
    private long myChildModification;

    public ObjectNode(ObjectTree<T> tree, ObjectNode<T> parentNode, T object, long modification) {
        this.myTree = tree;
        this.myParent = parentNode;
        this.myObject = object;
        this.myTrace = Disposer.isDebugMode() ? new Throwable() : null;
        this.myOwnModification = modification;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ObjectNode<T>[] getChildrenArray() {
        Object object = this.myTree.treeLock;
        synchronized (object) {
            if (this.myChildren == null || this.myChildren.isEmpty()) {
                return EMPTY_ARRAY;
            }
            return this.myChildren.toArray(new ObjectNode[this.myChildren.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChild(ObjectNode<T> child) {
        Object object = this.myTree.treeLock;
        synchronized (object) {
            this.ensureChildArray();
            super.setParent(this);
            this.myChildren.add(child);
            this.myTree.putNode(child.getObject(), child);
            this.propagateChildModification(child.getModification());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChild(ObjectNode<T> child) {
        Object object = this.myTree.treeLock;
        synchronized (object) {
            assert (this.myChildren != null) : "No children to remove child: " + this + ' ' + child;
            if (this.myChildren.remove(child)) {
                super.setParent(null);
                this.myTree.putNode(child.getObject(), null);
                this.propagateChildModification(this.myTree.getNextModification());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setParent(ObjectNode<T> parent) {
        Object object = this.myTree.treeLock;
        synchronized (object) {
            this.myParent = parent;
        }
    }

    public ObjectNode<T> getParent() {
        return this.myParent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<ObjectNode<T>> getChildren() {
        Object object = this.myTree.treeLock;
        synchronized (object) {
            if (this.myChildren == null) {
                return Collections.emptyList();
            }
            return Collections.unmodifiableCollection(this.myChildren);
        }
    }

    private void ensureChildArray() {
        if (this.myChildren == null) {
            this.myChildren = new LinkedHashSet();
        }
    }

    boolean execute(final boolean disposeTree, final ObjectTreeAction<T> action) {
        ObjectTree.executeActionWithRecursiveGuard(this, new ObjectTreeAction<ObjectNode<T>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void execute(ObjectNode<T> each) {
                action.beforeTreeExecution(ObjectNode.this.myObject);
                ObjectNode[] childrenArray = ObjectNode.this.getChildrenArray();
                for (int i = childrenArray.length - 1; i >= 0; --i) {
                    childrenArray[i].execute(disposeTree, action);
                }
                if (disposeTree) {
                    Object i = ((ObjectNode)ObjectNode.this).myTree.treeLock;
                    synchronized (i) {
                        ObjectNode.this.myChildren = null;
                    }
                }
                try {
                    action.execute(ObjectNode.this.myObject);
                    ObjectNode.this.myTree.fireExecuted(ObjectNode.this.myObject);
                }
                catch (ProcessCanceledException e) {
                    throw new ProcessCanceledException(e);
                }
                catch (Throwable e) {
                    LOG.error(e);
                }
                if (disposeTree) {
                    ObjectNode.this.myTree.putNode(ObjectNode.this.myObject, null);
                    Object object = ((ObjectNode)ObjectNode.this).myTree.treeLock;
                    synchronized (object) {
                        if (ObjectNode.this.myParent != null) {
                            ObjectNode.this.myParent.removeChild(ObjectNode.this);
                        } else {
                            ObjectNode.this.myTree.removeRootObject(ObjectNode.this.myObject);
                        }
                    }
                }
            }

            @Override
            public void beforeTreeExecution(ObjectNode<T> parent) {
            }
        }, this.myTree.getNodesInExecution());
        return true;
    }

    public T getObject() {
        return this.myObject;
    }

    @NonNls
    public String toString() {
        return "Node: " + this.myObject.toString();
    }

    Throwable getTrace() {
        return this.myTrace;
    }

    void assertNoReferencesKept(T aDisposable) {
        assert (this.getObject() != aDisposable);
        if (this.myChildren != null) {
            for (ObjectNode objectNode : this.myChildren) {
                objectNode.assertNoReferencesKept(aDisposable);
            }
        }
    }

    public Throwable getAllocation() {
        return this.myTrace;
    }

    public long getOwnModification() {
        return this.myOwnModification;
    }

    public long getChildModification() {
        return this.myChildModification;
    }

    private void propagateChildModification(long stamp) {
        if (this.myChildModification < stamp) {
            this.myChildModification = stamp;
            if (this.getParent() != null) {
                super.propagateChildModification(stamp);
            }
        }
    }

    public long getModification() {
        return Math.max(this.getOwnModification(), this.getChildModification());
    }
}

