/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.openapi.util.io;

import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;

public class StreamUtil {
    private StreamUtil() {
    }

    public static int copyStreamContent(InputStream inputStream, OutputStream outputStream) throws IOException {
        int count;
        byte[] buffer = new byte[10240];
        int total = 0;
        while ((count = inputStream.read(buffer)) > 0) {
            outputStream.write(buffer, 0, count);
            total += count;
        }
        return total;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] loadFromStream(InputStream inputStream) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            StreamUtil.copyStreamContent(inputStream, outputStream);
        }
        finally {
            inputStream.close();
        }
        return outputStream.toByteArray();
    }

    public static String readText(InputStream inputStream) throws IOException {
        byte[] data = StreamUtil.loadFromStream(inputStream);
        return new String(data);
    }

    public static String readText(InputStream inputStream, String encoding) throws IOException {
        byte[] data = StreamUtil.loadFromStream(inputStream);
        return new String(data, encoding);
    }

    public static String convertSeparators(String s) {
        try {
            return new String(StreamUtil.readTextAndConvertSeparators(new StringReader(s)));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static char[] readTextAndConvertSeparators(Reader reader) throws IOException {
        char[] buffer = StreamUtil.readText(reader);
        int dst = 0;
        int prev = 32;
        for (int n : buffer) {
            switch (n) {
                case 13: {
                    buffer[dst++] = 10;
                    break;
                }
                case 10: {
                    if (prev == 13) break;
                    buffer[dst++] = 10;
                    break;
                }
                default: {
                    buffer[dst++] = n;
                }
            }
            prev = n;
        }
        char[] chars = new char[dst];
        System.arraycopy(buffer, 0, chars, 0, chars.length);
        return chars;
    }

    public static String readTextFrom(Reader reader) throws IOException {
        return new String(StreamUtil.readText(reader));
    }

    private static char[] readText(Reader reader) throws IOException {
        int read;
        CharArrayWriter writer = new CharArrayWriter();
        char[] buffer = new char[2048];
        while ((read = reader.read(buffer)) >= 0) {
            writer.write(buffer, 0, read);
        }
        return writer.toCharArray();
    }
}

