/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.openapi.util.io;

import java.io.File;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.jet.internal.com.intellij.openapi.util.SystemInfo;
import org.jetbrains.jet.internal.com.intellij.util.ArrayUtil;
import org.jetbrains.jet.internal.com.sun.jna.Library;
import org.jetbrains.jet.internal.com.sun.jna.Memory;
import org.jetbrains.jet.internal.com.sun.jna.Native;
import org.jetbrains.jet.internal.com.sun.jna.Pointer;

public class FileSystemUtil {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.util.io.FileSystemUtil");
    @Nullable
    private static final Mediator ourMediator;

    private FileSystemUtil() {
    }

    public static boolean isSymLink(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/io/FileSystemUtil.isSymLink must not be null");
        }
        try {
            return ourMediator != null && ourMediator.isSymLink(path);
        }
        catch (Exception e) {
            LOG.warn(e);
            return false;
        }
    }

    public static boolean isSymLink(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/io/FileSystemUtil.isSymLink must not be null");
        }
        return FileSystemUtil.isSymLink(file.getAbsolutePath());
    }

    @Nullable
    public static String resolveSymLink(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/io/FileSystemUtil.resolveSymLink must not be null");
        }
        if (ourMediator != null) {
            try {
                String realPath = ourMediator.resolveSymLink(path);
                if (realPath != null && new File(realPath).exists()) {
                    return realPath;
                }
            }
            catch (Exception e) {
                LOG.warn(e);
            }
        }
        return null;
    }

    @Nullable
    public static String resolveSymLink(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/io/FileSystemUtil.resolveSymLink must not be null");
        }
        return FileSystemUtil.resolveSymLink(file.getAbsolutePath());
    }

    public static int getPermissions(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/io/FileSystemUtil.getPermissions must not be null");
        }
        if (SystemInfo.isUnix && ourMediator != null) {
            try {
                return ourMediator.getPermissions(path);
            }
            catch (Exception e) {
                LOG.warn(e);
            }
        }
        return -1;
    }

    public static int getPermissions(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/io/FileSystemUtil.getPermissions must not be null");
        }
        return FileSystemUtil.getPermissions(file.getAbsolutePath());
    }

    public static void setPermissions(@NotNull String path, int permissions) {
        if (path == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/io/FileSystemUtil.setPermissions must not be null");
        }
        if (SystemInfo.isUnix && ourMediator != null) {
            try {
                ourMediator.setPermissions(path, permissions);
            }
            catch (Exception e) {
                LOG.warn(e);
            }
        }
    }

    public static void setPermissions(@NotNull File file, int permissions) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/io/FileSystemUtil.setPermissions must not be null");
        }
        FileSystemUtil.setPermissions(file.getAbsolutePath(), permissions);
    }

    static {
        Mediator mediator = null;
        if (SystemInfo.areSymLinksSupported) {
            if (SystemInfo.isJavaVersionAtLeast("1.7")) {
                try {
                    mediator = new Jdk7MediatorImpl();
                    mediator.isSymLink("/");
                }
                catch (Throwable t) {
                    if ("1.7.0-ea".equals(SystemInfo.JAVA_VERSION)) {
                        LOG.warn(t);
                    } else {
                        LOG.error(t);
                    }
                    mediator = null;
                }
            }
            if (mediator == null && (SystemInfo.isLinux || SystemInfo.isMac || SystemInfo.isSolaris || SystemInfo.isFreeBSD)) {
                try {
                    mediator = new JnaUnixMediatorImpl();
                    mediator.isSymLink("/");
                }
                catch (Throwable t) {
                    LOG.error(t);
                    mediator = null;
                }
            }
        }
        ourMediator = mediator;
    }

    private static class JnaUnixMediatorImpl
    implements Mediator {
        private final LibC myLibC = (LibC)Native.loadLibrary("c", LibC.class);
        private final Memory mySharedMem = new Memory(512L);
        private final int myOffset;

        private JnaUnixMediatorImpl() throws Exception {
            int n = SystemInfo.isLinux ? (SystemInfo.is32Bit ? 16 : 24) : (SystemInfo.isMac | SystemInfo.isFreeBSD ? 8 : (SystemInfo.isSolaris ? (SystemInfo.is32Bit ? 20 : 16) : (this.myOffset = -1)));
            if (this.myOffset < 0) {
                throw new IllegalStateException("Unsupported OS: " + SystemInfo.OS_NAME);
            }
        }

        private synchronized int getMode(String path) {
            int res;
            this.mySharedMem.clear();
            int n = res = SystemInfo.isLinux ? this.myLibC.__lxstat64(0, path, this.mySharedMem) : this.myLibC.lstat(path, this.mySharedMem);
            if (res == 0) {
                return (SystemInfo.isLinux ? this.mySharedMem.getInt(this.myOffset) : (int)this.mySharedMem.getShort(this.myOffset)) & 0xFFFF;
            }
            LOG.debug("lstat(" + path + "): " + res);
            return -1;
        }

        @Override
        public boolean isSymLink(@NotNull String path) throws Exception {
            if (path == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/io/FileSystemUtil$JnaUnixMediatorImpl.isSymLink must not be null");
            }
            int mode = this.getMode(path);
            return mode != -1 && (mode & 0xA000) == 40960;
        }

        @Override
        public String resolveSymLink(@NotNull String path) throws Exception {
            if (path == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/io/FileSystemUtil$JnaUnixMediatorImpl.resolveSymLink must not be null");
            }
            return new File(path).getCanonicalPath();
        }

        @Override
        public int getPermissions(@NotNull String path) throws Exception {
            if (path == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/io/FileSystemUtil$JnaUnixMediatorImpl.getPermissions must not be null");
            }
            int mode = this.getMode(path);
            return mode != -1 ? mode & 0x1FF : -1;
        }

        @Override
        public void setPermissions(@NotNull String path, int permissions) throws Exception {
            if (path == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/io/FileSystemUtil$JnaUnixMediatorImpl.setPermissions must not be null");
            }
            this.myLibC.chmod(path, permissions & 0x1FF);
        }

        private static interface LibC
        extends Library {
            public static final int S_MASK = 65535;
            public static final int S_IFLNK = 40960;
            public static final int PERM_MASK = 511;

            public int lstat(String var1, Pointer var2);

            public int __lxstat64(int var1, String var2, Pointer var3);

            public int chmod(String var1, int var2);
        }
    }

    private static class Jdk7MediatorImpl
    implements Mediator {
        private final Object myDefaultFileSystem = Class.forName("java.nio.file.FileSystems").getMethod("getDefault", new Class[0]).invoke(null, new Object[0]);
        private final Method myGetPath = Class.forName("java.nio.file.FileSystem").getMethod("getPath", String.class, String[].class);
        private final Method myIsSymbolicLink;
        private final Object myLinkOptions;
        private final Object myNoFollowLinkOptions;
        private final Method myGetAttribute;
        private final Method mySetAttribute;
        private static final Map<String, Integer> ATTRIBUTES_MAP = new HashMap<String, Integer>();

        private Jdk7MediatorImpl() throws Exception {
            this.myGetPath.setAccessible(true);
            Class<?> pathClass = Class.forName("java.nio.file.Path");
            this.myIsSymbolicLink = Class.forName("java.nio.file.Files").getMethod("isSymbolicLink", pathClass);
            this.myIsSymbolicLink.setAccessible(true);
            Class<?> linkOptClass = Class.forName("java.nio.file.LinkOption");
            this.myLinkOptions = Array.newInstance(linkOptClass, 0);
            this.myNoFollowLinkOptions = Array.newInstance(linkOptClass, 1);
            Array.set(this.myNoFollowLinkOptions, 0, linkOptClass.getField("NOFOLLOW_LINKS").get(null));
            Class<?> linkOptArrClass = this.myLinkOptions.getClass();
            this.myGetAttribute = Class.forName("java.nio.file.Files").getMethod("getAttribute", pathClass, String.class, linkOptArrClass);
            this.mySetAttribute = Class.forName("java.nio.file.Files").getMethod("setAttribute", pathClass, String.class, Object.class, linkOptArrClass);
        }

        @Override
        public boolean isSymLink(@NotNull String path) throws Exception {
            if (path == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/io/FileSystemUtil$Jdk7MediatorImpl.isSymLink must not be null");
            }
            Object pathObj = this.myGetPath.invoke(this.myDefaultFileSystem, path, ArrayUtil.EMPTY_STRING_ARRAY);
            return (Boolean)this.myIsSymbolicLink.invoke(null, pathObj);
        }

        @Override
        public String resolveSymLink(@NotNull String path) throws Exception {
            if (path == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/io/FileSystemUtil$Jdk7MediatorImpl.resolveSymLink must not be null");
            }
            if (!new File(path).exists()) {
                return null;
            }
            Object pathObj = this.myGetPath.invoke(this.myDefaultFileSystem, path, ArrayUtil.EMPTY_STRING_ARRAY);
            Method toRealPath = pathObj.getClass().getMethod("toRealPath", this.myLinkOptions.getClass());
            toRealPath.setAccessible(true);
            return toRealPath.invoke(pathObj, this.myLinkOptions).toString();
        }

        @Override
        public int getPermissions(@NotNull String path) throws Exception {
            if (path == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/io/FileSystemUtil$Jdk7MediatorImpl.getPermissions must not be null");
            }
            Object pathObj = this.myGetPath.invoke(this.myDefaultFileSystem, path, ArrayUtil.EMPTY_STRING_ARRAY);
            Object attribute = this.myGetAttribute.invoke(null, pathObj, "posix:permissions", this.myNoFollowLinkOptions);
            return Jdk7MediatorImpl.decodePermissions(attribute);
        }

        @Override
        public void setPermissions(@NotNull String path, int permissions) throws Exception {
            if (path == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/io/FileSystemUtil$Jdk7MediatorImpl.setPermissions must not be null");
            }
            Object pathObj = this.myGetPath.invoke(this.myDefaultFileSystem, path, ArrayUtil.EMPTY_STRING_ARRAY);
            Object attribute = Jdk7MediatorImpl.encodePermissions(permissions);
            if (attribute != null) {
                this.mySetAttribute.invoke(null, pathObj, "posix:permissions", attribute, this.myLinkOptions);
            }
        }

        private static int decodePermissions(Object o) {
            if (!(o instanceof Collection)) {
                return -1;
            }
            int value = 0;
            for (Object attr : (Collection)o) {
                Integer bit = ATTRIBUTES_MAP.get(attr.toString());
                if (bit == null) continue;
                value |= bit.intValue();
            }
            return value;
        }

        @Nullable
        private static Object encodePermissions(int value) {
            try {
                Class<?> aClass = Class.forName("java.nio.file.attribute.PosixFilePermission");
                HashSet values = new HashSet();
                for (Map.Entry<String, Integer> entry : ATTRIBUTES_MAP.entrySet()) {
                    if ((value & entry.getValue()) <= 0) continue;
                    String name = entry.getKey();
                    values.add(Enum.valueOf(aClass, name));
                }
                return values;
            }
            catch (Exception exception) {
                return null;
            }
        }

        static {
            ATTRIBUTES_MAP.put("OWNER_READ", 256);
            ATTRIBUTES_MAP.put("OWNER_WRITE", 128);
            ATTRIBUTES_MAP.put("OWNER_EXECUTE", 64);
            ATTRIBUTES_MAP.put("GROUP_READ", 32);
            ATTRIBUTES_MAP.put("GROUP_WRITE", 16);
            ATTRIBUTES_MAP.put("GROUP_EXECUTE", 8);
            ATTRIBUTES_MAP.put("OTHERS_READ", 4);
            ATTRIBUTES_MAP.put("OTHERS_WRITE", 2);
            ATTRIBUTES_MAP.put("OTHERS_EXECUTE", 1);
        }
    }

    private static interface Mediator {
        public boolean isSymLink(@NotNull String var1) throws Exception;

        @Nullable
        public String resolveSymLink(@NotNull String var1) throws Exception;

        public int getPermissions(@NotNull String var1) throws Exception;

        public void setPermissions(@NotNull String var1, int var2) throws Exception;
    }
}

