/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.openapi.util;

import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.intellij.openapi.util.Key;
import org.jetbrains.jet.internal.com.intellij.openapi.util.UserDataHolderEx;
import org.jetbrains.jet.internal.com.intellij.util.concurrency.AtomicFieldUpdater;
import org.jetbrains.jet.internal.com.intellij.util.containers.StripedLockConcurrentHashMap;

public class UserDataHolderBase
implements Cloneable,
UserDataHolderEx {
    private static final Key<Map<Key, Object>> COPYABLE_USER_MAP_KEY = Key.create("COPYABLE_USER_MAP_KEY");
    private volatile ConcurrentMap<Key, Object> myUserMap = null;
    private static final AtomicFieldUpdater<UserDataHolderBase, ConcurrentMap> updater = AtomicFieldUpdater.forFieldOfType(UserDataHolderBase.class, ConcurrentMap.class);

    protected Object clone() {
        try {
            UserDataHolderBase clone = (UserDataHolderBase)super.clone();
            clone.myUserMap = null;
            this.copyCopyableDataTo(clone);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public String getUserDataString() {
        ConcurrentMap<Key, Object> userMap = this.myUserMap;
        if (userMap == null) {
            return "";
        }
        Map<Key, Object> copyableMap = this.getUserData(COPYABLE_USER_MAP_KEY);
        return userMap.toString() + (copyableMap == null ? "" : copyableMap.toString());
    }

    public void copyUserDataTo(UserDataHolderBase other) {
        ConcurrentMap<Key, Object> map = this.myUserMap;
        if (map == null) {
            other.myUserMap = null;
        } else {
            ConcurrentMap<Key, Object> fresh = UserDataHolderBase.createDataMap(map.size());
            fresh.putAll(map);
            other.myUserMap = fresh;
        }
    }

    @Override
    public <T> T getUserData(@NotNull Key<T> key) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/UserDataHolderBase.getUserData must not be null");
        }
        ConcurrentMap<Key, Object> map = this.myUserMap;
        return map == null ? null : (T)map.get(key);
    }

    @Override
    public <T> void putUserData(@NotNull Key<T> key, @Nullable T value) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/UserDataHolderBase.putUserData must not be null");
        }
        while (true) {
            try {
                if (value == null) {
                    boolean removed;
                    ConcurrentMap<Key, Object> map = this.myUserMap;
                    if (map == null) break;
                    Object previous = map.remove(key);
                    boolean bl = removed = previous != null;
                    if (!removed) break;
                    this.nullifyMapFieldIfEmpty();
                    break;
                }
                this.getOrCreateMap().put(key, value);
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                continue;
            }
            break;
        }
    }

    private static ConcurrentMap<Key, Object> createDataMap(int initialCapacity) {
        return new StripedLockConcurrentHashMap<Key, Object>(initialCapacity);
    }

    public <T> T getCopyableUserData(Key<T> key) {
        return this.getCopyableUserDataImpl(key);
    }

    protected final <T> T getCopyableUserDataImpl(Key<T> key) {
        Map<Key, Object> map = this.getUserData(COPYABLE_USER_MAP_KEY);
        return (T)(map == null ? null : map.get(key));
    }

    public <T> void putCopyableUserData(Key<T> key, T value) {
        this.putCopyableUserDataImpl(key, value);
    }

    private Map<Key, Object> getOrCreateCopyableMap(boolean create) {
        Map<Key, Object> copyMap = this.getUserData(COPYABLE_USER_MAP_KEY);
        if (copyMap == null && create) {
            copyMap = UserDataHolderBase.createDataMap(1);
            copyMap = this.putUserDataIfAbsent(COPYABLE_USER_MAP_KEY, copyMap);
        }
        return copyMap;
    }

    protected final <T> void putCopyableUserDataImpl(Key<T> key, T value) {
        block2: while (true) {
            try {
                Map<Key, Object> copyMap;
                while ((copyMap = this.getOrCreateCopyableMap(value != null)) != null) {
                    if (value == null) {
                        ConcurrentMap<Key, Object> newCopyMap;
                        copyMap.remove(key);
                        if (!copyMap.isEmpty()) break block2;
                        ((StripedLockConcurrentHashMap)copyMap).blockModification();
                        if (copyMap.isEmpty()) {
                            newCopyMap = null;
                        } else {
                            newCopyMap = UserDataHolderBase.createDataMap(copyMap.size());
                            newCopyMap.putAll(copyMap);
                        }
                        boolean replaced = this.replace(COPYABLE_USER_MAP_KEY, copyMap, newCopyMap);
                        if (replaced) break block2;
                        continue;
                    }
                    copyMap.put(key, value);
                    break block2;
                }
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                continue;
            }
            break;
        }
    }

    private ConcurrentMap<Key, Object> getOrCreateMap() {
        ConcurrentMap<Key, Object> map;
        boolean updated;
        do {
            if ((map = this.myUserMap) == null) continue;
            return map;
        } while (!(updated = updater.compareAndSet(this, null, map = UserDataHolderBase.createDataMap(2))));
        return map;
    }

    @Override
    public <T> boolean replace(@NotNull Key<T> key, @Nullable T oldValue, @Nullable T newValue) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/UserDataHolderBase.replace must not be null");
        }
        while (true) {
            try {
                ConcurrentMap<Key, Object> map = this.getOrCreateMap();
                if (oldValue == null) {
                    return newValue == null || map.putIfAbsent(key, newValue) == null;
                }
                if (newValue == null) {
                    boolean removed = map.remove(key, oldValue);
                    if (removed) {
                        this.nullifyMapFieldIfEmpty();
                    }
                    return removed;
                }
                return map.replace(key, oldValue, newValue);
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                continue;
            }
            break;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @NotNull
    public <T> T putUserDataIfAbsent(@NotNull Key<T> key, @NotNull T value) {
        Object object;
        Object object2;
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/UserDataHolderBase.putUserDataIfAbsent must not be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/UserDataHolderBase.putUserDataIfAbsent must not be null");
        }
        Object v = this.getOrCreateMap().get(key);
        if (v != null) {
            object2 = v;
            if (object2 == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/util/UserDataHolderBase.putUserDataIfAbsent must not return null");
            return (T)object2;
        }
        while (true) {
            try {
                Object prev = this.getOrCreateMap().putIfAbsent(key, value);
                if (prev == null) {
                    object = value;
                    break;
                }
                object = prev;
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                continue;
            }
            break;
        }
        object2 = object;
        if (object != null) return (T)object2;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/util/UserDataHolderBase.putUserDataIfAbsent must not return null");
    }

    public void copyCopyableDataTo(@NotNull UserDataHolderBase clone) {
        if (clone == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/UserDataHolderBase.copyCopyableDataTo must not be null");
        }
        Map<Key, Object> copyableMap = this.getUserData(COPYABLE_USER_MAP_KEY);
        if (copyableMap != null) {
            ConcurrentMap<Key, Object> copy = UserDataHolderBase.createDataMap(copyableMap.size());
            copy.putAll(copyableMap);
            copyableMap = copy;
        }
        clone.putUserData(COPYABLE_USER_MAP_KEY, copyableMap);
    }

    protected void clearUserData() {
        this.myUserMap = null;
    }

    private void nullifyMapFieldIfEmpty() {
        try {
            StripedLockConcurrentHashMap map;
            while ((map = (StripedLockConcurrentHashMap)this.myUserMap) != null && map.isEmpty()) {
                boolean replaced;
                ConcurrentMap<Key, Object> newMap;
                map.blockModification();
                if (map.isEmpty()) {
                    newMap = null;
                } else {
                    newMap = UserDataHolderBase.createDataMap(map.size());
                    newMap.putAll(map);
                }
                if (!(replaced = updater.compareAndSet(this, map, newMap))) continue;
                break;
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
    }
}

